/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.webservices;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.accounts.pos.Pos;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.services.ServiceClient;
import nl.strohalm.cyclos.entities.services.ServiceOperation;
import nl.strohalm.cyclos.services.access.ChannelService;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.logging.WebServiceLogDTO;
import nl.strohalm.cyclos.webservices.utils.WebServiceHelper;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class WebServiceContext {
    private static final ThreadLocal<WebServiceContext> HOLDER = new ThreadLocal();
    private Member member;
    private ServiceClient client;
    private Pos pos;
    private Channel channel;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private ServletContext servletContext;
    private SoapMessage soapMessage;
    private ContextType contextType;
    private Object parameter;
    private String serviceName;
    private String methodName;

    public static void cleanup() {
        WebServiceContext context = HOLDER.get();
        if (context != null) {
            context.client = null;
            context.pos = null;
            context.member = null;
            context.channel = null;
            context.request = null;
            context.servletContext = null;
            context.soapMessage = null;
        }
        HOLDER.remove();
        LoggedUser.cleanup();
    }

    public static Channel getChannel() {
        return WebServiceContext.assertContext(null).channel;
    }

    public static ServiceClient getClient() {
        return WebServiceContext.assertContext((ContextType)ContextType.SERVICE_CLIENT).client;
    }

    public static ContextType getContextType() {
        WebServiceContext context = HOLDER.get();
        return context == null ? null : context.contextType;
    }

    public static Member getMember() {
        return WebServiceContext.assertContext(null).member;
    }

    public static String getMethodName() {
        return WebServiceContext.assertContext(null).methodName;
    }

    public static <T> T getParameter() {
        return (T)WebServiceContext.assertContext(null).parameter;
    }

    public static Pos getPos() {
        return WebServiceContext.assertContext((ContextType)ContextType.POS).pos;
    }

    public static HttpServletRequest getRequest() {
        return WebServiceContext.assertContext(null).request;
    }

    public static HttpServletResponse getResponse() {
        return WebServiceContext.assertContext(null).response;
    }

    public static String getServiceName() {
        return WebServiceContext.assertContext(null).serviceName;
    }

    public static ServletContext getServletContext() {
        return WebServiceContext.assertContext(null).servletContext;
    }

    public static SoapMessage getSoapMessage() {
        return WebServiceContext.assertContext(null).soapMessage;
    }

    public static boolean hasPermission(ServiceOperation operation) {
        return WebServiceContext.getClient().getPermissions().contains(operation);
    }

    public static boolean isInitialized() {
        return HOLDER.get() != null;
    }

    public static boolean isPosContext() {
        return WebServiceContext.assertContext(null).isPosContextType();
    }

    public static boolean isReadyForUse() {
        return WebServiceContext.isInitialized() && WebServiceContext.HOLDER.get().contextType != null;
    }

    public static WebServiceLogDTO newLog() {
        WebServiceLogDTO log = new WebServiceLogDTO();
        WebServiceContext context = HOLDER.get();
        if (context != null) {
            log.setPos(context.pos);
            log.setServiceClient(context.client);
            log.setRemoteAddress(context.request == null ? null : context.request.getRemoteAddr());
            log.setServiceName(context.serviceName);
            log.setMethodName(context.methodName);
            log.setParameter(context.parameter);
        }
        return log;
    }

    public static void set(Member member, ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) {
        HOLDER.set(new WebServiceContext(member, servletContext, request, response));
    }

    public static void set(Pos pos, ServletContext servletContext, HttpServletRequest request, SoapMessage soapMessage) {
        HOLDER.set(new WebServiceContext(pos, servletContext, request, soapMessage));
    }

    public static void set(ServiceClient client, ServletContext servletContext, HttpServletRequest request, SoapMessage soapMessage) {
        HOLDER.set(new WebServiceContext(client, servletContext, request, soapMessage));
    }

    public static void set(ServletContext servletContextOf, HttpServletRequest requestOf, SoapMessage message) {
        HOLDER.set(new WebServiceContext((Member)null, servletContextOf, requestOf, message));
    }

    public static void setRestMember(Member member) {
        WebServiceContext.assertContext((ContextType)ContextType.REST).member = member;
    }

    private static WebServiceContext assertContext(ContextType requiredCtx) {
        WebServiceContext context = HOLDER.get();
        if (context == null) {
            throw new IllegalStateException("The web service context was not initialized yet");
        }
        if (requiredCtx != null && requiredCtx != context.contextType) {
            throw new IllegalStateException(String.format("Invalid invocation: context type: %1$s", new Object[]{context.contextType}));
        }
        return context;
    }

    private WebServiceContext(Member member, ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) {
        this.member = member;
        this.request = request;
        this.response = response;
        this.servletContext = servletContext;
        this.contextType = ContextType.REST;
        this.channel = this.loadChannel("rest");
        String uri = request.getRequestURI();
        String contextPath = request.getContextPath();
        int pos = StringUtils.isEmpty((String)contextPath) ? -1 : uri.indexOf(contextPath);
        this.serviceName = pos < 0 ? uri : uri.substring(contextPath.length() + 1);
    }

    private WebServiceContext(Member member, ServletContext servletContext, HttpServletRequest request, SoapMessage soapMessage) {
        this.member = member;
        this.request = request;
        this.servletContext = servletContext;
        this.soapMessage = soapMessage;
        this.initParameter();
        this.initServiceName();
        this.initOperationName();
    }

    private WebServiceContext(Pos pos, ServletContext servletContext, HttpServletRequest request, SoapMessage soapMessage) {
        this(pos.getMemberPos().getMember(), servletContext, request, soapMessage);
        this.pos = pos;
        this.channel = this.loadChannel("pos");
        this.contextType = ContextType.POS;
    }

    private WebServiceContext(ServiceClient client, ServletContext servletContext, HttpServletRequest request, SoapMessage soapMessage) {
        this(client.getMember(), servletContext, request, soapMessage);
        this.client = client;
        this.channel = client.getChannel();
        this.contextType = ContextType.SERVICE_CLIENT;
    }

    private void initOperationName() {
        MessageInfo messageInfo = (MessageInfo)this.soapMessage.get(MessageInfo.class);
        OperationInfo operation = messageInfo.getOperation();
        QName operationQName = operation.getName();
        this.methodName = operationQName.getLocalPart();
    }

    private void initParameter() {
        this.parameter = WebServiceHelper.getParameter(this.soapMessage);
    }

    private void initServiceName() {
        if (this.request != null) {
            String uri = this.request.getRequestURI();
            this.serviceName = uri.substring(uri.lastIndexOf(47) + 1);
        }
    }

    private boolean isPosContextType() {
        return this.contextType == ContextType.POS;
    }

    private Channel loadChannel(String internalName) {
        ChannelService channelService = (ChannelService)WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.servletContext).getBean("channelService", ChannelService.class);
        return channelService.loadByInternalName("rest");
    }

    public static enum ContextType {
        POS,
        SERVICE_CLIENT,
        REST;

    }
}

