/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.webservices.access;

import javax.jws.WebService;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.access.PrincipalType;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.access.AccessServiceLocal;
import nl.strohalm.cyclos.services.access.exceptions.BlockedCredentialsException;
import nl.strohalm.cyclos.services.access.exceptions.CredentialsAlreadyUsedException;
import nl.strohalm.cyclos.services.access.exceptions.InvalidCredentialsException;
import nl.strohalm.cyclos.services.elements.ElementServiceLocal;
import nl.strohalm.cyclos.services.settings.SettingsServiceLocal;
import nl.strohalm.cyclos.utils.validation.ValidationError;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import nl.strohalm.cyclos.webservices.PrincipalParameters;
import nl.strohalm.cyclos.webservices.WebServiceContext;
import nl.strohalm.cyclos.webservices.access.AccessWebService;
import nl.strohalm.cyclos.webservices.access.ChangeCredentialsParameters;
import nl.strohalm.cyclos.webservices.access.ChangeCredentialsStatus;
import nl.strohalm.cyclos.webservices.access.CheckCredentialsParameters;
import nl.strohalm.cyclos.webservices.access.CredentialsStatus;
import nl.strohalm.cyclos.webservices.utils.ChannelHelper;
import nl.strohalm.cyclos.webservices.utils.MemberHelper;
import nl.strohalm.cyclos.webservices.utils.WebServiceHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

@WebService(name="access", serviceName="access")
public class AccessWebServiceImpl
implements AccessWebService {
    private SettingsServiceLocal settingsServiceLocal;
    private ChannelHelper channelHelper;
    private ElementServiceLocal elementServiceLocal;
    private AccessServiceLocal accessServiceLocal;
    private MemberHelper memberHelper;
    private WebServiceHelper webServiceHelper;

    @Override
    public ChangeCredentialsStatus changeCredentials(ChangeCredentialsParameters params) {
        Member member;
        String newCredentials;
        String principal = params == null ? null : StringUtils.trimToNull((String)params.getPrincipal());
        String oldCredentials = params == null ? null : StringUtils.trimToNull((String)params.getOldCredentials());
        String string = newCredentials = params == null ? null : StringUtils.trimToNull((String)params.getNewCredentials());
        if (principal == null || oldCredentials == null || newCredentials == null) {
            throw new ValidationException();
        }
        Channel channel = WebServiceContext.getChannel();
        Channel.Credentials credentials = channel.getCredentials();
        if (credentials != Channel.Credentials.LOGIN_PASSWORD && credentials != Channel.Credentials.PIN) {
            throw new PermissionDeniedException();
        }
        PrincipalType principalType = this.channelHelper.resolvePrincipalType(params.getPrincipalType());
        try {
            member = this.elementServiceLocal.loadByPrincipal(principalType, principal, Element.Relationships.GROUP, Element.Relationships.USER);
        }
        catch (Exception e) {
            this.webServiceHelper.error(e);
            return ChangeCredentialsStatus.MEMBER_NOT_FOUND;
        }
        try {
            this.accessServiceLocal.checkCredentials(channel, member.getMemberUser(), oldCredentials, WebServiceContext.getRequest().getRemoteAddr(), WebServiceContext.getMember());
        }
        catch (InvalidCredentialsException e) {
            this.webServiceHelper.error(e);
            return ChangeCredentialsStatus.INVALID_CREDENTIALS;
        }
        catch (BlockedCredentialsException e) {
            this.webServiceHelper.error(e);
            return ChangeCredentialsStatus.BLOCKED_CREDENTIALS;
        }
        boolean numericPassword = credentials == Channel.Credentials.LOGIN_PASSWORD ? this.settingsServiceLocal.getAccessSettings().isNumericPassword() : true;
        if (numericPassword && !StringUtils.isNumeric((String)newCredentials)) {
            return ChangeCredentialsStatus.INVALID_CHARACTERS;
        }
        try {
            this.accessServiceLocal.changeCredentials(member.getMemberUser(), newCredentials);
        }
        catch (ValidationException e) {
            if (CollectionUtils.isNotEmpty(e.getGeneralErrors())) {
                return ChangeCredentialsStatus.CREDENTIALS_ALREADY_USED;
            }
            try {
                ValidationError error = e.getErrorsByProperty().values().iterator().next().iterator().next();
                String key = error.getKey();
                if (key.endsWith("obvious")) {
                    return ChangeCredentialsStatus.TOO_SIMPLE;
                }
                throw new Exception();
            }
            catch (Exception e1) {
                this.webServiceHelper.error(e1);
                return ChangeCredentialsStatus.INVALID_CHARACTERS;
            }
        }
        catch (CredentialsAlreadyUsedException e) {
            this.webServiceHelper.error(e);
            return ChangeCredentialsStatus.CREDENTIALS_ALREADY_USED;
        }
        return ChangeCredentialsStatus.SUCCESS;
    }

    @Override
    public CredentialsStatus checkCredentials(CheckCredentialsParameters params) {
        if (WebServiceContext.getMember() != null) {
            throw new PermissionDeniedException();
        }
        try {
            Channel channel = WebServiceContext.getChannel();
            PrincipalType principalType = this.channelHelper.resolvePrincipalType(params.getPrincipalType());
            Member member = this.memberHelper.loadByPrincipal(principalType, params.getPrincipal(), new Relationship[0]);
            String credentials = params.getCredentials();
            if (channel.getCredentials() == Channel.Credentials.TRANSACTION_PASSWORD) {
                credentials = credentials.toUpperCase();
            }
            String remoteAddr = WebServiceContext.getRequest().getRemoteAddr();
            this.accessServiceLocal.checkCredentials(channel, member.getMemberUser(), credentials, remoteAddr, null);
            return CredentialsStatus.VALID;
        }
        catch (BlockedCredentialsException e) {
            this.webServiceHelper.error(e);
            return CredentialsStatus.BLOCKED;
        }
        catch (Exception e) {
            this.webServiceHelper.error(e);
            return CredentialsStatus.INVALID;
        }
    }

    @Override
    public boolean isChannelEnabledForMember(PrincipalParameters params) {
        Member member = WebServiceContext.getMember();
        if (member != null) {
            throw new PermissionDeniedException();
        }
        PrincipalType principalType = this.channelHelper.resolvePrincipalType(params.getPrincipalType());
        member = this.elementServiceLocal.loadByPrincipal(principalType, params.getPrincipal(), new Relationship[0]);
        return this.memberHelper.isChannelEnabledForMember(member);
    }

    public void setAccessServiceLocal(AccessServiceLocal accessService) {
        this.accessServiceLocal = accessService;
    }

    public void setChannelHelper(ChannelHelper channelHelper) {
        this.channelHelper = channelHelper;
    }

    public void setElementServiceLocal(ElementServiceLocal elementService) {
        this.elementServiceLocal = elementService;
    }

    public void setMemberHelper(MemberHelper memberHelper) {
        this.memberHelper = memberHelper;
    }

    public void setSettingsServiceLocal(SettingsServiceLocal settingsService) {
        this.settingsServiceLocal = settingsService;
    }

    public void setWebServiceHelper(WebServiceHelper webServiceHelper) {
        this.webServiceHelper = webServiceHelper;
    }
}

