/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.webservices.accounts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jws.WebService;
import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.AccountStatus;
import nl.strohalm.cyclos.entities.accounts.SystemAccountOwner;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferQuery;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferTypeQuery;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomField;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.services.ServiceClient;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.access.AccessServiceLocal;
import nl.strohalm.cyclos.services.accounts.AccountDTO;
import nl.strohalm.cyclos.services.accounts.AccountServiceLocal;
import nl.strohalm.cyclos.services.customization.PaymentCustomFieldServiceLocal;
import nl.strohalm.cyclos.services.settings.SettingsServiceLocal;
import nl.strohalm.cyclos.services.transactions.PaymentServiceLocal;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeServiceLocal;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.webservices.PrincipalParameters;
import nl.strohalm.cyclos.webservices.WebServiceContext;
import nl.strohalm.cyclos.webservices.WebServiceFault;
import nl.strohalm.cyclos.webservices.WebServiceFaultsEnum;
import nl.strohalm.cyclos.webservices.accounts.AccountHistoryResultPage;
import nl.strohalm.cyclos.webservices.accounts.AccountHistorySearchParameters;
import nl.strohalm.cyclos.webservices.accounts.AccountWebService;
import nl.strohalm.cyclos.webservices.accounts.LoadTransferParameters;
import nl.strohalm.cyclos.webservices.accounts.TransferTypeSearchParameters;
import nl.strohalm.cyclos.webservices.model.AccountHistoryTransferVO;
import nl.strohalm.cyclos.webservices.model.MemberAccountVO;
import nl.strohalm.cyclos.webservices.model.TransferTypeVO;
import nl.strohalm.cyclos.webservices.utils.AccountHelper;
import nl.strohalm.cyclos.webservices.utils.MemberHelper;
import nl.strohalm.cyclos.webservices.utils.WebServiceHelper;
import org.apache.commons.lang.StringUtils;

@WebService(name="account", serviceName="account")
public class AccountWebServiceImpl
implements AccountWebService {
    private AccountServiceLocal accountServiceLocal;
    private AccessServiceLocal accessServiceLocal;
    private PaymentServiceLocal paymentServiceLocal;
    private TransferTypeServiceLocal transferTypeServiceLocal;
    private AccountHelper accountHelper;
    private MemberHelper memberHelper;
    private WebServiceHelper webServiceHelper;
    private PaymentCustomFieldServiceLocal paymentCustomFieldServiceLocal;
    private SettingsServiceLocal settingsServiceLocal;

    @Override
    public List<MemberAccountVO> getMemberAccounts(PrincipalParameters params) {
        Member member = this.memberHelper.resolveMember(params);
        if (member == null) {
            return Collections.emptyList();
        }
        List<? extends Account> accounts = this.accountServiceLocal.getAccounts(member, Account.Relationships.TYPE);
        return this.accountHelper.toVOs(accounts);
    }

    @Override
    public AccountHistoryTransferVO loadTransfer(LoadTransferParameters params) {
        Member member;
        Transfer transfer;
        try {
            transfer = this.paymentServiceLocal.load(params.getTransferId(), Payment.Relationships.FROM, Payment.Relationships.TO, Payment.Relationships.TYPE, Payment.Relationships.CUSTOM_VALUES);
        }
        catch (RuntimeException e) {
            this.webServiceHelper.error(e);
            throw e;
        }
        if (LoggedUser.isUnrestrictedClient() && WebServiceContext.getClient().isCredentialsRequired()) {
            if (StringUtils.isEmpty((String)params.getPrincipal())) {
                throw WebServiceHelper.fault(WebServiceFaultsEnum.INVALID_PARAMETERS);
            }
            if (StringUtils.isEmpty((String)params.getCredentials())) {
                throw WebServiceHelper.fault(WebServiceFaultsEnum.INVALID_CREDENTIALS);
            }
        }
        if ((member = this.memberHelper.resolveMember(params)) != null) {
            if (!member.equals(transfer.getFromOwner()) && !member.equals(transfer.getToOwner())) {
                throw new PermissionDeniedException();
            }
            this.memberHelper.checkChannelEnabledForMember(member);
            String credentials = params.getCredentials();
            this.checkCredentialsIfNeeded(member, credentials);
        }
        List<PaymentCustomField> customFields = this.paymentCustomFieldServiceLocal.list(transfer.getType(), true);
        AccountOwner owner = (AccountOwner)((Object)(member == null ? SystemAccountOwner.instance() : member));
        return this.accountHelper.toVO(owner, transfer, customFields);
    }

    @Override
    public AccountHistoryResultPage searchAccountHistory(AccountHistorySearchParameters params) {
        Member member = this.memberHelper.resolveMember(params.getPrincipalType(), params.getPrincipal());
        if (member == null) {
            throw WebServiceHelper.fault((WebServiceFault)WebServiceFaultsEnum.INVALID_PARAMETERS, "The member is null");
        }
        this.memberHelper.checkChannelEnabledForMember(member);
        String credentials = params.getCredentials();
        this.checkCredentialsIfNeeded(member, credentials);
        TransferQuery query = this.accountHelper.toQuery(params, member);
        boolean isSmsChannel = WebServiceContext.getChannel().getInternalName().equals(this.settingsServiceLocal.getLocalSettings().getSmsChannelName());
        if (isSmsChannel) {
            query.setExcludeTransferType(((MemberGroup)member.getGroup()).getMemberSettings().getSmsChargeTransferType());
        }
        try {
            List<Transfer> transfers = this.paymentServiceLocal.search(query);
            AccountHistoryResultPage page = this.accountHelper.toAccountHistoryResultPage(member, transfers);
            AccountStatus status = this.accountServiceLocal.getCurrentStatus(new AccountDTO(member, query.getType()));
            page.setAccountStatus(this.accountHelper.toVO(status));
            return page;
        }
        catch (Exception e) {
            this.webServiceHelper.error(e);
            return null;
        }
    }

    @Override
    public List<TransferTypeVO> searchTransferTypes(TransferTypeSearchParameters params) {
        ServiceClient client = WebServiceContext.getClient();
        ArrayList<TransferType> allowedTTs = new ArrayList<TransferType>();
        allowedTTs.addAll(client.getDoPaymentTypes());
        allowedTTs.addAll(client.getReceivePaymentTypes());
        if (allowedTTs.isEmpty()) {
            return Collections.emptyList();
        }
        TransferTypeQuery query = this.accountHelper.toQuery(params);
        List<TransferType> transferTypes = this.transferTypeServiceLocal.search(query);
        transferTypes.retainAll(allowedTTs);
        return this.accountHelper.toTransferTypeVOs(transferTypes);
    }

    public void setAccessServiceLocal(AccessServiceLocal accessService) {
        this.accessServiceLocal = accessService;
    }

    public void setAccountHelper(AccountHelper accountHelper) {
        this.accountHelper = accountHelper;
    }

    public void setAccountServiceLocal(AccountServiceLocal accountService) {
        this.accountServiceLocal = accountService;
    }

    public void setMemberHelper(MemberHelper memberHelper) {
        this.memberHelper = memberHelper;
    }

    public void setPaymentCustomFieldServiceLocal(PaymentCustomFieldServiceLocal paymentCustomFieldService) {
        this.paymentCustomFieldServiceLocal = paymentCustomFieldService;
    }

    public void setPaymentServiceLocal(PaymentServiceLocal paymentService) {
        this.paymentServiceLocal = paymentService;
    }

    public void setSettingsServiceLocal(SettingsServiceLocal settingsService) {
        this.settingsServiceLocal = settingsService;
    }

    public void setTransferTypeServiceLocal(TransferTypeServiceLocal transferTypeService) {
        this.transferTypeServiceLocal = transferTypeService;
    }

    public void setWebServiceHelper(WebServiceHelper webServiceHelper) {
        this.webServiceHelper = webServiceHelper;
    }

    private void checkCredentialsIfNeeded(Member member, String credentials) {
        ServiceClient client = WebServiceContext.getClient();
        if (client.isCredentialsRequired()) {
            if (StringUtils.isEmpty((String)credentials)) {
                throw WebServiceHelper.fault(WebServiceFaultsEnum.INVALID_CREDENTIALS);
            }
            this.accessServiceLocal.checkCredentials(WebServiceContext.getChannel(), member.getMemberUser(), credentials, WebServiceContext.getRequest().getRemoteAddr(), WebServiceContext.getMember());
        }
    }
}

