/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.webservices.ads;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.List;
import javax.xml.bind.annotation.XmlType;
import nl.strohalm.cyclos.webservices.model.FieldValueVO;
import nl.strohalm.cyclos.webservices.model.SearchParameters;
import nl.strohalm.cyclos.webservices.model.TimePeriodVO;
import nl.strohalm.cyclos.webservices.utils.ObjectHelper;

public abstract class AbstractAdSearchParameters
extends SearchParameters {
    private static final long serialVersionUID = 573855204760203137L;
    private String keywords;
    private BigDecimal initialPrice;
    private BigDecimal finalPrice;
    private List<FieldValueVO> adFields;
    private Long memberId;
    private List<FieldValueVO> memberFields;
    private List<Long> memberGroupIds;
    private List<Long> memberGroupFilterIds;
    private Long categoryId;
    private TimePeriodVO since;
    private Calendar beginDate;
    private Calendar endDate;
    private AdVOTradeType tradeType;
    private AdVOStatus status;
    private Boolean withImagesOnly = false;
    private Boolean showAdFields = false;
    private Boolean showMemberFields = false;

    public List<FieldValueVO> getAdFields() {
        return this.adFields;
    }

    public Calendar getBeginDate() {
        return this.beginDate;
    }

    public Long getCategoryId() {
        return this.categoryId;
    }

    public Calendar getEndDate() {
        return this.endDate;
    }

    public BigDecimal getFinalPrice() {
        return this.finalPrice;
    }

    public BigDecimal getInitialPrice() {
        return this.initialPrice;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public List<FieldValueVO> getMemberFields() {
        return this.memberFields;
    }

    public List<Long> getMemberGroupFilterIds() {
        return this.memberGroupFilterIds;
    }

    public List<Long> getMemberGroupIds() {
        return this.memberGroupIds;
    }

    public Long getMemberId() {
        return this.memberId;
    }

    public boolean getShowAdFields() {
        return ObjectHelper.valueOf(this.showAdFields);
    }

    public boolean getShowMemberFields() {
        return ObjectHelper.valueOf(this.showMemberFields);
    }

    public TimePeriodVO getSince() {
        return this.since;
    }

    public AdVOStatus getStatus() {
        return this.status;
    }

    public AdVOTradeType getTradeType() {
        return this.tradeType;
    }

    public boolean getWithImagesOnly() {
        return ObjectHelper.valueOf(this.withImagesOnly);
    }

    public void setAdFields(List<FieldValueVO> adFields) {
        this.adFields = adFields;
    }

    public void setBeginDate(Calendar beginDate) {
        this.beginDate = beginDate;
    }

    public void setCategoryId(Long categoryId) {
        if (categoryId != null && categoryId > 0L) {
            this.categoryId = categoryId;
        }
    }

    public void setEndDate(Calendar endDate) {
        this.endDate = endDate;
    }

    public void setFinalPrice(BigDecimal finalPrice) {
        if (finalPrice != null && finalPrice.compareTo(new BigDecimal(0)) == 1) {
            this.finalPrice = finalPrice;
        }
    }

    public void setInitialPrice(BigDecimal initialPrice) {
        if (initialPrice != null && initialPrice.compareTo(new BigDecimal(0)) == 1) {
            this.initialPrice = initialPrice;
        }
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public void setMemberFields(List<FieldValueVO> memberFields) {
        this.memberFields = memberFields;
    }

    public void setMemberGroupFilterIds(List<Long> memberGroupFilterIds) {
        this.memberGroupFilterIds = memberGroupFilterIds;
    }

    public void setMemberGroupIds(List<Long> memberGroupIds) {
        this.memberGroupIds = memberGroupIds;
    }

    public void setMemberId(Long memberId) {
        this.memberId = memberId;
    }

    public void setShowAdFields(boolean showAdFields) {
        this.showAdFields = showAdFields;
    }

    public void setShowMemberFields(boolean showMemberFields) {
        this.showMemberFields = showMemberFields;
    }

    public void setSince(TimePeriodVO since) {
        this.since = since;
    }

    public void setStatus(AdVOStatus status) {
        this.status = status;
    }

    public void setTradeType(AdVOTradeType tradeType) {
        this.tradeType = tradeType;
    }

    public void setWithImagesOnly(boolean withImagesOnly) {
        this.withImagesOnly = withImagesOnly;
    }

    @Override
    public String toString() {
        return "AbstractAdSearchParameters [adFields=" + this.adFields + ", categoryId=" + this.categoryId + ", finalPrice=" + this.finalPrice + ", initialPrice=" + this.initialPrice + ", keywords=" + this.keywords + ", memberFields=" + this.memberFields + ", memberGroupIds=" + this.memberGroupIds + ", memberGroupFilterIds=" + this.memberGroupFilterIds + ", memberId=" + this.memberId + ", showAdFields=" + this.showAdFields + ", showMemberFields=" + this.showMemberFields + ", since=" + this.since + ", tradeType=" + (Object)((Object)this.tradeType) + ", withImagesOnly=" + this.withImagesOnly + ", " + super.toString() + "]";
    }

    @XmlType(name="tradeType")
    public static enum AdVOTradeType {
        OFFER,
        SEARCH,
        BOTH;

    }

    @XmlType(name="status")
    public static enum AdVOStatus {
        ACTIVE,
        PERMANENT,
        SCHEDULED,
        EXPIRED;

    }
}

