/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.webservices.ads;

import java.util.List;
import javax.jws.WebService;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.ads.Ad;
import nl.strohalm.cyclos.entities.ads.AdCategory;
import nl.strohalm.cyclos.entities.customization.fields.AdCustomField;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.ads.AdCategoryServiceLocal;
import nl.strohalm.cyclos.services.ads.AdServiceLocal;
import nl.strohalm.cyclos.services.customization.AdCustomFieldServiceLocal;
import nl.strohalm.cyclos.services.customization.MemberCustomFieldServiceLocal;
import nl.strohalm.cyclos.utils.CustomFieldHelper;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.webservices.ads.AdResultPage;
import nl.strohalm.cyclos.webservices.ads.AdSearchParameters;
import nl.strohalm.cyclos.webservices.ads.AdWebService;
import nl.strohalm.cyclos.webservices.ads.FullTextAdSearchParameters;
import nl.strohalm.cyclos.webservices.model.AdCategoryVO;
import nl.strohalm.cyclos.webservices.model.AdVO;
import nl.strohalm.cyclos.webservices.model.DetailedAdCategoryVO;
import nl.strohalm.cyclos.webservices.utils.AdHelper;

@WebService(name="ads", serviceName="ads")
public class AdWebServiceImpl
implements AdWebService {
    private static final Relationship[] FETCH = new Relationship[]{RelationshipHelper.nested(Ad.Relationships.OWNER, Element.Relationships.GROUP), Ad.Relationships.CATEGORY, Ad.Relationships.CUSTOM_VALUES, Ad.Relationships.IMAGES};
    private AdServiceLocal adServiceLocal;
    private AdHelper adHelper;
    private CustomFieldHelper customFieldHelper;
    private AdCategoryServiceLocal adCategoryServiceLocal;
    private AdCustomFieldServiceLocal adCustomFieldServiceLocal;
    private MemberCustomFieldServiceLocal memberCustomFieldServiceLocal;

    @Override
    public AdResultPage fullTextSearch(FullTextAdSearchParameters params) {
        if (params == null) {
            return null;
        }
        List<Ad> ads = this.adServiceLocal.fullTextSearch(this.adHelper.toFullTextQuery(params));
        return this.adHelper.toResultPage(params, ads);
    }

    @Override
    public AdCategoryVO[] listCategories() {
        List<AdCategory> list = this.adCategoryServiceLocal.listLeaf();
        AdCategoryVO[] vos = new AdCategoryVO[list.size()];
        for (int i = 0; i < vos.length; ++i) {
            vos[i] = this.adHelper.toVO(list.get(i));
        }
        return vos;
    }

    @Override
    public DetailedAdCategoryVO[] listCategoryTree() {
        List<AdCategory> rootList = this.adCategoryServiceLocal.listRoot();
        DetailedAdCategoryVO[] vos = new DetailedAdCategoryVO[rootList.size()];
        for (int i = 0; i < rootList.size(); ++i) {
            AdCategory adCategory = rootList.get(i);
            vos[i] = this.adHelper.toDetailedVO(adCategory);
        }
        return vos;
    }

    @Override
    public AdVO load(long id) {
        try {
            Ad ad = this.adServiceLocal.load(id, FETCH);
            if (!ad.getStatus().isActive() || !ad.isExternalPublication()) {
                throw new EntityNotFoundException();
            }
            List<AdCustomField> adFields = this.adCustomFieldServiceLocal.list();
            List<MemberCustomField> memberFields = this.customFieldHelper.onlyForGroup(this.memberCustomFieldServiceLocal.list(), ad.getOwner().getMemberGroup());
            return this.adHelper.toVO(ad, adFields, memberFields);
        }
        catch (PermissionDeniedException e) {
            return null;
        }
        catch (EntityNotFoundException e) {
            return null;
        }
    }

    @Override
    public AdCategoryVO loadCategory(long id) {
        try {
            return this.adHelper.toVO(this.adCategoryServiceLocal.load(id, new Relationship[0]));
        }
        catch (EntityNotFoundException e) {
            return null;
        }
    }

    @Override
    public AdResultPage search(AdSearchParameters params) {
        if (params == null) {
            return null;
        }
        List<Ad> ads = this.adServiceLocal.search(this.adHelper.toQuery(params));
        return this.adHelper.toResultPage(params, ads);
    }

    public void setAdCategoryServiceLocal(AdCategoryServiceLocal adCategoryServiceLocal) {
        this.adCategoryServiceLocal = adCategoryServiceLocal;
    }

    public void setAdCustomFieldServiceLocal(AdCustomFieldServiceLocal adCustomFieldServiceLocal) {
        this.adCustomFieldServiceLocal = adCustomFieldServiceLocal;
    }

    public void setAdHelper(AdHelper adHelper) {
        this.adHelper = adHelper;
    }

    public void setAdServiceLocal(AdServiceLocal adService) {
        this.adServiceLocal = adService;
    }

    public void setCustomFieldHelper(CustomFieldHelper customFieldHelper) {
        this.customFieldHelper = customFieldHelper;
    }

    public void setMemberCustomFieldServiceLocal(MemberCustomFieldServiceLocal memberCustomFieldServiceLocal) {
        this.memberCustomFieldServiceLocal = memberCustomFieldServiceLocal;
    }
}

