/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.webservices.external;

import java.io.IOException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import nl.strohalm.cyclos.CyclosConfiguration;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.transport.http.HTTPConduit;

public class ExternalWebServiceHelper {
    public static <T> T proxyFor(Class<T> clazz, String url) throws IOException {
        JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
        factory.setServiceClass(clazz);
        factory.setAddress(url);
        Object proxy = factory.create();
        boolean disableCNCheck = Boolean.valueOf(CyclosConfiguration.getCyclosProperties().getProperty("cyclos.security.disableCNCheck"));
        boolean trustAllCerts = Boolean.valueOf(CyclosConfiguration.getCyclosProperties().getProperty("cyclos.security.trustAllCerts"));
        long connectionTimeout = -1L;
        long receiveTimeout = -1L;
        try {
            connectionTimeout = Long.valueOf(CyclosConfiguration.getCyclosProperties().getProperty("cyclos.webservices.connectionTimeout"));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            receiveTimeout = Long.valueOf(CyclosConfiguration.getCyclosProperties().getProperty("cyclos.webservices.receiveTimeout"));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        Client client = ClientProxy.getClient((Object)proxy);
        HTTPConduit http = (HTTPConduit)client.getConduit();
        if (disableCNCheck || trustAllCerts) {
            http.setTlsClientParameters(ExternalWebServiceHelper.getTLSClientParameters(trustAllCerts, disableCNCheck));
        }
        if (connectionTimeout >= 0L) {
            http.getClient().setConnectionTimeout(connectionTimeout);
        }
        if (receiveTimeout >= 0L) {
            http.getClient().setReceiveTimeout(receiveTimeout);
        }
        return (T)proxy;
    }

    private static TLSClientParameters getTLSClientParameters(boolean trustAllCerts, boolean disableCNCheck) {
        TLSClientParameters tlsCP = new TLSClientParameters();
        if (trustAllCerts) {
            TrustManager[] myTrustStoreKeyManagers = ExternalWebServiceHelper.getTrustManagers();
            tlsCP.setTrustManagers(myTrustStoreKeyManagers);
        }
        tlsCP.setDisableCNCheck(disableCNCheck);
        return tlsCP;
    }

    private static TrustManager[] getTrustManagers() {
        TrustManager[] trustManagers = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        }};
        return trustManagers;
    }
}

