/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.webservices.fields;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.jws.WebService;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.customization.fields.AdCustomField;
import nl.strohalm.cyclos.entities.customization.fields.CustomField;
import nl.strohalm.cyclos.entities.customization.fields.CustomFieldPossibleValue;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomField;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.services.ServiceClient;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.customization.AdCustomFieldServiceLocal;
import nl.strohalm.cyclos.services.customization.BaseCustomFieldServiceLocal;
import nl.strohalm.cyclos.services.customization.MemberCustomFieldServiceLocal;
import nl.strohalm.cyclos.services.customization.PaymentCustomFieldServiceLocal;
import nl.strohalm.cyclos.services.services.ServiceClientServiceLocal;
import nl.strohalm.cyclos.utils.CustomFieldHelper;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.webservices.WebServiceContext;
import nl.strohalm.cyclos.webservices.fields.FieldWebService;
import nl.strohalm.cyclos.webservices.model.FieldVO;
import nl.strohalm.cyclos.webservices.model.PossibleValueVO;
import nl.strohalm.cyclos.webservices.utils.FieldHelper;

@WebService(name="fields", serviceName="fields")
public class FieldWebServiceImpl
implements FieldWebService {
    private FieldHelper fieldHelper;
    private MemberCustomFieldServiceLocal memberCustomFieldServiceLocal;
    private AdCustomFieldServiceLocal adCustomFieldServiceLocal;
    private PaymentCustomFieldServiceLocal paymentCustomFieldServiceLocal;
    private ServiceClientServiceLocal serviceClientServiceLocal;
    private CustomFieldHelper customFieldHelper;

    @Override
    public List<FieldVO> adFieldsForAdSearch() {
        ArrayList<FieldVO> vos = new ArrayList<FieldVO>();
        List customFields = this.adCustomFieldServiceLocal.list();
        for (AdCustomField field : customFields) {
            if (!field.isShowInSearch()) continue;
            vos.add(this.fieldHelper.toVO(field));
        }
        return vos;
    }

    @Override
    public List<FieldVO> allAdFields() {
        return this.fieldHelper.toFieldVOs(this.adCustomFieldServiceLocal.list());
    }

    @Override
    public List<FieldVO> allMemberFields() {
        return this.fieldHelper.toFieldVOs(this.memberCustomFieldServiceLocal.list());
    }

    @Override
    public List<FieldVO> memberFields(Long groupId) {
        ServiceClient client = this.serviceClientServiceLocal.load(WebServiceContext.getClient().getId(), ServiceClient.Relationships.MANAGE_GROUPS);
        Set<MemberGroup> groups = client.getManageGroups();
        if (groups.isEmpty()) {
            throw new PermissionDeniedException();
        }
        MemberGroup group = null;
        if (groupId == null || groupId.intValue() <= 0) {
            group = groups.iterator().next();
        } else {
            for (MemberGroup memberGroup : groups) {
                if (!memberGroup.getId().equals(groupId)) continue;
                group = memberGroup;
                break;
            }
            if (group == null) {
                throw new PermissionDeniedException();
            }
        }
        List<MemberCustomField> fields = this.customFieldHelper.onlyForGroup(this.memberCustomFieldServiceLocal.list(), group);
        return this.fieldHelper.toFieldVOs(fields);
    }

    @Override
    public List<FieldVO> memberFieldsForAdSearch() {
        ArrayList<FieldVO> vos = new ArrayList<FieldVO>();
        for (MemberCustomField field : this.memberCustomFieldServiceLocal.list()) {
            MemberCustomField.Access adSearchAccess = field.getAdSearchAccess();
            if (adSearchAccess == null || adSearchAccess != MemberCustomField.Access.MEMBER) continue;
            vos.add(this.fieldHelper.toVO(field));
        }
        return vos;
    }

    @Override
    public List<FieldVO> memberFieldsForMemberSearch() {
        ArrayList<FieldVO> vos = new ArrayList<FieldVO>();
        for (MemberCustomField field : this.memberCustomFieldServiceLocal.list()) {
            MemberCustomField.Access memberSearchAccess = field.getMemberSearchAccess();
            if (memberSearchAccess == null || memberSearchAccess != MemberCustomField.Access.MEMBER) continue;
            vos.add(this.fieldHelper.toVO(field));
        }
        return vos;
    }

    @Override
    public List<FieldVO> paymentFields(Long transferTypeId) {
        TransferType transferType = EntityHelper.reference(TransferType.class, transferTypeId);
        List<PaymentCustomField> customFields = this.paymentCustomFieldServiceLocal.list(transferType, true);
        return this.fieldHelper.toFieldVOs(customFields);
    }

    @Override
    public List<PossibleValueVO> possibleValuesForAdField(String name) {
        return this.possibleValuesForAdFieldGivenParent(name, null);
    }

    @Override
    public List<PossibleValueVO> possibleValuesForAdFieldGivenParent(String name, Long parentValueId) {
        return this.possibleValues(this.adCustomFieldServiceLocal, name, this.adCustomFieldServiceLocal.list(), parentValueId);
    }

    @Override
    public List<PossibleValueVO> possibleValuesForMemberField(String name) {
        return this.possibleValuesForMemberFieldGivenParent(name, null);
    }

    @Override
    public List<PossibleValueVO> possibleValuesForMemberFieldGivenParent(String name, Long parentValueId) {
        return this.possibleValues(this.memberCustomFieldServiceLocal, name, this.memberCustomFieldServiceLocal.list(), parentValueId);
    }

    @Override
    public List<PossibleValueVO> possibleValuesForPaymentFields(Long transferTypeId, String name) {
        TransferType transferType = EntityHelper.reference(TransferType.class, transferTypeId);
        List<PaymentCustomField> fields = this.paymentCustomFieldServiceLocal.list(transferType, true);
        return this.possibleValues(this.paymentCustomFieldServiceLocal, name, fields, null);
    }

    public void setAdCustomFieldServiceLocal(AdCustomFieldServiceLocal adCustomFieldService) {
        this.adCustomFieldServiceLocal = adCustomFieldService;
    }

    public void setCustomFieldHelper(CustomFieldHelper customFieldHelper) {
        this.customFieldHelper = customFieldHelper;
    }

    public void setFieldHelper(FieldHelper fieldHelper) {
        this.fieldHelper = fieldHelper;
    }

    public void setMemberCustomFieldServiceLocal(MemberCustomFieldServiceLocal memberCustomFieldService) {
        this.memberCustomFieldServiceLocal = memberCustomFieldService;
    }

    public void setPaymentCustomFieldServiceLocal(PaymentCustomFieldServiceLocal paymentCustomFieldService) {
        this.paymentCustomFieldServiceLocal = paymentCustomFieldService;
    }

    public void setServiceClientServiceLocal(ServiceClientServiceLocal serviceClientService) {
        this.serviceClientServiceLocal = serviceClientService;
    }

    private List<PossibleValueVO> possibleValues(BaseCustomFieldServiceLocal<?> service, String internalName, List<? extends CustomField> fields, Long parentValueId) {
        if (internalName == null) {
            return null;
        }
        CustomField field = this.customFieldHelper.findByInternalName(fields, internalName);
        if (field == null || field.getType() != CustomField.Type.ENUMERATED) {
            return null;
        }
        ArrayList<PossibleValueVO> values = new ArrayList<PossibleValueVO>();
        Collection<CustomFieldPossibleValue> possibleValues = parentValueId == null ? field.getPossibleValues(true) : field.getPossibleValuesByParent(service.loadPossibleValue(parentValueId), true);
        for (CustomFieldPossibleValue possibleValue : possibleValues) {
            values.add(this.fieldHelper.toVO(possibleValue));
        }
        return values;
    }
}

