/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.webservices.interceptor;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.services.ServiceClient;
import nl.strohalm.cyclos.entities.services.ServiceOperation;
import nl.strohalm.cyclos.services.application.ApplicationServiceLocal;
import nl.strohalm.cyclos.services.services.ServiceClientServiceLocal;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.webservices.CyclosWebServicesClientFactory;
import nl.strohalm.cyclos.webservices.Permission;
import nl.strohalm.cyclos.webservices.WebServiceContext;
import nl.strohalm.cyclos.webservices.WebServiceFaultsEnum;
import nl.strohalm.cyclos.webservices.utils.WebServiceHelper;
import org.apache.commons.lang.StringUtils;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.OperationInfo;

public class AuthInterceptor
extends AbstractSoapInterceptor {
    private static final String[] BLANK_CREDENTIALS = new String[]{"", ""};
    private ServiceClientServiceLocal serviceClientServiceLocal;
    private ApplicationServiceLocal applicationServiceLocal;
    private final Map<QName, ServiceOperation[]> cachedOperations = new HashMap<QName, ServiceOperation[]>();

    public AuthInterceptor() {
        super("pre-invoke");
    }

    public void handleMessage(SoapMessage message) throws Fault {
        HttpServletRequest request = WebServiceHelper.requestOf(message);
        request.setAttribute(WebServiceContext.ContextType.class.getName(), (Object)WebServiceContext.ContextType.SERVICE_CLIENT);
        ServiceClient client = null;
        ServletContext servletContext = this.servletContextOf(message);
        try {
            String protocol;
            if (!this.applicationServiceLocal.isOnline()) {
                throw WebServiceHelper.fault(WebServiceFaultsEnum.APPLICATION_OFFLINE);
            }
            if (Boolean.TRUE.equals(servletContext.getAttribute("cyclos.httpEnabled")) && !"https".equalsIgnoreCase(protocol = StringUtils.split((String)request.getRequestURL().toString(), (String)"://")[0])) {
                throw WebServiceHelper.fault(WebServiceFaultsEnum.SECURE_ACCESS_REQUIRED);
            }
            boolean allowed = false;
            client = this.resolveClient(request);
            if (client != null) {
                ServiceOperation[] operations = this.resolveOperations(message);
                if (operations.length == 0) {
                    allowed = true;
                } else {
                    Set<ServiceOperation> permissions = client.getPermissions();
                    for (ServiceOperation serviceOperation : operations) {
                        if (!permissions.contains(serviceOperation)) continue;
                        allowed = true;
                        break;
                    }
                }
            }
            if (!allowed) {
                throw WebServiceHelper.fault(WebServiceFaultsEnum.UNAUTHORIZED_ACCESS);
            }
            LoggedUser.init(client, request.getRemoteAddr(), null);
            WebServiceContext.set(client, servletContext, request, message);
        }
        catch (Exception e) {
            WebServiceHelper.initializeContext(message);
            if (e instanceof SoapFault) {
                throw (SoapFault)e;
            }
            throw WebServiceHelper.fault(e);
        }
    }

    public void setApplicationServiceLocal(ApplicationServiceLocal applicationService) {
        this.applicationServiceLocal = applicationService;
    }

    public void setServiceClientServiceLocal(ServiceClientServiceLocal serviceClientService) {
        this.serviceClientServiceLocal = serviceClientService;
    }

    private ServiceClient resolveClient(HttpServletRequest request) {
        String address = request.getRemoteAddr();
        String[] credentials = WebServiceHelper.getCredentials(request);
        if (credentials == null) {
            credentials = BLANK_CREDENTIALS;
        }
        try {
            return this.serviceClientServiceLocal.findByAddressAndCredentials(address, credentials[0], credentials[1]);
        }
        catch (EntityNotFoundException e) {
            return null;
        }
    }

    private ServiceOperation[] resolveOperations(SoapMessage message) {
        MessageInfo messageInfo = (MessageInfo)message.get(MessageInfo.class);
        OperationInfo operation = messageInfo.getOperation();
        QName operationQName = operation.getName();
        ServiceOperation[] operations = this.cachedOperations.get(operationQName);
        if (operations == null) {
            String operationName = operationQName.getLocalPart();
            String serviceName = operation.getInterface().getService().getName().getLocalPart();
            Class<?> serviceInterface = CyclosWebServicesClientFactory.serviceInterfaceForName(serviceName);
            for (Method m : serviceInterface.getMethods()) {
                if (!m.getName().equals(operationName)) continue;
                Permission permission = m.getAnnotation(Permission.class);
                operations = permission == null ? new ServiceOperation[]{} : permission.value();
                break;
            }
            this.cachedOperations.put(operationQName, operations);
        }
        return operations;
    }

    private ServletContext servletContextOf(SoapMessage message) {
        return (ServletContext)message.get((Object)"HTTP.CONTEXT");
    }
}

