/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.webservices.interceptor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.utils.MessageResolver;
import nl.strohalm.cyclos.utils.validation.ValidationError;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import nl.strohalm.cyclos.webservices.WebServiceContext;
import nl.strohalm.cyclos.webservices.utils.WebServiceHelper;
import org.apache.commons.lang.StringUtils;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.interceptor.Fault;

public class CustomFaultInterceptor
extends AbstractSoapInterceptor {
    private WebServiceHelper webServiceHelper;
    private MessageResolver messageResolver;

    public CustomFaultInterceptor() {
        super("marshal");
    }

    public void handleMessage(SoapMessage message) throws Fault {
        Fault fault = (Fault)message.getContent(Exception.class);
        if (!WebServiceHelper.isFromCyclos(fault)) {
            Object exception = fault.getCause() == null ? fault : fault.getCause();
            SoapFault soapFault = WebServiceHelper.fault((Throwable)exception);
            fault.setDetail(null);
            fault.setFaultCode(soapFault.getFaultCode());
            fault.setMessage(this.message((Throwable)exception));
        }
        if (WebServiceContext.isInitialized()) {
            HttpServletRequest request = WebServiceContext.getRequest();
            request.setAttribute("soapFault", (Object)fault);
        }
        this.webServiceHelper.error((Throwable)fault);
    }

    public void setMessageResolver(MessageResolver messageResolver) {
        this.messageResolver = messageResolver;
    }

    public void setWebServiceHelper(WebServiceHelper webServiceHelper) {
        this.webServiceHelper = webServiceHelper;
    }

    private String message(Throwable exception) {
        if (exception == null) {
            return "null";
        }
        if (exception instanceof ValidationException) {
            return this.message((ValidationException)exception);
        }
        return exception.getMessage();
    }

    private String message(ValidationException e) {
        Map.Entry<String, Collection<ValidationError>> entry;
        Collection<ValidationError> errors;
        String key = "error.validation";
        List<Object> args = Collections.emptyList();
        if (!e.getGeneralErrors().isEmpty()) {
            ValidationError error = e.getGeneralErrors().iterator().next();
            key = error.getKey();
            args = error.getArguments();
        } else if (!e.getErrorsByProperty().isEmpty() && !(errors = (entry = e.getErrorsByProperty().entrySet().iterator().next()).getValue()).isEmpty()) {
            String propertyName = entry.getKey();
            ValidationError error = errors.iterator().next();
            key = error.getKey();
            args = new ArrayList();
            String propertyLabel = e.getPropertyDisplayName(propertyName);
            if (StringUtils.isEmpty((String)propertyLabel)) {
                String propertyKey = e.getPropertyKey(propertyName);
                propertyLabel = StringUtils.isNotEmpty((String)propertyKey) ? this.messageResolver.message(e.getPropertyKey(propertyName), new Object[0]) : propertyName;
            }
            args.add(propertyLabel);
            if (error.getArguments() != null) {
                args.addAll(error.getArguments());
            }
        }
        return this.messageResolver.message(key, args.toArray());
    }
}

