/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.webservices.interceptor;

import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.entities.accounts.pos.MemberPos;
import nl.strohalm.cyclos.entities.accounts.pos.Pos;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.exceptions.ApplicationException;
import nl.strohalm.cyclos.services.access.AccessServiceLocal;
import nl.strohalm.cyclos.services.accounts.pos.MemberPosServiceLocal;
import nl.strohalm.cyclos.services.accounts.pos.PosServiceLocal;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.webservices.WebServiceContext;
import nl.strohalm.cyclos.webservices.WebServiceFault;
import nl.strohalm.cyclos.webservices.WebServiceFaultsEnum;
import nl.strohalm.cyclos.webservices.pos.BasePosParameters;
import nl.strohalm.cyclos.webservices.pos.IPosPinParameter;
import nl.strohalm.cyclos.webservices.utils.WebServiceHelper;
import org.apache.commons.lang.StringUtils;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.interceptor.Fault;

public class PosInterceptor
extends AbstractSoapInterceptor {
    private PosServiceLocal posServiceLocal;
    private AccessServiceLocal accessServiceLocal;
    private MemberPosServiceLocal memberPosServiceLocal;

    public PosInterceptor() {
        super("pre-invoke");
    }

    public void handleMessage(SoapMessage message) throws Fault {
        Pos pos = null;
        try {
            BasePosParameters params = (BasePosParameters)WebServiceHelper.getParameter(message);
            String posId = params.getPosId();
            pos = StringUtils.isEmpty((String)posId) ? null : this.posServiceLocal.loadByPosId(posId, Member.Relationships.CHANNELS, RelationshipHelper.nested(Pos.Relationships.MEMBER_POS, MemberPos.Relationships.MEMBER), RelationshipHelper.nested(Pos.Relationships.MEMBER_POS, MemberPos.Relationships.POS));
            HttpServletRequest request = WebServiceHelper.requestOf(message);
            request.setAttribute(WebServiceContext.ContextType.class.getName(), (Object)WebServiceContext.ContextType.POS);
            if (pos == null || pos.getMemberPos() == null) {
                throw WebServiceHelper.fault((WebServiceFault)WebServiceFaultsEnum.UNAUTHORIZED_ACCESS, "The POS was not assigned to a member");
            }
            if (!this.accessServiceLocal.isChannelEnabledForMember("pos", pos.getMemberPos().getMember())) {
                throw WebServiceHelper.fault((WebServiceFault)WebServiceFaultsEnum.UNAUTHORIZED_ACCESS, "The POS channel is not enabled for the member: " + pos.getMemberPos().getMember());
            }
            if (pos.getMemberPos().getStatus() != MemberPos.Status.ACTIVE) {
                Exception th;
                if (pos.getMemberPos().getStatus() == MemberPos.Status.BLOCKED) {
                    String remoteAddress = request.getRemoteAddr();
                    this.posServiceLocal.notifyBlockedPosUsed(pos, remoteAddress);
                    th = new BlockedPosException("Current POS status: " + pos.getMemberPos().getStatus());
                } else {
                    th = new Exception("Current POS status: " + pos.getMemberPos().getStatus());
                }
                throw WebServiceHelper.fault((WebServiceFault)WebServiceFaultsEnum.INACTIVE_POS, (Throwable)th);
            }
            if (params instanceof IPosPinParameter) {
                IPosPinParameter posPinParams = (IPosPinParameter)((Object)params);
                this.memberPosServiceLocal.checkPin(pos.getMemberPos(), posPinParams.getPosPin());
            }
            LoggedUser.init(pos, request.getRemoteAddr(), null);
            WebServiceHelper.initializeContext(pos, message);
        }
        catch (Exception e) {
            WebServiceHelper.initializeContext(message);
            if (e instanceof SoapFault) {
                throw (SoapFault)e;
            }
            throw WebServiceHelper.fault(e);
        }
    }

    public void setAccessServiceLocal(AccessServiceLocal accessService) {
        this.accessServiceLocal = accessService;
    }

    public void setMemberPosServiceLocal(MemberPosServiceLocal memberPosService) {
        this.memberPosServiceLocal = memberPosService;
    }

    public void setPosServiceLocal(PosServiceLocal posService) {
        this.posServiceLocal = posService;
    }

    private class BlockedPosException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;

        private BlockedPosException(String msg) {
            super(msg);
            this.setShouldRollback(false);
        }
    }
}

