/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.webservices.interceptor;

import nl.strohalm.cyclos.utils.logging.LoggingHandler;
import nl.strohalm.cyclos.utils.logging.WebServiceLogDTO;
import nl.strohalm.cyclos.utils.transaction.CurrentTransactionData;
import nl.strohalm.cyclos.webservices.WebServiceContext;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.interceptor.Fault;

public class TraceInterceptor
extends AbstractSoapInterceptor {
    private LoggingHandler loggingHandler;

    public TraceInterceptor() {
        super("marshal");
    }

    public void handleMessage(SoapMessage message) throws Fault {
        Throwable exception = (Throwable)WebServiceContext.getRequest().getAttribute("soapFault");
        if (exception == null) {
            exception = CurrentTransactionData.getError();
        }
        if (exception == null) {
            WebServiceLogDTO log = WebServiceContext.newLog();
            this.loggingHandler.traceWebService(log);
        }
    }

    public void setLoggingHandler(LoggingHandler loggingHandler) {
        this.loggingHandler = loggingHandler;
    }
}

