/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.webservices.members;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.jws.WebService;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.access.MemberUser;
import nl.strohalm.cyclos.entities.access.PrincipalType;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomFieldValue;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.PendingMember;
import nl.strohalm.cyclos.entities.members.RegisteredMember;
import nl.strohalm.cyclos.entities.services.ServiceClient;
import nl.strohalm.cyclos.services.customization.MemberCustomFieldServiceLocal;
import nl.strohalm.cyclos.services.elements.ElementServiceLocal;
import nl.strohalm.cyclos.utils.CustomFieldHelper;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.webservices.PrincipalParameters;
import nl.strohalm.cyclos.webservices.WebServiceContext;
import nl.strohalm.cyclos.webservices.members.FullTextMemberSearchParameters;
import nl.strohalm.cyclos.webservices.members.MemberRegistrationResult;
import nl.strohalm.cyclos.webservices.members.MemberResultPage;
import nl.strohalm.cyclos.webservices.members.MemberSearchParameters;
import nl.strohalm.cyclos.webservices.members.MemberWebService;
import nl.strohalm.cyclos.webservices.members.RegisterMemberParameters;
import nl.strohalm.cyclos.webservices.members.UpdateMemberParameters;
import nl.strohalm.cyclos.webservices.model.GroupVO;
import nl.strohalm.cyclos.webservices.model.MemberVO;
import nl.strohalm.cyclos.webservices.model.RegistrationFieldValueVO;
import nl.strohalm.cyclos.webservices.utils.ChannelHelper;
import nl.strohalm.cyclos.webservices.utils.GroupHelper;
import nl.strohalm.cyclos.webservices.utils.MemberHelper;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.lang.StringUtils;

@WebService(name="members", serviceName="members")
public class MemberWebServiceImpl
implements MemberWebService {
    private static final Relationship[] FETCH = new Relationship[]{Element.Relationships.USER, Element.Relationships.GROUP, Member.Relationships.IMAGES, Member.Relationships.CUSTOM_VALUES};
    private ElementServiceLocal elementServiceLocal;
    private MemberCustomFieldServiceLocal memberCustomFieldServiceLocal;
    private MemberHelper memberHelper;
    private GroupHelper groupHelper;
    private ChannelHelper channelHelper;
    private CustomFieldHelper customFieldHelper;

    @Override
    public MemberResultPage fullTextSearch(FullTextMemberSearchParameters params) {
        if (params == null) {
            return null;
        }
        List<? extends Element> members = this.elementServiceLocal.fullTextSearch(this.memberHelper.toFullTextQuery(params));
        return this.memberHelper.toResultPage(members, params.getShowCustomFields(), params.getShowImages());
    }

    @Override
    public List<GroupVO> listManagedGroups() {
        ServiceClient client = WebServiceContext.getClient();
        ArrayList<GroupVO> groups = new ArrayList<GroupVO>();
        for (MemberGroup group : client.getManageGroups()) {
            groups.add(this.groupHelper.toVO(group));
        }
        Collections.sort(groups, new BeanComparator("name"));
        return groups;
    }

    @Override
    public MemberVO load(long id) {
        Object element;
        try {
            element = this.elementServiceLocal.load(id, FETCH);
            if (!(element instanceof Member)) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            return null;
        }
        return this.memberHelper.toFullVO((Member)element);
    }

    @Override
    public MemberVO loadByPrincipal(PrincipalParameters params) {
        Member member;
        try {
            PrincipalType principalType = this.channelHelper.resolvePrincipalType(params.getPrincipalType());
            member = this.elementServiceLocal.loadByPrincipal(principalType, params.getPrincipal(), FETCH);
        }
        catch (Exception e) {
            return null;
        }
        return this.memberHelper.toFullVO(member);
    }

    @Override
    public MemberVO loadByUsername(String username) {
        Object user;
        try {
            user = this.elementServiceLocal.loadUser(username, RelationshipHelper.nested(User.Relationships.ELEMENT, Element.Relationships.GROUP), RelationshipHelper.nested(User.Relationships.ELEMENT, Member.Relationships.CUSTOM_VALUES), RelationshipHelper.nested(User.Relationships.ELEMENT, Member.Relationships.IMAGES));
            if (!(user instanceof MemberUser)) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            return null;
        }
        return this.memberHelper.toFullVO(((MemberUser)user).getMember());
    }

    @Override
    public MemberRegistrationResult registerMember(RegisterMemberParameters params) {
        if (params == null) {
            throw new IllegalArgumentException();
        }
        String credentials = params.getCredentials();
        if (StringUtils.isNotEmpty((String)credentials)) {
            params.setLoginPassword(null);
            params.setPin(null);
            Channel channel = WebServiceContext.getChannel();
            if (channel != null) {
                switch (channel.getCredentials()) {
                    case DEFAULT: 
                    case LOGIN_PASSWORD: {
                        params.setLoginPassword(credentials);
                        break;
                    }
                    case PIN: {
                        params.setPin(credentials);
                    }
                }
            }
        }
        Member member = this.memberHelper.toMember(params);
        member.getUser().setPassword(params.getLoginPassword());
        if (StringUtils.isNotEmpty((String)params.getPin())) {
            member.getMemberUser().setPin(params.getPin());
        }
        RegisteredMember registered = this.elementServiceLocal.registerMemberByWebService(WebServiceContext.getClient(), member, WebServiceContext.getRequest().getRemoteAddr());
        MemberRegistrationResult result = new MemberRegistrationResult();
        if (registered instanceof PendingMember) {
            result.setAwaitingEmailValidation(true);
        } else {
            result.setId(registered.getId());
            result.setUsername(registered.getUsername());
        }
        return result;
    }

    @Override
    public MemberResultPage search(MemberSearchParameters params) {
        if (params == null) {
            return null;
        }
        List<? extends Element> members = this.elementServiceLocal.search(this.memberHelper.toQuery(params));
        return this.memberHelper.toResultPage(members, params.getShowCustomFields(), params.getShowImages());
    }

    public void setChannelHelper(ChannelHelper channelHelper) {
        this.channelHelper = channelHelper;
    }

    public void setCustomFieldHelper(CustomFieldHelper customFieldHelper) {
        this.customFieldHelper = customFieldHelper;
    }

    public void setElementServiceLocal(ElementServiceLocal elementService) {
        this.elementServiceLocal = elementService;
    }

    public void setGroupHelper(GroupHelper groupHelper) {
        this.groupHelper = groupHelper;
    }

    public void setMemberCustomFieldServiceLocal(MemberCustomFieldServiceLocal memberCustomFieldService) {
        this.memberCustomFieldServiceLocal = memberCustomFieldService;
    }

    public void setMemberHelper(MemberHelper memberHelper) {
        this.memberHelper = memberHelper;
    }

    @Override
    public void updateMember(UpdateMemberParameters params) {
        Member member;
        String principal;
        Long id = params == null || params.getId() == null || params.getId().intValue() <= 0 ? null : params.getId();
        String string = principal = params == null || StringUtils.isEmpty((String)params.getPrincipal()) ? null : params.getPrincipal();
        if (id != null) {
            try {
                member = (Member)this.elementServiceLocal.load(id, FETCH);
            }
            catch (Exception e) {
                throw new EntityNotFoundException(Member.class);
            }
        } else if (principal != null) {
            PrincipalType principalType = this.channelHelper.resolvePrincipalType(params.getPrincipalType());
            member = this.elementServiceLocal.loadByPrincipal(principalType, params.getPrincipal(), FETCH);
        } else {
            throw new IllegalArgumentException();
        }
        member = (Member)member.clone();
        if (StringUtils.isNotEmpty((String)params.getName())) {
            member.setName(params.getName());
        }
        if (StringUtils.isNotEmpty((String)params.getEmail())) {
            member.setEmail(params.getEmail());
        }
        List<RegistrationFieldValueVO> fieldValueVOs = params.getFields();
        List<MemberCustomField> allowedFields = this.customFieldHelper.onlyForGroup(this.memberCustomFieldServiceLocal.list(), member.getMemberGroup());
        Collection<MemberCustomFieldValue> newFieldValues = this.customFieldHelper.mergeFieldValues(member, fieldValueVOs, allowedFields);
        member.setCustomValues(newFieldValues);
        this.elementServiceLocal.changeMemberProfileByWebService(WebServiceContext.getClient(), member);
    }
}

