/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.webservices.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlTransient;
import nl.strohalm.cyclos.webservices.utils.ObjectHelper;

public abstract class ResultPage<T>
implements Serializable,
Iterable<T> {
    private static final long serialVersionUID = -7387157723771363227L;
    private Integer currentPage = 0;
    private Integer pageSize = 0;
    private Integer totalCount = 0;
    @XmlTransient
    private List<T> elements;

    public ResultPage() {
    }

    public ResultPage(int currentPage, int pageSize, int totalCount, List<T> elements) {
        this.currentPage = currentPage;
        this.pageSize = pageSize;
        this.totalCount = totalCount;
        this.elements = elements;
    }

    public int getCurrentPage() {
        return ObjectHelper.valueOf(this.currentPage);
    }

    @XmlTransient
    public List<T> getElements() {
        return this.elements;
    }

    public int getPageSize() {
        return ObjectHelper.valueOf(this.pageSize);
    }

    public int getTotalCount() {
        return ObjectHelper.valueOf(this.totalCount);
    }

    @Override
    public final Iterator<T> iterator() {
        return this.elements == null ? Collections.emptyList().iterator() : this.elements.iterator();
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    public void setElements(List<T> elements) {
        this.elements = elements;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        sb.append(this.getClass().getSimpleName()).append(" [");
        if (this.elements != null) {
            for (T vo : this.elements) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(vo.toString());
                first = false;
            }
        }
        sb.append("]");
        return sb.toString();
    }
}

