/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.webservices.payments;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.jws.WebService;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.AccountStatus;
import nl.strohalm.cyclos.entities.accounts.LockedAccountsOnPayments;
import nl.strohalm.cyclos.entities.accounts.SystemAccountOwner;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentRequestTicket;
import nl.strohalm.cyclos.entities.accounts.transactions.Ticket;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferAuthorizationDTO;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomFieldValue;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.services.ServiceClient;
import nl.strohalm.cyclos.entities.services.ServiceOperation;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.access.AccessServiceLocal;
import nl.strohalm.cyclos.services.access.exceptions.BlockedCredentialsException;
import nl.strohalm.cyclos.services.access.exceptions.InvalidCredentialsException;
import nl.strohalm.cyclos.services.accounts.AccountDTO;
import nl.strohalm.cyclos.services.accounts.AccountServiceLocal;
import nl.strohalm.cyclos.services.application.ApplicationServiceLocal;
import nl.strohalm.cyclos.services.customization.MemberCustomFieldServiceLocal;
import nl.strohalm.cyclos.services.elements.ElementServiceLocal;
import nl.strohalm.cyclos.services.services.ServiceClientServiceLocal;
import nl.strohalm.cyclos.services.transactions.BulkChargebackResult;
import nl.strohalm.cyclos.services.transactions.BulkPaymentResult;
import nl.strohalm.cyclos.services.transactions.DoPaymentDTO;
import nl.strohalm.cyclos.services.transactions.PaymentServiceLocal;
import nl.strohalm.cyclos.services.transactions.TicketServiceLocal;
import nl.strohalm.cyclos.services.transactions.TransferAuthorizationServiceLocal;
import nl.strohalm.cyclos.services.transactions.exceptions.InvalidChannelException;
import nl.strohalm.cyclos.utils.Pair;
import nl.strohalm.cyclos.webservices.WebServiceContext;
import nl.strohalm.cyclos.webservices.model.AccountHistoryTransferVO;
import nl.strohalm.cyclos.webservices.model.AccountStatusVO;
import nl.strohalm.cyclos.webservices.payments.ChargebackResult;
import nl.strohalm.cyclos.webservices.payments.ChargebackStatus;
import nl.strohalm.cyclos.webservices.payments.ConfirmPaymentParameters;
import nl.strohalm.cyclos.webservices.payments.PaymentParameters;
import nl.strohalm.cyclos.webservices.payments.PaymentRequestStatus;
import nl.strohalm.cyclos.webservices.payments.PaymentResult;
import nl.strohalm.cyclos.webservices.payments.PaymentStatus;
import nl.strohalm.cyclos.webservices.payments.PaymentWebService;
import nl.strohalm.cyclos.webservices.payments.RequestPaymentParameters;
import nl.strohalm.cyclos.webservices.payments.RequestPaymentResult;
import nl.strohalm.cyclos.webservices.utils.AccountHelper;
import nl.strohalm.cyclos.webservices.utils.ChannelHelper;
import nl.strohalm.cyclos.webservices.utils.MemberHelper;
import nl.strohalm.cyclos.webservices.utils.PaymentHelper;
import nl.strohalm.cyclos.webservices.utils.WebServiceHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;

@WebService(name="payment", serviceName="payment")
public class PaymentWebServiceImpl
implements PaymentWebService {
    private AccountServiceLocal accountServiceLocal;
    private AccessServiceLocal accessServiceLocal;
    private ApplicationServiceLocal applicationServiceLocal;
    private PaymentServiceLocal paymentServiceLocal;
    private TicketServiceLocal ticketServiceLocal;
    private ElementServiceLocal elementServiceLocal;
    private MemberCustomFieldServiceLocal memberCustomFieldServiceLocal;
    private ServiceClientServiceLocal serviceClientServiceLocal;
    private TransferAuthorizationServiceLocal transferAuthorizationServiceLocal;
    private PaymentHelper paymentHelper;
    private MemberHelper memberHelper;
    private WebServiceHelper webServiceHelper;
    private AccountHelper accountHelper;
    private ChannelHelper channelHelper;

    @Override
    public ChargebackResult chargeback(Long transferId) {
        return this.reverse(transferId, new TransferLoader<Long>(){

            @Override
            public Transfer load(Long transferId) {
                return PaymentWebServiceImpl.this.paymentServiceLocal.load(transferId, new Relationship[0]);
            }
        });
    }

    @Override
    public PaymentResult confirmPayment(ConfirmPaymentParameters params) {
        AccountHistoryTransferVO transferVO;
        PaymentStatus status;
        AccountStatus toMemberStatus;
        AccountStatus fromMemberStatus;
        Exception errorException;
        block23: {
            errorException = null;
            fromMemberStatus = null;
            toMemberStatus = null;
            Member fromMember = null;
            Member toMember = null;
            if (WebServiceContext.getMember() != null) {
                throw new PermissionDeniedException();
            }
            Channel channel = WebServiceContext.getChannel();
            String channelName = channel == null ? null : channel.getInternalName();
            status = null;
            transferVO = null;
            Ticket ticket = null;
            try {
                Object t = this.ticketServiceLocal.load(params.getTicket(), new Relationship[0]);
                fromMember = ((Ticket)t).getFrom();
                toMember = ((Ticket)t).getTo();
                if (!(t instanceof PaymentRequestTicket) || ((Ticket)t).getStatus() != Ticket.Status.PENDING) {
                    throw new Exception("Invalid ticket and/or status: " + t.getClass().getName() + ", status: " + ((Ticket)t).getStatus());
                }
                ticket = (PaymentRequestTicket)t;
                if (!((PaymentRequestTicket)ticket).getToChannel().getInternalName().equals(channelName)) {
                    throw new Exception("The ticket's destination channel is not the expected one (expected=" + channelName + "): " + ((PaymentRequestTicket)ticket).getToChannel().getInternalName());
                }
            }
            catch (Exception e) {
                errorException = e;
                status = PaymentStatus.INVALID_PARAMETERS;
            }
            Member member = null;
            if (status == null) {
                member = ticket.getFrom();
                if (!this.accessServiceLocal.isChannelEnabledForMember(channelName, member)) {
                    status = PaymentStatus.INVALID_CHANNEL;
                }
                if (status == null && WebServiceContext.getClient().isCredentialsRequired()) {
                    try {
                        this.checkCredentials(member, channel, params.getCredentials());
                    }
                    catch (InvalidCredentialsException e) {
                        errorException = e;
                        status = PaymentStatus.INVALID_CREDENTIALS;
                    }
                    catch (BlockedCredentialsException e) {
                        errorException = e;
                        status = PaymentStatus.BLOCKED_CREDENTIALS;
                    }
                }
            }
            Transfer transfer = null;
            if (status == null) {
                try {
                    transfer = this.paymentServiceLocal.confirmPayment(ticket.getTicket());
                    status = this.paymentHelper.toStatus(transfer);
                    transferVO = this.accountHelper.toVO((AccountOwner)member, transfer, null);
                    if (WebServiceContext.getClient().getPermissions().contains(ServiceOperation.ACCOUNT_DETAILS)) {
                        if (WebServiceContext.getMember() == null) {
                            fromMemberStatus = this.accountServiceLocal.getCurrentStatus(new AccountDTO(fromMember, transfer.getFrom().getType()));
                            toMemberStatus = this.accountServiceLocal.getCurrentStatus(new AccountDTO(toMember, transfer.getTo().getType()));
                        } else if (WebServiceContext.getMember().equals(fromMember)) {
                            fromMemberStatus = this.accountServiceLocal.getCurrentStatus(new AccountDTO(fromMember, transfer.getFrom().getType()));
                        } else {
                            toMemberStatus = this.accountServiceLocal.getCurrentStatus(new AccountDTO(toMember, transfer.getTo().getType()));
                        }
                    }
                }
                catch (Exception e) {
                    errorException = e;
                    if (this.applicationServiceLocal.getLockedAccountsOnPayments() == LockedAccountsOnPayments.NONE) {
                        status = this.paymentHelper.toStatus(e);
                    }
                    if (status != null) break block23;
                    status = this.paymentHelper.toStatus(e);
                }
            }
        }
        if (!status.isSuccessful()) {
            if (errorException != null) {
                this.webServiceHelper.error(errorException);
            } else {
                this.webServiceHelper.error("Confirm payment status: " + (Object)((Object)status));
            }
        }
        return new PaymentResult(status, transferVO, this.accountHelper.toVO(fromMemberStatus), this.accountHelper.toVO(toMemberStatus));
    }

    @Override
    public List<ChargebackResult> doBulkChargeback(List<Long> transfersIds) {
        return this.doBulkChargeback(transfersIds, new TransferLoader<Long>(){

            @Override
            public Transfer load(Long transfersId) {
                return PaymentWebServiceImpl.this.paymentServiceLocal.load(transfersId, new Relationship[0]);
            }
        });
    }

    @Override
    public List<PaymentResult> doBulkPayment(List<PaymentParameters> params) {
        int size = params == null ? 0 : params.size();
        ArrayList<PaymentResult> results = new ArrayList<PaymentResult>(size);
        DoPaymentDTO[] dtos = new DoPaymentDTO[size];
        PrepareParametersResult[] loadedPrepareParameters = new PrepareParametersResult[size];
        if (size > 0) {
            boolean hasError = false;
            ArrayList<AccountDTO> allAccounts = new ArrayList<AccountDTO>();
            for (int i = 0; i < params.size(); ++i) {
                PaymentParameters param = params.get(i);
                PrepareParametersResult result = this.prepareParameters(param);
                if (result.getStatus() == null) {
                    try {
                        DoPaymentDTO dto = this.paymentHelper.toExternalPaymentDTO(param, result.getFrom(), result.getTo());
                        if (!this.validateTransferType(dto)) {
                            results.add(new PaymentResult(PaymentStatus.INVALID_PARAMETERS, null));
                            this.webServiceHelper.error("The specified transfer type is invalid: " + dto.getTransferType());
                            hasError = true;
                        } else {
                            allAccounts.add(new AccountDTO(result.getFrom(), dto.getTransferType().getFrom()));
                            results.add(new PaymentResult(PaymentStatus.NOT_PERFORMED, null));
                        }
                        loadedPrepareParameters[i] = result;
                        dtos[i] = dto;
                    }
                    catch (Exception e) {
                        this.webServiceHelper.error(e);
                        hasError = true;
                        results.add(new PaymentResult(this.paymentHelper.toStatus(e), null));
                    }
                    continue;
                }
                hasError = true;
                results.add(new PaymentResult(result.getStatus(), null));
                this.webServiceHelper.error("Bulk payment validation status [" + i + "]: " + (Object)((Object)result.getStatus()));
            }
            if (!hasError) {
                List<BulkPaymentResult> bulkResults = this.paymentServiceLocal.doBulkPayment(Arrays.asList(dtos));
                for (int i = 0; i < params.size(); ++i) {
                    PaymentResult result;
                    BulkPaymentResult bulkResult;
                    PaymentParameters param = params.get(i);
                    try {
                        bulkResult = bulkResults.get(i);
                    }
                    catch (IndexOutOfBoundsException e) {
                        bulkResult = null;
                    }
                    if (hasError || bulkResult == null) {
                        result = new PaymentResult(PaymentStatus.NOT_PERFORMED, null);
                    } else {
                        PaymentStatus status;
                        block18: {
                            result = new PaymentResult();
                            Transfer transfer = (Transfer)bulkResult.getPayment();
                            status = null;
                            try {
                                if (transfer == null) {
                                    status = this.paymentHelper.toStatus(bulkResult.getException());
                                } else {
                                    status = this.paymentHelper.toStatus(transfer);
                                    result.setTransfer(this.accountHelper.toVO(WebServiceContext.getMember(), transfer, null, loadedPrepareParameters[i].getFromRequiredFields(), loadedPrepareParameters[i].getToRequiredFields()));
                                }
                                if (!status.isSuccessful()) {
                                    hasError = true;
                                }
                                AccountStatusVO[] statuses = this.getAccountStatusesForPayment(param, transfer);
                                result.setFromAccountStatus(statuses[0]);
                                result.setToAccountStatus(statuses[1]);
                            }
                            catch (Exception e) {
                                this.webServiceHelper.error(e);
                                if (status != null) break block18;
                                status = this.paymentHelper.toStatus(e);
                            }
                        }
                        result.setStatus(status);
                    }
                    results.set(i, result);
                }
            }
        }
        return results;
    }

    @Override
    public List<ChargebackResult> doBulkReverse(List<String> traces) {
        return this.doBulkChargeback(traces, new TransferLoader<String>(){

            @Override
            public Transfer load(String traceNumber) {
                return PaymentWebServiceImpl.this.paymentServiceLocal.loadTransferForReverse(traceNumber, new Relationship[0]);
            }
        });
    }

    @Override
    public PaymentResult doPayment(PaymentParameters params) {
        AccountStatusVO toMemberStatus;
        AccountStatusVO fromMemberStatus;
        PaymentStatus status;
        AccountHistoryTransferVO transferVO;
        block7: {
            transferVO = null;
            Transfer transfer = null;
            status = null;
            fromMemberStatus = null;
            toMemberStatus = null;
            try {
                PrepareParametersResult result = this.prepareParameters(params);
                status = result.getStatus();
                if (status == null) {
                    DoPaymentDTO dto = this.paymentHelper.toExternalPaymentDTO(params, result.getFrom(), result.getTo());
                    if (!this.validateTransferType(dto)) {
                        status = PaymentStatus.INVALID_PARAMETERS;
                        this.webServiceHelper.trace((Object)((Object)status) + ". Reason: The service client doesn't have permission to the specified transfer type: " + dto.getTransferType());
                    } else {
                        transfer = (Transfer)this.paymentServiceLocal.doPayment(dto);
                        status = this.paymentHelper.toStatus(transfer);
                        transferVO = this.accountHelper.toVO(WebServiceContext.getMember(), transfer, null, result.getFromRequiredFields(), result.getToRequiredFields());
                        AccountStatusVO[] statuses = this.getAccountStatusesForPayment(params, transfer);
                        fromMemberStatus = statuses[0];
                        toMemberStatus = statuses[1];
                    }
                }
            }
            catch (Exception e) {
                this.webServiceHelper.error(e);
                if (this.applicationServiceLocal.getLockedAccountsOnPayments() == LockedAccountsOnPayments.NONE) {
                    status = this.paymentHelper.toStatus(e);
                }
                if (status != null) break block7;
                status = this.paymentHelper.toStatus(e);
            }
        }
        if (!status.isSuccessful()) {
            this.webServiceHelper.error("Payment error status: " + (Object)((Object)status));
        }
        return new PaymentResult(status, transferVO, fromMemberStatus, toMemberStatus);
    }

    @Override
    public boolean expireTicket(String ticketStr) {
        try {
            PaymentRequestTicket ticket = (PaymentRequestTicket)this.ticketServiceLocal.load(ticketStr, PaymentRequestTicket.Relationships.FROM_CHANNEL);
            Member restricted = WebServiceContext.getMember();
            if (restricted != null && !restricted.equals(ticket.getTo())) {
                throw new Exception();
            }
            Channel resolvedChannel = WebServiceContext.getChannel();
            Channel fromChannel = ticket.getFromChannel();
            Channel toChannel = ticket.getToChannel();
            if (!(fromChannel != null && fromChannel.equals(resolvedChannel) || toChannel != null && toChannel.equals(resolvedChannel))) {
                throw new Exception();
            }
            if (ticket.getStatus() == Ticket.Status.PENDING) {
                this.ticketServiceLocal.expirePaymentRequestTicket(ticket);
                return true;
            }
        }
        catch (Exception e) {
            this.webServiceHelper.error(e);
        }
        return false;
    }

    @Override
    public RequestPaymentResult requestPaymentConfirmation(RequestPaymentParameters params) {
        Exception errorException = null;
        PaymentRequestStatus status = null;
        Member toMember = null;
        Member restricted = WebServiceContext.getMember();
        if (restricted != null) {
            toMember = restricted;
        } else {
            try {
                toMember = this.paymentHelper.resolveToMember(params);
            }
            catch (EntityNotFoundException e) {
                status = PaymentRequestStatus.TO_NOT_FOUND;
            }
            if (status == null && !this.memberHelper.isChannelEnabledForMember(toMember)) {
                status = PaymentRequestStatus.TO_INVALID_CHANNEL;
            }
        }
        Member fromMember = null;
        if (status == null) {
            try {
                fromMember = this.paymentHelper.resolveFromMember(params);
            }
            catch (EntityNotFoundException e) {
                status = PaymentRequestStatus.FROM_NOT_FOUND;
            }
        }
        PaymentRequestTicket ticket = null;
        if (status == null) {
            try {
                ticket = this.paymentHelper.toTicket(params, null);
                ticket.setFrom(fromMember);
                ticket.setTo(toMember);
                ticket = this.ticketServiceLocal.generate(ticket);
                status = PaymentRequestStatus.REQUEST_RECEIVED;
            }
            catch (InvalidChannelException e) {
                status = PaymentRequestStatus.FROM_INVALID_CHANNEL;
            }
            catch (Exception e) {
                errorException = e;
                PaymentStatus paymentStatus = this.paymentHelper.toStatus(e);
                try {
                    status = PaymentRequestStatus.valueOf(paymentStatus.name());
                }
                catch (Exception e1) {
                    e1.initCause(e);
                    errorException = e1;
                    status = PaymentRequestStatus.UNKNOWN_ERROR;
                }
            }
        }
        if (!status.isSuccessful()) {
            if (errorException != null) {
                this.webServiceHelper.error(errorException);
            } else {
                this.webServiceHelper.error("Request payment confirmation status: " + (Object)((Object)status));
            }
        }
        RequestPaymentResult result = new RequestPaymentResult();
        result.setStatus(status);
        if (ticket != null) {
            result.setTicket(ticket.getTicket());
        }
        return result;
    }

    @Override
    public ChargebackResult reverse(String traceNumber) {
        return this.reverse(traceNumber, new TransferLoader<String>(){

            @Override
            public Transfer load(String traceNumber) {
                return PaymentWebServiceImpl.this.paymentServiceLocal.loadTransferForReverse(traceNumber, new Relationship[0]);
            }
        });
    }

    public void setAccessServiceLocal(AccessServiceLocal accessService) {
        this.accessServiceLocal = accessService;
    }

    public void setAccountHelper(AccountHelper accountHelper) {
        this.accountHelper = accountHelper;
    }

    public void setAccountServiceLocal(AccountServiceLocal accountService) {
        this.accountServiceLocal = accountService;
    }

    public void setApplicationServiceLocal(ApplicationServiceLocal applicationServiceLocal) {
        this.applicationServiceLocal = applicationServiceLocal;
    }

    public void setChannelHelper(ChannelHelper channelHelper) {
        this.channelHelper = channelHelper;
    }

    public void setElementServiceLocal(ElementServiceLocal elementService) {
        this.elementServiceLocal = elementService;
    }

    public void setMemberCustomFieldServiceLocal(MemberCustomFieldServiceLocal memberCustomFieldService) {
        this.memberCustomFieldServiceLocal = memberCustomFieldService;
    }

    public void setMemberHelper(MemberHelper memberHelper) {
        this.memberHelper = memberHelper;
    }

    public void setPaymentHelper(PaymentHelper paymentHelper) {
        this.paymentHelper = paymentHelper;
    }

    public void setPaymentServiceLocal(PaymentServiceLocal paymentService) {
        this.paymentServiceLocal = paymentService;
    }

    public void setServiceClientServiceLocal(ServiceClientServiceLocal serviceClientService) {
        this.serviceClientServiceLocal = serviceClientService;
    }

    public void setTicketServiceLocal(TicketServiceLocal ticketService) {
        this.ticketServiceLocal = ticketService;
    }

    public void setTransferAuthorizationServiceLocal(TransferAuthorizationServiceLocal transferAuthorizationService) {
        this.transferAuthorizationServiceLocal = transferAuthorizationService;
    }

    public void setWebServiceHelper(WebServiceHelper webServiceHelper) {
        this.webServiceHelper = webServiceHelper;
    }

    @Override
    public PaymentStatus simulatePayment(PaymentParameters params) {
        PaymentStatus status = null;
        try {
            PrepareParametersResult result = this.prepareParameters(params);
            status = result.getStatus();
            if (status == null) {
                DoPaymentDTO dto = this.paymentHelper.toExternalPaymentDTO(params, result.getFrom(), result.getTo());
                if (!this.validateTransferType(dto)) {
                    this.webServiceHelper.trace((Object)((Object)PaymentStatus.INVALID_PARAMETERS) + ". Reason: The service client doesn't have permission to the specified transfer type: " + dto.getTransferType());
                    return PaymentStatus.INVALID_PARAMETERS;
                }
                Transfer transfer = (Transfer)this.paymentServiceLocal.simulatePayment(dto);
                return this.paymentHelper.toStatus(transfer);
            }
        }
        catch (Exception e) {
            this.webServiceHelper.error(e);
            return this.paymentHelper.toStatus(e);
        }
        if (!status.isSuccessful()) {
            this.webServiceHelper.error("Simulate payment status: " + (Object)((Object)status));
        }
        return status;
    }

    private void checkCredentials(Member member, Channel channel, String credentials) {
        if (member == null) {
            return;
        }
        ServiceClient client = WebServiceContext.getClient();
        Member restrictedMember = client.getMember();
        if (restrictedMember == null ? !client.isCredentialsRequired() : restrictedMember.equals(member)) {
            throw new InvalidCredentialsException();
        }
        if (StringUtils.isEmpty((String)credentials)) {
            throw new InvalidCredentialsException();
        }
        member = (Member)this.elementServiceLocal.load(member.getId(), Element.Relationships.USER);
        this.accessServiceLocal.checkCredentials(channel, member.getMemberUser(), credentials, WebServiceContext.getRequest().getRemoteAddr(), WebServiceContext.getMember());
    }

    private <V> List<ChargebackResult> doBulkChargeback(List<V> ids, TransferLoader<V> loader) {
        LinkedList<Transfer> transfers = new LinkedList<Transfer>();
        LinkedList<Transfer> actualTransfers = new LinkedList<Transfer>();
        Member member = WebServiceContext.getMember();
        LinkedList<ChargebackResult> results = new LinkedList<ChargebackResult>();
        boolean hasError = false;
        for (V id : ids) {
            Transfer transfer = null;
            try {
                transfer = loader.load(id);
                transfers.add(transfer);
                if (member != null && !transfer.getToOwner().equals(member)) {
                    throw new EntityNotFoundException();
                }
                Pair<ChargebackStatus, Transfer> preprocessResult = this.preprocessChargeback(transfer);
                ChargebackStatus status = preprocessResult.getFirst();
                Transfer preprocessTransfer = preprocessResult.getSecond();
                if (status == ChargebackStatus.SUCCESS) {
                    actualTransfers.add(null);
                    AccountHistoryTransferVO chargebackVO = this.accountHelper.toVO((AccountOwner)WebServiceContext.getMember(), preprocessTransfer, null);
                    AccountHistoryTransferVO transferVO = this.accountHelper.toVO((AccountOwner)WebServiceContext.getMember(), transfer, null);
                    results.add(new ChargebackResult(status, chargebackVO, transferVO));
                    continue;
                }
                actualTransfers.add(transfer);
                results.add(new ChargebackResult(status == null ? ChargebackStatus.NOT_PERFORMED : status, null, null));
                if (status == null) continue;
                hasError = true;
            }
            catch (EntityNotFoundException e) {
                hasError = true;
                results.add(new ChargebackResult(ChargebackStatus.TRANSFER_NOT_FOUND, null, null));
                this.webServiceHelper.error(new Exception("Bulk status [Id=" + id + "]: " + (Object)((Object)ChargebackStatus.TRANSFER_NOT_FOUND), e));
            }
        }
        if (hasError) {
            return results;
        }
        List<BulkChargebackResult> bulkResults = this.paymentServiceLocal.bulkChargeback(actualTransfers);
        for (int i = 0; i < actualTransfers.size(); ++i) {
            ChargebackResult result;
            BulkChargebackResult bulkResult;
            Transfer actualTransfer = (Transfer)actualTransfers.get(i);
            if (actualTransfer == null) continue;
            try {
                bulkResult = bulkResults.get(i);
            }
            catch (IndexOutOfBoundsException e) {
                bulkResult = null;
            }
            if (hasError || bulkResult == null) {
                result = new ChargebackResult(ChargebackStatus.NOT_PERFORMED, null, null);
            } else {
                ChargebackStatus status;
                block15: {
                    result = new ChargebackResult();
                    Transfer chargeback = bulkResult.getTransfer();
                    status = null;
                    if (chargeback == null) {
                        status = ChargebackStatus.TRANSFER_CANNOT_BE_CHARGEDBACK;
                        hasError = true;
                    } else {
                        status = ChargebackStatus.SUCCESS;
                        try {
                            result.setChargebackTransfer(this.accountHelper.toVO((AccountOwner)WebServiceContext.getMember(), chargeback, null));
                            result.setOriginalTransfer(this.accountHelper.toVO((AccountOwner)WebServiceContext.getMember(), actualTransfer, null));
                        }
                        catch (Exception e) {
                            this.webServiceHelper.error(e);
                            if (status != null) break block15;
                            status = ChargebackStatus.TRANSFER_CANNOT_BE_CHARGEDBACK;
                        }
                    }
                }
                result.setStatus(status);
            }
            results.set(i, result);
        }
        return results;
    }

    private ChargebackResult doChargeback(Transfer transfer) {
        Pair<ChargebackStatus, Transfer> preprocessResult = this.preprocessChargeback(transfer);
        ChargebackStatus status = preprocessResult.getFirst();
        Transfer chargebackTransfer = preprocessResult.getSecond();
        if (status == null) {
            chargebackTransfer = this.paymentServiceLocal.chargeback(transfer);
            status = ChargebackStatus.SUCCESS;
        }
        if (!status.isSuccessful()) {
            this.webServiceHelper.error("Chargeback result: " + (Object)((Object)status));
        }
        Member member = WebServiceContext.getMember();
        if (status == ChargebackStatus.SUCCESS || status == ChargebackStatus.TRANSFER_ALREADY_CHARGEDBACK) {
            AccountHistoryTransferVO chargebackVO;
            AccountHistoryTransferVO originalVO;
            block5: {
                originalVO = null;
                chargebackVO = null;
                try {
                    AccountOwner owner = member == null ? transfer.getToOwner() : member;
                    originalVO = this.accountHelper.toVO(owner, transfer, null);
                    chargebackVO = this.accountHelper.toVO(owner, chargebackTransfer, null);
                }
                catch (Exception e) {
                    this.webServiceHelper.error(e);
                    if (this.applicationServiceLocal.getLockedAccountsOnPayments() != LockedAccountsOnPayments.NONE) break block5;
                    status = ChargebackStatus.TRANSFER_CANNOT_BE_CHARGEDBACK;
                }
            }
            return new ChargebackResult(status, originalVO, chargebackVO);
        }
        return new ChargebackResult(status, null, null);
    }

    private AccountStatusVO[] getAccountStatusesForPayment(PaymentParameters params, Transfer transfer) {
        AccountStatus fromMemberStatus = null;
        AccountStatus toMemberStatus = null;
        if (WebServiceContext.getClient().getPermissions().contains(ServiceOperation.ACCOUNT_DETAILS) && params.getReturnStatus()) {
            if (WebServiceContext.getMember() == null) {
                fromMemberStatus = transfer.isFromSystem() ? null : this.accountServiceLocal.getCurrentStatus(new AccountDTO(transfer.getFrom()));
                toMemberStatus = transfer.isToSystem() ? null : this.accountServiceLocal.getCurrentStatus(new AccountDTO(transfer.getTo()));
            } else if (WebServiceContext.getMember().equals(this.paymentHelper.resolveFromMember(params))) {
                fromMemberStatus = transfer.isFromSystem() ? null : this.accountServiceLocal.getCurrentStatus(new AccountDTO(transfer.getFrom()));
            } else {
                toMemberStatus = transfer.isToSystem() ? null : this.accountServiceLocal.getCurrentStatus(new AccountDTO(transfer.getTo()));
            }
        }
        return new AccountStatusVO[]{this.accountHelper.toVO(fromMemberStatus), this.accountHelper.toVO(toMemberStatus)};
    }

    private Collection<MemberCustomField> getMemberCustomFields(Member member, List<String> fieldInternalNames) {
        HashSet<MemberCustomField> fields = new HashSet<MemberCustomField>();
        for (final String internalName : fieldInternalNames) {
            MemberCustomFieldValue mcfv = (MemberCustomFieldValue)CollectionUtils.find(member.getCustomValues(), (Predicate)new Predicate(){

                public boolean evaluate(Object object) {
                    MemberCustomFieldValue mcfv = (MemberCustomFieldValue)object;
                    return mcfv.getField().getInternalName().equals(internalName);
                }
            });
            if (mcfv == null) {
                this.webServiceHelper.trace(String.format("Required field '%1$s' was not found for member %2$s", internalName, member));
                return null;
            }
            fields.add((MemberCustomField)this.memberCustomFieldServiceLocal.load(mcfv.getField().getId()));
        }
        return fields;
    }

    private PrepareParametersResult prepareParameters(PaymentParameters params) {
        Member restricted = WebServiceContext.getMember();
        boolean fromSystem = params.getFromSystem();
        boolean toSystem = params.getToSystem();
        PaymentStatus status = null;
        Member fromMember = null;
        Member toMember = null;
        if (!fromSystem) {
            try {
                fromMember = this.paymentHelper.resolveFromMember(params);
            }
            catch (EntityNotFoundException e) {
                this.webServiceHelper.error(e);
                status = PaymentStatus.FROM_NOT_FOUND;
            }
        }
        if (status == null && !toSystem) {
            try {
                toMember = this.paymentHelper.resolveToMember(params);
            }
            catch (EntityNotFoundException e) {
                this.webServiceHelper.error(e);
                status = PaymentStatus.TO_NOT_FOUND;
            }
        }
        if (status == null) {
            if (restricted == null) {
                if (!WebServiceContext.hasPermission(ServiceOperation.DO_PAYMENT)) {
                    throw new PermissionDeniedException("The service client doesn't have the following permission: " + ServiceOperation.DO_PAYMENT);
                }
                if (fromMember != null && !this.accessServiceLocal.isChannelEnabledForMember(this.channelHelper.restricted(), fromMember)) {
                    status = PaymentStatus.INVALID_CHANNEL;
                }
            } else {
                if (fromSystem) {
                    status = PaymentStatus.FROM_NOT_FOUND;
                } else if (fromMember == null) {
                    fromMember = restricted;
                } else if (toMember == null && !toSystem) {
                    toMember = restricted;
                }
                if (status == null) {
                    if (fromMember.equals(restricted)) {
                        if (!WebServiceContext.hasPermission(ServiceOperation.DO_PAYMENT)) {
                            throw new PermissionDeniedException("The service client doesn't have the following permission: " + ServiceOperation.DO_PAYMENT);
                        }
                    } else if (!WebServiceContext.hasPermission(ServiceOperation.RECEIVE_PAYMENT)) {
                        throw new PermissionDeniedException("The service client doesn't have the following permission: " + ServiceOperation.RECEIVE_PAYMENT);
                    }
                    if (!fromMember.equals(restricted) && !toMember.equals(restricted)) {
                        status = PaymentStatus.INVALID_PARAMETERS;
                        this.webServiceHelper.trace((Object)((Object)status) + ". Reason: Neither the origin nor the destination members are equal to the restricted: " + restricted);
                    }
                }
                if (status == null) {
                    if (restricted.equals(fromMember) && !WebServiceContext.hasPermission(ServiceOperation.DO_PAYMENT)) {
                        throw new PermissionDeniedException("The service client doesn't have the following permission: " + ServiceOperation.DO_PAYMENT);
                    }
                    if (restricted.equals(toMember) && !WebServiceContext.hasPermission(ServiceOperation.RECEIVE_PAYMENT)) {
                        throw new PermissionDeniedException("The service client doesn't have the following permission: " + ServiceOperation.RECEIVE_PAYMENT);
                    }
                }
            }
        }
        if (status == null) {
            Collection<MemberGroup> visibleGroups;
            if (fromMember == null && !fromSystem) {
                status = PaymentStatus.FROM_NOT_FOUND;
            } else if (toMember == null && !toSystem) {
                status = PaymentStatus.TO_NOT_FOUND;
            } else if (fromMember != null && toMember != null && (CollectionUtils.isEmpty(visibleGroups = fromMember.getMemberGroup().getCanViewProfileOfGroups()) || !visibleGroups.contains(toMember.getGroup()))) {
                status = PaymentStatus.TO_NOT_FOUND;
            }
        }
        Collection<MemberCustomField> fromMemberfields = null;
        Collection<MemberCustomField> toMemberfields = null;
        if (status == null) {
            boolean hasFromRequired = CollectionUtils.isNotEmpty(params.getFromMemberFieldsToReturn());
            boolean hasToRequired = CollectionUtils.isNotEmpty(params.getToMemberFieldsToReturn());
            if (restricted != null && (hasFromRequired || hasToRequired) || hasFromRequired && fromSystem || hasToRequired && toSystem) {
                this.webServiceHelper.trace(restricted != null ? "Restricted web service clients are not allowed to require member custom field values" : "Can't require custom field values for a system payment");
                status = PaymentStatus.INVALID_PARAMETERS;
            }
            if (status == null && hasFromRequired) {
                fromMemberfields = this.getMemberCustomFields(fromMember, params.getFromMemberFieldsToReturn());
                PaymentStatus paymentStatus = status = fromMemberfields == null ? PaymentStatus.INVALID_PARAMETERS : null;
            }
            if (status == null && hasToRequired) {
                toMemberfields = this.getMemberCustomFields(toMember, params.getToMemberFieldsToReturn());
                PaymentStatus paymentStatus = status = toMemberfields == null ? PaymentStatus.INVALID_PARAMETERS : null;
            }
        }
        if (status == null && fromMember != null && !this.accessServiceLocal.isChannelEnabledForMember(this.channelHelper.restricted(), fromMember)) {
            status = PaymentStatus.INVALID_CHANNEL;
        }
        if (status == null) {
            boolean checkCredentials;
            if (restricted != null) {
                checkCredentials = !fromMember.equals(restricted);
            } else {
                boolean bl = checkCredentials = !fromSystem && WebServiceContext.getClient().isCredentialsRequired();
            }
            if (checkCredentials) {
                try {
                    this.checkCredentials(fromMember, WebServiceContext.getChannel(), params.getCredentials());
                }
                catch (InvalidCredentialsException e) {
                    this.webServiceHelper.error(e);
                    status = PaymentStatus.INVALID_CREDENTIALS;
                }
                catch (BlockedCredentialsException e) {
                    this.webServiceHelper.error(e);
                    status = PaymentStatus.BLOCKED_CREDENTIALS;
                }
            }
        }
        AccountOwner fromOwner = (AccountOwner)((Object)(fromSystem ? SystemAccountOwner.instance() : fromMember));
        AccountOwner toOwner = (AccountOwner)((Object)(toSystem ? SystemAccountOwner.instance() : toMember));
        return new PrepareParametersResult(status, fromOwner, toOwner, fromMemberfields, toMemberfields);
    }

    private Pair<ChargebackStatus, Transfer> preprocessChargeback(Transfer transfer) {
        ChargebackStatus status = null;
        Transfer chargebackTransfer = null;
        if (!this.paymentServiceLocal.canChargeback(transfer, false)) {
            if (transfer.getChargedBackBy() != null) {
                chargebackTransfer = transfer.getChargedBackBy();
                status = ChargebackStatus.TRANSFER_ALREADY_CHARGEDBACK;
            } else if (transfer.getStatus() == Payment.Status.PENDING) {
                TransferAuthorizationDTO transferAuthorizationDto = new TransferAuthorizationDTO();
                transferAuthorizationDto.setTransfer(transfer);
                transferAuthorizationDto.setShowToMember(false);
                chargebackTransfer = this.transferAuthorizationServiceLocal.cancel(transferAuthorizationDto);
                status = ChargebackStatus.SUCCESS;
            } else {
                status = ChargebackStatus.TRANSFER_CANNOT_BE_CHARGEDBACK;
            }
        }
        return new Pair<Object, Object>(status, chargebackTransfer);
    }

    private <V> ChargebackResult reverse(V transferId, TransferLoader<V> loader) {
        EntityNotFoundException errorException = null;
        ChargebackStatus status = null;
        Transfer transfer = null;
        try {
            transfer = loader.load(transferId);
            Member member = WebServiceContext.getMember();
            if (member != null && !transfer.getToOwner().equals(member)) {
                throw new EntityNotFoundException();
            }
            Set<TransferType> possibleTypes = this.serviceClientServiceLocal.load(WebServiceContext.getClient().getId(), ServiceClient.Relationships.CHARGEBACK_PAYMENT_TYPES).getChargebackPaymentTypes();
            if (!possibleTypes.contains(transfer.getType())) {
                throw new EntityNotFoundException();
            }
        }
        catch (EntityNotFoundException e) {
            errorException = e;
            status = ChargebackStatus.TRANSFER_NOT_FOUND;
        }
        if (status == null) {
            try {
                return this.doChargeback(transfer);
            }
            catch (Exception e) {
                this.webServiceHelper.error(e);
                return new ChargebackResult(ChargebackStatus.TRANSFER_CANNOT_BE_CHARGEDBACK, null, null);
            }
        }
        if (!status.isSuccessful()) {
            if (errorException != null) {
                this.webServiceHelper.error(errorException);
            } else {
                this.webServiceHelper.error("Chargeback status: " + (Object)((Object)status));
            }
        }
        return new ChargebackResult(status, null, null);
    }

    private boolean validateTransferType(DoPaymentDTO dto) {
        Collection<TransferType> possibleTypes = this.paymentHelper.listPossibleTypes(dto);
        return possibleTypes != null && possibleTypes.contains(dto.getTransferType());
    }

    private static interface TransferLoader<V> {
        public Transfer load(V var1);
    }

    private static class PrepareParametersResult {
        private final PaymentStatus status;
        private final AccountOwner from;
        private final AccountOwner to;
        private final Collection<MemberCustomField> fromRequiredFields;
        private final Collection<MemberCustomField> toRequiredFields;

        public PrepareParametersResult(PaymentStatus status, AccountOwner from, AccountOwner to, Collection<MemberCustomField> fromRequiredFields, Collection<MemberCustomField> toRequiredFields) {
            this.status = status;
            this.from = from;
            this.to = to;
            this.fromRequiredFields = fromRequiredFields;
            this.toRequiredFields = toRequiredFields;
        }

        public AccountOwner getFrom() {
            return this.from;
        }

        public Collection<MemberCustomField> getFromRequiredFields() {
            return this.fromRequiredFields;
        }

        public PaymentStatus getStatus() {
            return this.status;
        }

        public AccountOwner getTo() {
            return this.to;
        }

        public Collection<MemberCustomField> getToRequiredFields() {
            return this.toRequiredFields;
        }
    }
}

