/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.webservices.pos;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.jws.WebService;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.access.PrincipalType;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.AccountStatus;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.MemberAccount;
import nl.strohalm.cyclos.entities.accounts.MemberAccountType;
import nl.strohalm.cyclos.entities.accounts.pos.MemberPos;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferAuthorizationDTO;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferQuery;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.access.AccessService;
import nl.strohalm.cyclos.services.access.ChannelService;
import nl.strohalm.cyclos.services.access.exceptions.InvalidUserForChannelException;
import nl.strohalm.cyclos.services.accounts.AccountDTO;
import nl.strohalm.cyclos.services.accounts.AccountService;
import nl.strohalm.cyclos.services.accounts.pos.MemberPosServiceLocal;
import nl.strohalm.cyclos.services.elements.ElementService;
import nl.strohalm.cyclos.services.settings.SettingsService;
import nl.strohalm.cyclos.services.transactions.DoPaymentDTO;
import nl.strohalm.cyclos.services.transactions.PaymentService;
import nl.strohalm.cyclos.services.transactions.TransactionContext;
import nl.strohalm.cyclos.services.transactions.TransferAuthorizationService;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeService;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.MessageResolver;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.query.PageParameters;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import nl.strohalm.cyclos.webservices.WebServiceContext;
import nl.strohalm.cyclos.webservices.WebServiceFault;
import nl.strohalm.cyclos.webservices.WebServiceFaultsEnum;
import nl.strohalm.cyclos.webservices.accounts.AccountHistoryResultPage;
import nl.strohalm.cyclos.webservices.model.AccountHistoryTransferVO;
import nl.strohalm.cyclos.webservices.model.AccountStatusVO;
import nl.strohalm.cyclos.webservices.model.DetailedAccountTypeVO;
import nl.strohalm.cyclos.webservices.model.PosInitializationVO;
import nl.strohalm.cyclos.webservices.model.TransactionNumberVO;
import nl.strohalm.cyclos.webservices.model.WSPrincipalTypeVO;
import nl.strohalm.cyclos.webservices.payments.ChargebackResult;
import nl.strohalm.cyclos.webservices.payments.ChargebackStatus;
import nl.strohalm.cyclos.webservices.payments.PaymentResult;
import nl.strohalm.cyclos.webservices.payments.PaymentStatus;
import nl.strohalm.cyclos.webservices.pos.AccountHistoryPosParameters;
import nl.strohalm.cyclos.webservices.pos.AccountStatusPosParameters;
import nl.strohalm.cyclos.webservices.pos.ChargebackParameters;
import nl.strohalm.cyclos.webservices.pos.InitializationParameters;
import nl.strohalm.cyclos.webservices.pos.MakePaymentParameters;
import nl.strohalm.cyclos.webservices.pos.PosWebService;
import nl.strohalm.cyclos.webservices.pos.ReceivePaymentParameters;
import nl.strohalm.cyclos.webservices.utils.AccountHelper;
import nl.strohalm.cyclos.webservices.utils.MemberHelper;
import nl.strohalm.cyclos.webservices.utils.PaymentHelper;
import nl.strohalm.cyclos.webservices.utils.WebServiceHelper;

@WebService(name="pos", serviceName="pos")
public class PosWebServiceImpl
implements PosWebService {
    private AccessService accessService;
    private TransferTypeService transferTypeService;
    private ElementService elementService;
    private AccountService accountService;
    private ChannelService channelService;
    private SettingsService settingsService;
    private PaymentService paymentService;
    private AccountHelper accountHelper;
    private PaymentHelper paymentHelper;
    private MemberHelper memberHelper;
    private WebServiceHelper webServiceHelper;
    private TransferAuthorizationService transferAuthorizationService;
    private MessageResolver messageResolver;
    private MemberPosServiceLocal memberPosService;

    @Override
    public ChargebackResult chargeback(ChargebackParameters parameters) {
        LocalSettings localSettings;
        ChargebackStatus status = null;
        Member member = WebServiceContext.getMember();
        Transfer transfer = null;
        Transfer chargebackTransfer = null;
        try {
            transfer = this.paymentService.load(parameters.getTransferId(), new Relationship[0]);
            if (!transfer.getToOwner().equals(member)) {
                throw new EntityNotFoundException();
            }
        }
        catch (EntityNotFoundException e) {
            status = ChargebackStatus.TRANSFER_NOT_FOUND;
        }
        if (status == null && !this.paymentService.canChargeback(transfer, false)) {
            if (transfer.getChargedBackBy() != null) {
                status = ChargebackStatus.TRANSFER_ALREADY_CHARGEDBACK;
            } else if (transfer.getStatus() == Payment.Status.PENDING) {
                TransferAuthorizationDTO transferAuthorizationDto = new TransferAuthorizationDTO();
                transferAuthorizationDto.setTransfer(transfer);
                transferAuthorizationDto.setShowToMember(false);
                chargebackTransfer = this.transferAuthorizationService.cancel(transferAuthorizationDto);
                status = ChargebackStatus.SUCCESS;
            } else {
                status = ChargebackStatus.TRANSFER_CANNOT_BE_CHARGEDBACK;
            }
        }
        if (status == null && !(localSettings = this.settingsService.getLocalSettings()).truncate(transfer.getAmount()).equals(localSettings.truncate(parameters.getAmount()))) {
            status = ChargebackStatus.INVALID_PARAMETERS;
        }
        if (status == null) {
            chargebackTransfer = this.paymentService.chargeback(transfer);
            status = ChargebackStatus.SUCCESS;
        }
        if (!status.isSuccessful()) {
            this.webServiceHelper.error("Chargeback result " + (Object)((Object)status));
        }
        if (status == ChargebackStatus.SUCCESS || status == ChargebackStatus.TRANSFER_ALREADY_CHARGEDBACK) {
            AccountHistoryTransferVO originalVO = this.accountHelper.toVO((AccountOwner)member, transfer, null);
            AccountHistoryTransferVO chargebackVO = this.accountHelper.toVO((AccountOwner)member, chargebackTransfer, null);
            return new ChargebackResult(status, originalVO, chargebackVO);
        }
        return new ChargebackResult(status, null, null);
    }

    @Override
    public AccountStatusVO getAccountStatus(AccountStatusPosParameters parameters) {
        Member member = WebServiceContext.getMember();
        MemberAccountType accountType = EntityHelper.reference(MemberAccountType.class, parameters.getAccountTypeId());
        AccountStatus accountStatus = this.accountService.getCurrentStatus(new AccountDTO(member, accountType));
        return this.accountHelper.toVO(accountStatus);
    }

    @Override
    public PosInitializationVO getInitializationData(InitializationParameters params) {
        MemberPos memberPos = WebServiceContext.getPos().getMemberPos();
        Member member = memberPos.getMember();
        PosInitializationVO initializationData = new PosInitializationVO();
        initializationData.setOwner(this.memberHelper.toVO(memberPos.getMember()));
        Channel posChannel = WebServiceContext.getChannel();
        ArrayList<WSPrincipalTypeVO> principalTypes = new ArrayList<WSPrincipalTypeVO>();
        PrincipalType defaultPrincipalType = posChannel.getDefaultPrincipalType();
        for (PrincipalType principalType : posChannel.getPrincipalTypes()) {
            WSPrincipalTypeVO wSPrincipalTypeVO = new WSPrincipalTypeVO();
            Channel.Principal principal = principalType.getPrincipal();
            wSPrincipalTypeVO.setPrincipal(WSPrincipalTypeVO.WSPrincipal.valueOf(principal.name()));
            wSPrincipalTypeVO.setDefault(principalType.equals(defaultPrincipalType));
            MemberCustomField customField = principalType.getCustomField();
            if (customField != null) {
                wSPrincipalTypeVO.setCustomFieldInternalName(customField.getInternalName());
                wSPrincipalTypeVO.setLabel(customField.getName());
            } else {
                wSPrincipalTypeVO.setLabel(this.messageResolver.message(principal.getKey(), new Object[0]));
            }
            principalTypes.add(wSPrincipalTypeVO);
        }
        initializationData.setPrincipalTypes(principalTypes);
        ArrayList<DetailedAccountTypeVO> accountVOs = new ArrayList<DetailedAccountTypeVO>();
        for (MemberAccount memberAccount : this.accountService.getAccounts(member, new Relationship[0])) {
            if (memberAccount.getStatus() != MemberAccount.Status.ACTIVE) continue;
            accountVOs.add(this.accountHelper.toDetailedTypeVO("pos", memberAccount));
        }
        initializationData.setAccountTypes(accountVOs);
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        LocalSettings.TransactionNumber transactionNumber = localSettings.getTransactionNumber();
        if (transactionNumber != null) {
            initializationData.setTransactionNumber(new TransactionNumberVO(transactionNumber.getPrefix(), transactionNumber.getPadLength(), transactionNumber.getSuffix()));
        }
        initializationData.setDecimalDigits(localSettings.getPrecision().getValue());
        initializationData.setMaxSchedulingPayments(memberPos.getMaxSchedulingPayments());
        initializationData.setNumberOfCopies(memberPos.getNumberOfCopies());
        initializationData.setResultPageSize(memberPos.getResultPageSize());
        initializationData.setAllowMakePayment(memberPos.isAllowMakePayment());
        return initializationData;
    }

    @Override
    public PaymentResult makePayment(MakePaymentParameters params) {
        PaymentStatus status = null;
        MemberPos memberPos = WebServiceContext.getPos().getMemberPos();
        DoPaymentDTO dto = null;
        Member toMember = null;
        TransferType transferType = null;
        try {
            this.checkPin(params.getPosPin());
        }
        catch (Exception e) {
            this.webServiceHelper.error(e);
            status = this.paymentHelper.toStatus(e);
        }
        if (status == null) {
            if (!memberPos.isAllowMakePayment()) {
                throw WebServiceHelper.fault((WebServiceFault)WebServiceFaultsEnum.UNAUTHORIZED_ACCESS, "Make payment is not allowed");
            }
            try {
                PrincipalType principalType = this.channelService.resolvePrincipalType("pos", params.getToMemberPrincipalType());
                toMember = this.elementService.loadByPrincipal(principalType, params.getToMemberPrincipal(), new Relationship[0]);
                transferType = this.transferTypeService.load(params.getTransferTypeId(), new Relationship[0]);
            }
            catch (Exception e) {
                this.webServiceHelper.error(e);
                status = PaymentStatus.INVALID_PARAMETERS;
            }
        }
        if (status == null) {
            dto = new DoPaymentDTO();
            dto.setContext(TransactionContext.PAYMENT);
            dto.setChannel("pos");
            dto.setAmount(params.getAmount());
            dto.setFrom(memberPos.getMember());
            dto.setTo(toMember);
            dto.setTransferType(transferType);
        }
        AccountHistoryTransferVO transferVO = null;
        if (status == null) {
            try {
                Transfer transfer = (Transfer)this.paymentService.doPayment(dto);
                status = this.paymentHelper.toStatus(transfer);
                transferVO = this.accountHelper.toVO(dto.getFrom(), transfer, null);
            }
            catch (Exception e) {
                this.webServiceHelper.error(e);
                status = this.paymentHelper.toStatus(e);
            }
        }
        return new PaymentResult(status, transferVO);
    }

    @Override
    public PaymentResult receivePayment(ReceivePaymentParameters params) {
        Member member = WebServiceContext.getMember();
        PaymentStatus status = null;
        Member fromMember = null;
        TransferType transferType = null;
        AccountHistoryTransferVO transferVO = null;
        try {
            HttpServletRequest request = WebServiceContext.getRequest();
            String credentials = params.getFromMemberCredentials();
            String remoteAddress = request.getRemoteAddr();
            fromMember = this.memberHelper.loadByPrincipal(params.getFromMemberPrincipalType(), params.getFromMemberPrincipal(), new Relationship[0]);
            if (fromMember == null) {
                throw new EntityNotFoundException(Member.class);
            }
            if (!this.accessService.isChannelEnabledForMember("pos", fromMember)) {
                throw new InvalidUserForChannelException(fromMember.getUsername());
            }
            this.accessService.checkCredentials(WebServiceContext.getChannel(), fromMember.getMemberUser(), credentials, remoteAddress, member);
            transferType = this.transferTypeService.load(params.getTransferTypeId(), new Relationship[0]);
            final DoPaymentDTO dto = new DoPaymentDTO();
            dto.setContext(TransactionContext.PAYMENT);
            dto.setChannel("pos");
            dto.setAmount(params.getAmount());
            dto.setFrom(fromMember);
            dto.setTo(member);
            dto.setTransferType(transferType);
            Transfer transfer = LoggedUser.runAs(fromMember.getUser(), new Callable<Transfer>(){

                @Override
                public Transfer call() throws Exception {
                    return (Transfer)PosWebServiceImpl.this.paymentService.doPayment(dto);
                }
            });
            status = this.paymentHelper.toStatus(transfer);
            transferVO = this.accountHelper.toVO((AccountOwner)member, transfer, null);
        }
        catch (Exception e) {
            this.webServiceHelper.error(e);
            status = this.paymentHelper.toStatus(e);
        }
        return new PaymentResult(status, transferVO);
    }

    @Override
    public AccountHistoryResultPage searchAccountHistory(AccountHistoryPosParameters parameters) {
        MemberPos memberPos = WebServiceContext.getPos().getMemberPos();
        Member member = memberPos.getMember();
        int pageSize = memberPos.getResultPageSize();
        int currentPage = parameters.getCurrentPage();
        AccountType accountType = EntityHelper.reference(AccountType.class, parameters.getAccountTypeId());
        TransferQuery query = new TransferQuery();
        query.setOwner(member);
        query.setType(accountType);
        query.setResultType(QueryParameters.ResultType.PAGE);
        query.setPageParameters(new PageParameters(pageSize, currentPage));
        List<Transfer> transfers = this.paymentService.search(query);
        return this.accountHelper.toAccountHistoryResultPage(member, transfers);
    }

    public void setAccessService(AccessService accessService) {
        this.accessService = accessService;
    }

    public void setAccountHelper(AccountHelper accountHelper) {
        this.accountHelper = accountHelper;
    }

    public void setAccountService(AccountService accountService) {
        this.accountService = accountService;
    }

    public void setChannelService(ChannelService channelService) {
        this.channelService = channelService;
    }

    public void setElementService(ElementService elementService) {
        this.elementService = elementService;
    }

    public void setMemberHelper(MemberHelper memberHelper) {
        this.memberHelper = memberHelper;
    }

    public void setMemberPosServiceLocal(MemberPosServiceLocal memberPosService) {
        this.memberPosService = memberPosService;
    }

    public void setMessageResolver(MessageResolver messageResolver) {
        this.messageResolver = messageResolver;
    }

    public void setPaymentHelper(PaymentHelper paymentHelper) {
        this.paymentHelper = paymentHelper;
    }

    public void setPaymentService(PaymentService paymentService) {
        this.paymentService = paymentService;
    }

    public void setSettingsService(SettingsService settingsService) {
        this.settingsService = settingsService;
    }

    public void setTransferAuthorizationService(TransferAuthorizationService transferAuthorizationService) {
        this.transferAuthorizationService = transferAuthorizationService;
    }

    public void setTransferTypeService(TransferTypeService transferTypeService) {
        this.transferTypeService = transferTypeService;
    }

    public void setWebServiceHelper(WebServiceHelper webServiceHelper) {
        this.webServiceHelper = webServiceHelper;
    }

    private void checkPin(String posPin) {
        this.memberPosService.checkPin(WebServiceContext.getPos().getMemberPos(), posPin);
    }
}

