/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.webservices.rest;

import java.text.DecimalFormatSymbols;
import java.util.List;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferTypeQuery;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.settings.SettingsService;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeService;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.webservices.WebServiceContext;
import nl.strohalm.cyclos.webservices.model.MemberAccountVO;
import nl.strohalm.cyclos.webservices.model.MyProfileVO;
import nl.strohalm.cyclos.webservices.rest.AccountsRestController;
import nl.strohalm.cyclos.webservices.rest.BaseRestController;
import nl.strohalm.cyclos.webservices.rest.MembersRestController;
import nl.strohalm.cyclos.webservices.rest.TransferTypesRestController;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class AccessRestController
extends BaseRestController {
    private MembersRestController membersRestController;
    private AccountsRestController accountsRestController;
    private TransferTypeService transferTypeService;
    private SettingsService settingsService;
    private TransferTypesRestController transferTypesRestController;

    @RequestMapping(value={"access/initialData"}, method={RequestMethod.GET})
    @ResponseBody
    public InitialData getInitialData() {
        InitialData data = new InitialData();
        data.setProfile(this.membersRestController.getMyProfile());
        data.setAccounts(this.accountsRestController.listAccounts());
        data.setRequireTransactionPassword(this.isRequireTransactionPassword());
        TransferTypesRestController.TransferTypeSearchParams params = new TransferTypesRestController.TransferTypeSearchParams();
        params.setDestination(TransferTypesRestController.Destination.MEMBER);
        TransferTypeQuery query = this.transferTypesRestController.toTransferTypeQuery(params);
        List<TransferType> toMemberTTs = this.transferTypeService.search(query);
        for (TransferType tt : toMemberTTs) {
            if (!tt.getContext().isSelfPayment()) continue;
            toMemberTTs.remove(tt);
        }
        params.setDestination(TransferTypesRestController.Destination.SYSTEM);
        query = this.transferTypesRestController.toTransferTypeQuery(params);
        List<TransferType> toSystemTTs = this.transferTypeService.search(query);
        data.setCanMakeMemberPayments(CollectionUtils.isNotEmpty(toMemberTTs));
        data.setCanMakeSystemPayments(CollectionUtils.isNotEmpty(toSystemTTs));
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        data.setDecimalCount(localSettings.getPrecision().getValue());
        data.setDecimalSeparator(new DecimalFormatSymbols(localSettings.getNumberLocale().getLocale()).getDecimalSeparator());
        return data;
    }

    @RequestMapping(value={"access/requireTransactionPassword"}, method={RequestMethod.GET})
    @ResponseBody
    public boolean isRequireTransactionPassword() {
        Channel channel = WebServiceContext.getChannel();
        if (channel.getCredentials() != Channel.Credentials.DEFAULT) {
            return false;
        }
        MemberGroup group = (MemberGroup)LoggedUser.group();
        return group.getBasicSettings().getTransactionPassword().isUsed();
    }

    public void setAccountsRestController(AccountsRestController accountsRestController) {
        this.accountsRestController = accountsRestController;
    }

    public void setMembersRestController(MembersRestController membersRestController) {
        this.membersRestController = membersRestController;
    }

    public void setSettingsService(SettingsService settingsService) {
        this.settingsService = settingsService;
    }

    public void setTransferTypeService(TransferTypeService transferTypeService) {
        this.transferTypeService = transferTypeService;
    }

    public void setTransferTypesRestController(TransferTypesRestController transferTypesRestController) {
        this.transferTypesRestController = transferTypesRestController;
    }

    public static class InitialData {
        private MyProfileVO profile;
        private boolean requireTransactionPassword;
        private List<MemberAccountVO> accounts;
        private boolean canMakeMemberPayments;
        private boolean canMakeSystemPayments;
        private int decimalCount;
        private char decimalSeparator;

        public List<MemberAccountVO> getAccounts() {
            return this.accounts;
        }

        public int getDecimalCount() {
            return this.decimalCount;
        }

        public char getDecimalSeparator() {
            return this.decimalSeparator;
        }

        public MyProfileVO getProfile() {
            return this.profile;
        }

        public boolean isCanMakeMemberPayments() {
            return this.canMakeMemberPayments;
        }

        public boolean isCanMakeSystemPayments() {
            return this.canMakeSystemPayments;
        }

        public boolean isRequireTransactionPassword() {
            return this.requireTransactionPassword;
        }

        public void setAccounts(List<MemberAccountVO> accounts) {
            this.accounts = accounts;
        }

        public void setCanMakeMemberPayments(boolean canMakeMemberPayments) {
            this.canMakeMemberPayments = canMakeMemberPayments;
        }

        public void setCanMakeSystemPayments(boolean canMakeSystemPayments) {
            this.canMakeSystemPayments = canMakeSystemPayments;
        }

        public void setDecimalCount(int decimalCount) {
            this.decimalCount = decimalCount;
        }

        public void setDecimalSeparator(char decimalSeparator) {
            this.decimalSeparator = decimalSeparator;
        }

        public void setProfile(MyProfileVO profile) {
            this.profile = profile;
        }

        public void setRequireTransactionPassword(boolean requireTransactionPassword) {
            this.requireTransactionPassword = requireTransactionPassword;
        }

        public String toString() {
            return "InitialData [profile=" + this.profile + ", requireTransactionPassword=" + this.requireTransactionPassword + ", accounts=" + this.accounts + ", canMakeMemberPayments=" + this.canMakeMemberPayments + ", canMakeSystemPayments=" + this.canMakeSystemPayments + ", decimalCount=" + this.decimalCount + ", decimalSeparator=" + this.decimalSeparator + "]";
        }
    }
}

