/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.webservices.rest;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.accounts.MemberAccount;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentFilter;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentFilterQuery;
import nl.strohalm.cyclos.entities.accounts.transactions.ScheduledPayment;
import nl.strohalm.cyclos.entities.accounts.transactions.ScheduledPaymentQuery;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.members.Contact;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.accounts.AccountDTO;
import nl.strohalm.cyclos.services.accounts.AccountService;
import nl.strohalm.cyclos.services.accounts.CurrencyService;
import nl.strohalm.cyclos.services.elements.ContactService;
import nl.strohalm.cyclos.services.elements.MemberService;
import nl.strohalm.cyclos.services.transactions.PaymentService;
import nl.strohalm.cyclos.services.transactions.ScheduledPaymentService;
import nl.strohalm.cyclos.services.transfertypes.PaymentFilterService;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.conversion.Transformer;
import nl.strohalm.cyclos.webservices.accounts.AccountHistoryResultPage;
import nl.strohalm.cyclos.webservices.accounts.ScheduledPaymentsResultPage;
import nl.strohalm.cyclos.webservices.model.AccountHistoryTransferVO;
import nl.strohalm.cyclos.webservices.model.AccountStatusVO;
import nl.strohalm.cyclos.webservices.model.MemberAccountVO;
import nl.strohalm.cyclos.webservices.model.MemberAccountWithStatusVO;
import nl.strohalm.cyclos.webservices.model.PaymentFilterVO;
import nl.strohalm.cyclos.webservices.model.ScheduledPaymentVO;
import nl.strohalm.cyclos.webservices.model.SearchParameters;
import nl.strohalm.cyclos.webservices.model.TransferDataVO;
import nl.strohalm.cyclos.webservices.payments.AccountHistoryParams;
import nl.strohalm.cyclos.webservices.rest.BaseRestController;
import nl.strohalm.cyclos.webservices.rest.PaymentFieldsRestController;
import nl.strohalm.cyclos.webservices.utils.QueryHelper;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class AccountsRestController
extends BaseRestController {
    private static final String CUSTOM_VALUE_PREFIX = "customValue.";
    private AccountService accountService;
    private ContactService contactService;
    private PaymentService paymentService;
    private QueryHelper queryHelper;
    private PaymentFilterService paymentFilterService;
    private ScheduledPaymentService scheduledPaymentService;
    private CurrencyService currencyService;
    private MemberService memberService;
    private PaymentFieldsRestController paymentFieldsRestController;

    @RequestMapping(value={"accounts/info"}, method={RequestMethod.GET})
    @ResponseBody
    public List<MemberAccountWithStatusVO> getAccountsInfo() {
        List<? extends Account> accounts = this.accountService.getAccounts(LoggedUser.member(), new Relationship[0]);
        ArrayList<MemberAccountWithStatusVO> result = new ArrayList<MemberAccountWithStatusVO>();
        for (MemberAccount memberAccount : accounts) {
            AccountStatusVO statusVO = this.accountService.getCurrentAccountStatusVO(new AccountDTO(memberAccount));
            MemberAccountVO accountVO = this.accountService.getMemberAccountVO(memberAccount.getId());
            MemberAccountWithStatusVO as = new MemberAccountWithStatusVO(accountVO, statusVO);
            result.add(as);
        }
        return result;
    }

    @RequestMapping(value={"accounts/default/status"}, method={RequestMethod.GET})
    @ResponseBody
    public AccountStatusVO getDefaultStatus() {
        MemberAccount account = this.accountService.getDefaultAccount();
        return this.accountService.getCurrentAccountStatusVO(new AccountDTO(account));
    }

    @RequestMapping(value={"accounts/{id}/status"}, method={RequestMethod.GET})
    @ResponseBody
    public AccountStatusVO getStatus(@PathVariable Long id) {
        MemberAccount account;
        try {
            account = (MemberAccount)this.accountService.load(id, new Relationship[0]);
        }
        catch (Exception e) {
            throw new EntityNotFoundException(Account.class);
        }
        return this.accountService.getCurrentAccountStatusVO(new AccountDTO(account));
    }

    @RequestMapping(value={"accounts"}, method={RequestMethod.GET})
    @ResponseBody
    public List<MemberAccountVO> listAccounts() {
        List<? extends Account> accounts = this.accountService.getAccounts(LoggedUser.member(), new Relationship[0]);
        ArrayList<MemberAccountVO> result = new ArrayList<MemberAccountVO>(accounts.size());
        if (accounts != null) {
            for (MemberAccount memberAccount : accounts) {
                MemberAccountVO memberAccountVO = this.accountService.getMemberAccountVO(memberAccount.getId());
                result.add(memberAccountVO);
            }
        }
        return result;
    }

    @RequestMapping(value={"accounts/default/paymentFilters"}, method={RequestMethod.GET})
    @ResponseBody
    public List<PaymentFilterVO> listDefaultPaymentFilters() {
        MemberAccount account = this.accountService.getDefaultAccount();
        return this.listPaymentFilters(account);
    }

    @RequestMapping(value={"accounts/{id}/paymentFilters"}, method={RequestMethod.GET})
    @ResponseBody
    public List<PaymentFilterVO> listPaymentFilters(@PathVariable Long id) {
        MemberAccount account;
        try {
            account = (MemberAccount)this.accountService.load(id, new Relationship[0]);
        }
        catch (Exception e) {
            throw new EntityNotFoundException(Account.class);
        }
        return this.listPaymentFilters(account);
    }

    @RequestMapping(value={"accounts/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public MemberAccountVO loadAccount(@PathVariable Long id) {
        return this.accountService.getMemberAccountVO(id);
    }

    public Currency loadCurrencyByIdOrSymbol(Long id, String symbol) {
        String idOrSymbol;
        String string = idOrSymbol = id == null ? symbol : id.toString();
        if (StringUtils.isNotEmpty((String)idOrSymbol)) {
            return this.currencyService.loadBySymbolOrId(idOrSymbol);
        }
        return null;
    }

    @RequestMapping(value={"accounts/default"}, method={RequestMethod.GET})
    @ResponseBody
    public MemberAccountVO loadDefaultAccount() {
        MemberAccount account = this.accountService.getDefaultAccount();
        return this.accountService.getMemberAccountVO(account.getId());
    }

    @RequestMapping(value={"accounts/scheduledPayment/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public ScheduledPaymentVO loadScheduledPayment(@PathVariable Long id) {
        return this.scheduledPaymentService.getScheduledPaymentVO(id);
    }

    @RequestMapping(value={"accounts/transfer/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public AccountHistoryTransferVO loadTransfer(@PathVariable Long id) {
        return this.paymentService.getAccountHistoryTransferVO(id);
    }

    @RequestMapping(value={"accounts/transferData/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public TransferDataVO loadTransferData(@PathVariable Long id) {
        Transfer transfer;
        try {
            transfer = this.paymentService.load(id, new Relationship[0]);
        }
        catch (Exception e) {
            throw new EntityNotFoundException(Transfer.class);
        }
        AccountHistoryTransferVO accountHistoryTransferVO = this.paymentService.getAccountHistoryTransferVO(id);
        AccountOwner relatedAccountOwner = null;
        relatedAccountOwner = LoggedUser.member().equals(transfer.getFromOwner()) ? transfer.getToOwner() : transfer.getFromOwner();
        boolean canAddRelatedMemberAsContact = false;
        if (relatedAccountOwner != null && relatedAccountOwner instanceof Member && LoggedUser.member() != relatedAccountOwner) {
            Member m = (Member)relatedAccountOwner;
            Contact contact = this.contactService.loadIfExists(LoggedUser.member(), m, new Relationship[0]);
            if (contact == null) {
                canAddRelatedMemberAsContact = true;
            }
        }
        return new TransferDataVO(accountHistoryTransferVO, canAddRelatedMemberAsContact);
    }

    @RequestMapping(value={"accounts/{id}/history"}, method={RequestMethod.GET})
    @ResponseBody
    public AccountHistoryResultPage searchAccountHistory(@PathVariable Long id, AccountHistoryParams params, HttpServletRequest request) {
        params.setMemberAccountId(id);
        return this.search(params, request);
    }

    @RequestMapping(value={"accounts/default/history"}, method={RequestMethod.GET})
    @ResponseBody
    public AccountHistoryResultPage searchDefaultAccountHistory(AccountHistoryParams params, HttpServletRequest request) {
        params.setMemberAccountId(null);
        return this.search(params, request);
    }

    @RequestMapping(value={"accounts/default/scheduledPayments"}, method={RequestMethod.GET})
    @ResponseBody
    public ScheduledPaymentsResultPage searchDefaultScheduledPayments(SearchScheduledPaymentParams params) {
        MemberAccount account = this.accountService.getDefaultAccount();
        return this.searchScheduledPayments(account, params);
    }

    @RequestMapping(value={"accounts/{id}/scheduledPayments"}, method={RequestMethod.GET})
    @ResponseBody
    public ScheduledPaymentsResultPage searchScheduledPayments(@PathVariable Long id, SearchScheduledPaymentParams params) {
        MemberAccount account = (MemberAccount)this.accountService.load(id, new Relationship[0]);
        return this.searchScheduledPayments(account, params);
    }

    public void setAccountService(AccountService accountService) {
        this.accountService = accountService;
    }

    public void setContactService(ContactService contactService) {
        this.contactService = contactService;
    }

    public void setCurrencyService(CurrencyService currencyService) {
        this.currencyService = currencyService;
    }

    public void setMemberService(MemberService memberService) {
        this.memberService = memberService;
    }

    public void setPaymentFieldsRestController(PaymentFieldsRestController paymentFieldsRestController) {
        this.paymentFieldsRestController = paymentFieldsRestController;
    }

    public void setPaymentFilterService(PaymentFilterService paymentFilterService) {
        this.paymentFilterService = paymentFilterService;
    }

    public void setPaymentService(PaymentService paymentService) {
        this.paymentService = paymentService;
    }

    public void setQueryHelper(QueryHelper queryHelper) {
        this.queryHelper = queryHelper;
    }

    public void setScheduledPaymentService(ScheduledPaymentService scheduledPaymentService) {
        this.scheduledPaymentService = scheduledPaymentService;
    }

    private List<PaymentFilterVO> listPaymentFilters(MemberAccount account) {
        PaymentFilterQuery query = new PaymentFilterQuery();
        query.setContext(PaymentFilterQuery.Context.ACCOUNT_HISTORY);
        query.setAccount(account);
        List<PaymentFilter> paymentFilters = this.paymentFilterService.search(query);
        return this.paymentFilterService.getPaymentFilterVOs(paymentFilters);
    }

    private AccountHistoryResultPage search(AccountHistoryParams params, HttpServletRequest request) {
        params.setCustomValues(this.paymentFieldsRestController.requestParametersToFieldValues(request, CUSTOM_VALUE_PREFIX));
        return this.paymentService.getAccountHistoryResultPage(params);
    }

    private ScheduledPaymentsResultPage searchScheduledPayments(MemberAccount account, SearchScheduledPaymentParams params) {
        Member member = this.memberService.loadByIdOrPrincipal(params.getMemberId(), null, params.getMemberPrincipal());
        ScheduledPaymentQuery query = new ScheduledPaymentQuery();
        this.queryHelper.fill(params, query);
        query.setOwner(account.getOwner());
        query.setMember(member);
        query.setPeriod(Period.between(params.getBeginDate(), params.getEndDate()));
        query.setSearchType(params.getIncoming() ? ScheduledPaymentQuery.SearchType.INCOMING : ScheduledPaymentQuery.SearchType.OUTGOING);
        if (params.getStatus() == null) {
            query.setStatusGroup(ScheduledPaymentQuery.StatusGroup.OPEN);
        } else {
            query.setStatusGroup(ScheduledPaymentQuery.StatusGroup.valueOf(params.getStatus().name()));
        }
        List<ScheduledPayment> scheduledPayments = this.scheduledPaymentService.search(query);
        return this.toScheduledResultPage(scheduledPayments);
    }

    private ScheduledPaymentsResultPage toScheduledResultPage(List<ScheduledPayment> payments) {
        return this.queryHelper.toResultPage(ScheduledPaymentsResultPage.class, payments, new Transformer<ScheduledPayment, ScheduledPaymentVO>(){

            @Override
            public ScheduledPaymentVO transform(ScheduledPayment scheduledPayment) {
                return AccountsRestController.this.scheduledPaymentService.getScheduledPaymentVO(scheduledPayment.getId());
            }
        });
    }

    public static enum SearchScheduledPaymentStatus {
        OPEN,
        CLOSED_WITHOUT_ERRORS,
        CLOSED_WITH_ERRORS;

    }

    public static class SearchScheduledPaymentParams
    extends SearchParameters {
        private static final long serialVersionUID = 1L;
        private String memberPrincipal;
        private Long memberId;
        private Calendar beginDate;
        private Calendar endDate;
        private Boolean incoming = false;
        private SearchScheduledPaymentStatus status;

        public Calendar getBeginDate() {
            return this.beginDate;
        }

        public Calendar getEndDate() {
            return this.endDate;
        }

        public boolean getIncoming() {
            return this.incoming;
        }

        public Long getMemberId() {
            return this.memberId;
        }

        public String getMemberPrincipal() {
            return this.memberPrincipal;
        }

        public SearchScheduledPaymentStatus getStatus() {
            return this.status;
        }

        public void setBeginDate(Calendar beginDate) {
            this.beginDate = beginDate;
        }

        public void setEndDate(Calendar endDate) {
            this.endDate = endDate;
        }

        public void setIncoming(boolean incoming) {
            this.incoming = incoming;
        }

        public void setMemberId(Long memberId) {
            this.memberId = memberId;
        }

        public void setMemberPrincipal(String memberPrincipal) {
            this.memberPrincipal = memberPrincipal;
        }

        public void setStatus(SearchScheduledPaymentStatus status) {
            this.status = status;
        }
    }
}

