/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.webservices.rest;

import java.util.ArrayList;
import java.util.List;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.ads.Ad;
import nl.strohalm.cyclos.entities.ads.AdCategory;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.services.ads.AdCategoryService;
import nl.strohalm.cyclos.webservices.model.AdCategoryHierarchicalVO;
import nl.strohalm.cyclos.webservices.rest.BaseRestController;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class AdCategoriesRestController
extends BaseRestController {
    private AdCategoryService adCategoryService;

    @RequestMapping(value={"adCategories"}, method={RequestMethod.GET})
    @ResponseBody
    public List<AdCategoryHierarchicalVO> listChildren() {
        ArrayList<AdCategoryHierarchicalVO> vos = new ArrayList<AdCategoryHierarchicalVO>();
        for (AdCategory category : this.adCategoryService.listRoot()) {
            AdCategoryHierarchicalVO vo = this.adCategoryService.getHierarchicalVO(category);
            if (vo == null) continue;
            vos.add(vo);
        }
        return vos;
    }

    @RequestMapping(value={"adCategories/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public AdCategoryHierarchicalVO loadById(@PathVariable Long id) {
        AdCategory category;
        try {
            category = this.adCategoryService.load(id, new Relationship[0]);
        }
        catch (Exception e) {
            throw new EntityNotFoundException(Ad.class);
        }
        return this.adCategoryService.getHierarchicalVO(category);
    }

    public void setAdCategoryService(AdCategoryService adCategoryService) {
        this.adCategoryService = adCategoryService;
    }
}

