/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.webservices.rest;

import java.util.ArrayList;
import java.util.List;
import nl.strohalm.cyclos.entities.customization.fields.AdCustomField;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.services.customization.AdCustomFieldService;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.webservices.model.FieldVO;
import nl.strohalm.cyclos.webservices.model.PossibleValueVO;
import nl.strohalm.cyclos.webservices.rest.BaseFieldsRestController;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class AdFieldsRestController
extends BaseFieldsRestController<AdCustomField> {
    private AdCustomFieldService adCustomFieldService;

    @RequestMapping(value={"adFields"}, method={RequestMethod.GET})
    @ResponseBody
    public List<FieldVO> list() {
        List fields = this.adCustomFieldService.list();
        ArrayList<Long> customFieldIds = new ArrayList<Long>(EntityHelper.toIdsAsList(fields));
        return this.adCustomFieldService.getFieldVOs(customFieldIds);
    }

    @RequestMapping(value={"adFields/forSearch"}, method={RequestMethod.GET})
    @ResponseBody
    public List<FieldVO> listForList() {
        List<AdCustomField> fields = this.adCustomFieldService.list();
        fields = this.customFieldHelper.onlyForAdsSearch(fields);
        ArrayList<Long> customFieldIds = new ArrayList<Long>(EntityHelper.toIdsAsList(fields));
        return this.adCustomFieldService.getFieldVOs(customFieldIds);
    }

    @RequestMapping(value={"adFields/{id}/possibleValues"}, method={RequestMethod.GET})
    @ResponseBody
    public List<PossibleValueVO> listPossibleValues(@PathVariable Long id) {
        return this.adCustomFieldService.getPossibleValueVOs(id, null);
    }

    @RequestMapping(value={"adFields/name/{name}/possibleValues"}, method={RequestMethod.GET})
    @ResponseBody
    public List<PossibleValueVO> listPossibleValuesByInternalName(@PathVariable String name) {
        AdCustomField field = this.load(name);
        return this.adCustomFieldService.getPossibleValueVOs(field.getId(), null);
    }

    @RequestMapping(value={"adFields/name/{name}/possibleValues/{parentValueId}"}, method={RequestMethod.GET})
    @ResponseBody
    public List<PossibleValueVO> listPossibleValuesByInternalNameAndParent(@PathVariable String name, @PathVariable Long parentValueId) {
        AdCustomField field = this.load(name);
        return this.adCustomFieldService.getPossibleValueVOs(field.getId(), parentValueId);
    }

    @RequestMapping(value={"adFields/{fieldId}/possibleValues/{parentValueId}"}, method={RequestMethod.GET})
    @ResponseBody
    public List<PossibleValueVO> listPossibleValuesByParent(@PathVariable Long fieldId, @PathVariable Long parentValueId) {
        return this.adCustomFieldService.getPossibleValueVOs(fieldId, parentValueId);
    }

    @RequestMapping(value={"adFields/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public FieldVO loadById(@PathVariable Long id) {
        return this.adCustomFieldService.getFieldVO(id);
    }

    @RequestMapping(value={"adFields/name/{name}"}, method={RequestMethod.GET})
    @ResponseBody
    public FieldVO loadByInternalName(@PathVariable String name) {
        AdCustomField ad = this.load(name);
        return this.adCustomFieldService.getFieldVO(ad.getId());
    }

    public void setAdCustomFieldService(AdCustomFieldService adCustomFieldService) {
        this.adCustomFieldService = adCustomFieldService;
    }

    private AdCustomField load(String name) {
        try {
            AdCustomField field = (AdCustomField)this.customFieldHelper.findByInternalName(this.adCustomFieldService.list(), name);
            if (field == null) {
                throw new Exception();
            }
            return field;
        }
        catch (Exception e) {
            throw new EntityNotFoundException(AdCustomField.class);
        }
    }
}

