/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.webservices.rest;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.ads.Ad;
import nl.strohalm.cyclos.entities.ads.AdQuery;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.services.ads.AdService;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.conversion.Transformer;
import nl.strohalm.cyclos.utils.query.PageParameters;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import nl.strohalm.cyclos.webservices.ads.AbstractAdSearchParameters;
import nl.strohalm.cyclos.webservices.ads.AdResultPage;
import nl.strohalm.cyclos.webservices.ads.FullTextAdSearchParameters;
import nl.strohalm.cyclos.webservices.model.AdVO;
import nl.strohalm.cyclos.webservices.rest.AdFieldsRestController;
import nl.strohalm.cyclos.webservices.rest.BaseRestController;
import nl.strohalm.cyclos.webservices.rest.MemberFieldsRestController;
import nl.strohalm.cyclos.webservices.utils.QueryHelper;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class AdsRestController
extends BaseRestController {
    private static final String MEMBER_CUSTOM_VALUE = "memberCustomValue.";
    private static final String AD_CUSTOM_VALUE = "adCustomValue.";
    private QueryHelper queryHelper;
    private AdService adService;
    private MemberFieldsRestController memberFieldsRestController;
    private AdFieldsRestController adFieldsRestController;

    @RequestMapping(value={"ads/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public AdVO loadById(@PathVariable Long id) {
        Ad ad;
        try {
            ad = this.adService.load(id, new Relationship[0]);
        }
        catch (Exception e) {
            throw new EntityNotFoundException(Ad.class);
        }
        return this.adService.getAdVO(AdVO.class, ad, true, true, false);
    }

    @RequestMapping(value={"ads"}, method={RequestMethod.GET})
    @ResponseBody
    public AdResultPage search(FullTextAdSearchParameters params, @RequestParam(required=false) String memberPrincipal, @RequestParam(defaultValue="false") boolean searching, HttpServletRequest request) {
        if (params == null) {
            params = new FullTextAdSearchParameters();
        }
        params.setTradeType(searching ? AbstractAdSearchParameters.AdVOTradeType.SEARCH : AbstractAdSearchParameters.AdVOTradeType.OFFER);
        params.setMemberGroupIds(null);
        params.setMemberFields(this.memberFieldsRestController.requestParametersToFieldValues(request, MEMBER_CUSTOM_VALUE));
        params.setAdFields(this.adFieldsRestController.requestParametersToFieldValues(request, AD_CUSTOM_VALUE));
        return this.adService.getAdResultPage(params, memberPrincipal);
    }

    @RequestMapping(value={"ads/mine"}, method={RequestMethod.GET})
    @ResponseBody
    public AdResultPage searchMine(@RequestParam(defaultValue="10") int pageSize, @RequestParam(defaultValue="0") int currentPage) {
        AdQuery query = new AdQuery();
        query.setResultType(QueryParameters.ResultType.PAGE);
        query.setPageParameters(new PageParameters(pageSize, currentPage));
        query.setOwner(LoggedUser.member());
        List<Ad> ads = this.adService.search(query);
        return this.queryHelper.toResultPage(AdResultPage.class, ads, new Transformer<Ad, AdVO>(){

            @Override
            public AdVO transform(Ad ad) {
                return AdsRestController.this.adService.getMyVO(ad);
            }
        });
    }

    public void setAdFieldsRestController(AdFieldsRestController adFieldsRestController) {
        this.adFieldsRestController = adFieldsRestController;
    }

    public void setAdService(AdService adService) {
        this.adService = adService;
    }

    public void setMemberFieldsRestController(MemberFieldsRestController memberFieldsRestController) {
        this.memberFieldsRestController = memberFieldsRestController;
    }

    public void setQueryHelper(QueryHelper queryHelper) {
        this.queryHelper = queryHelper;
    }
}

