/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.webservices.rest;

import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import nl.strohalm.cyclos.utils.Pair;
import nl.strohalm.cyclos.webservices.model.ServerErrorVO;
import nl.strohalm.cyclos.webservices.rest.RestHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

public abstract class BaseRestController {
    private static final Log LOG = LogFactory.getLog(BaseRestController.class);

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public ServerErrorVO handleUnknownException(Exception ex, HttpServletResponse response) throws IOException {
        Pair<ServerErrorVO, Integer> error = RestHelper.resolveError(ex);
        int errorCode = error.getSecond();
        if (errorCode == 500) {
            LOG.error((Object)"Error on REST call", (Throwable)ex);
        }
        response.setStatus(errorCode);
        return error.getFirst();
    }
}

