/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.webservices.rest;

import java.util.List;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.members.Contact;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.elements.ContactService;
import nl.strohalm.cyclos.services.elements.MemberService;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.webservices.model.ContactVO;
import nl.strohalm.cyclos.webservices.rest.BaseRestController;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ContactsRestController
extends BaseRestController {
    private ContactService contactService;
    private MemberService memberService;

    @RequestMapping(value={"contacts"}, method={RequestMethod.GET})
    @ResponseBody
    public List<ContactVO> listContacts() {
        Member member = (Member)LoggedUser.element();
        List<Contact> contacts = this.contactService.list(member);
        return this.contactService.getContactVOs(contacts, true, true);
    }

    @RequestMapping(value={"contacts/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public ContactVO loadById(@PathVariable Long id) {
        return this.contactService.getContactVO(id, true, true);
    }

    @RequestMapping(value={"contacts/byMemberId/{memberId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ContactVO loadByMemberId(@PathVariable Long memberId) {
        return this.getContactVO(memberId, null);
    }

    @RequestMapping(value={"contacts/byMemberPrincipal/{principal}"}, method={RequestMethod.GET})
    @ResponseBody
    public ContactVO loadByMemberPrincipal(@PathVariable String principal) {
        return this.getContactVO(null, principal);
    }

    @RequestMapping(value={"contacts/{id}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void removeById(@PathVariable Long id) {
        Contact contact;
        try {
            contact = this.contactService.load(id, RelationshipHelper.nested(Contact.Relationships.CONTACT, Element.Relationships.GROUP));
        }
        catch (Exception e) {
            throw new EntityNotFoundException(Contact.class);
        }
        this.remove(contact);
    }

    @RequestMapping(value={"contacts/byMemberId/{memberId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void removeByMemberId(@PathVariable Long memberId) {
        Contact contact = this.getContact(memberId, null);
        this.remove(contact);
    }

    @RequestMapping(value={"contacts/byMemberPrincipal/{principal}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void removeByMemberPrincipal(@PathVariable String principal) {
        Contact contact = this.getContact(null, principal);
        this.remove(contact);
    }

    @RequestMapping(value={"contacts/byMemberId/{memberId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ContactVO saveByMemberId(@PathVariable Long memberId, @RequestBody ContactNotes params) {
        return this.saveContact(memberId, null, this.getNotes(params));
    }

    @RequestMapping(value={"contacts/byMemberPrincipal/{principal}"}, method={RequestMethod.POST})
    @ResponseBody
    public ContactVO saveByMemberPrincipal(@PathVariable String principal, @RequestBody ContactNotes params) {
        return this.saveContact(null, principal, this.getNotes(params));
    }

    public void setContactService(ContactService contactService) {
        this.contactService = contactService;
    }

    public void setMemberService(MemberService memberService) {
        this.memberService = memberService;
    }

    private Contact getContact(Long memberId, String memberPrincipal) {
        Member member = this.memberService.loadByIdOrPrincipal(memberId, null, memberPrincipal);
        if (member == null) {
            throw new EntityNotFoundException(Member.class);
        }
        Member loggedMember = LoggedUser.member();
        Contact contact = this.contactService.load(loggedMember, member, new Relationship[0]);
        return contact;
    }

    private ContactVO getContactVO(Long memberId, String memberPrincipal) {
        Contact contact = this.getContact(memberId, memberPrincipal);
        return this.contactService.getContactVO(contact.getId(), true, true);
    }

    private String getNotes(ContactNotes notes) {
        return notes == null ? null : notes.getNotes();
    }

    private void remove(Contact contact) {
        this.contactService.remove(contact.getId());
    }

    private ContactVO saveContact(Long memberId, String memberPrincipal, String notes) {
        Member member = this.memberService.loadByIdOrPrincipal(memberId, null, memberPrincipal);
        if (member == null) {
            throw new EntityNotFoundException(Member.class);
        }
        Member loggedMember = LoggedUser.member();
        Contact contact = this.contactService.loadIfExists(loggedMember, member, new Relationship[0]);
        if (contact == null) {
            contact = new Contact();
            contact.setOwner(loggedMember);
            contact.setContact(member);
        }
        contact.setNotes(notes);
        Contact savedContact = this.contactService.save(contact);
        return this.contactService.getContactVO(savedContact.getId(), true, true);
    }

    public static class ContactNotes {
        private String notes;

        public String getNotes() {
            return this.notes;
        }

        public void setNotes(String notes) {
            this.notes = notes;
        }
    }
}

