/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.webservices.rest;

import java.util.ArrayList;
import java.util.List;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.access.PrincipalType;
import nl.strohalm.cyclos.entities.customization.images.Image;
import nl.strohalm.cyclos.entities.customization.images.SystemImage;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.application.ApplicationService;
import nl.strohalm.cyclos.services.customization.ImageService;
import nl.strohalm.cyclos.services.customization.MemberCustomFieldService;
import nl.strohalm.cyclos.services.settings.SettingsService;
import nl.strohalm.cyclos.utils.MessageResolver;
import nl.strohalm.cyclos.webservices.WebServiceContext;
import nl.strohalm.cyclos.webservices.model.FieldVO;
import nl.strohalm.cyclos.webservices.model.ImageVO;
import nl.strohalm.cyclos.webservices.rest.BaseRestController;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class GeneralRestController
extends BaseRestController {
    private static final String MOBILE_WELCOME_MESSAGE_KEY = "mobile.welcomeMessage";
    private SettingsService settingsService;
    private ApplicationService applicationService;
    private ImageService imageService;
    private MemberCustomFieldService memberCustomFieldService;
    private MessageResolver messageResolver;

    @RequestMapping(value={"general"}, method={RequestMethod.GET})
    @ResponseBody
    public GeneralData getGeneralData() {
        Channel channel = WebServiceContext.getChannel();
        PrincipalType principalType = channel.getDefaultPrincipalType();
        Channel.Credentials credentials = channel.getCredentials();
        if (credentials == Channel.Credentials.DEFAULT) {
            credentials = Channel.Credentials.LOGIN_PASSWORD;
        }
        LocalSettings settings = this.settingsService.getLocalSettings();
        GeneralData data = new GeneralData();
        data.setWelcomeMessage(this.messageResolver.message(MOBILE_WELCOME_MESSAGE_KEY, settings.getApplicationName()));
        data.setApplicationName(settings.getApplicationName());
        data.setCyclosVersion(this.applicationService.getCyclosVersion());
        data.setPrincipalType(PrincipalTypeVO.valueOf(principalType.getPrincipal().name()));
        if (principalType.getCustomField() != null) {
            data.setPrincipalCustomField(this.memberCustomFieldService.getFieldVO(principalType.getCustomField().getId()));
        }
        data.setCredentialType(CredentialTypeVO.valueOf(credentials.name()));
        ArrayList<ImageVO> imageVos = new ArrayList<ImageVO>();
        List<? extends Image> images = this.imageService.listByNature(Image.Nature.SYSTEM);
        for (SystemImage systemImage : images) {
            String simpleName = systemImage.getSimpleName();
            if (!simpleName.startsWith("mobileSplash")) continue;
            ImageVO vo = this.imageService.getImageVO(systemImage);
            vo.setCaption(simpleName);
            imageVos.add(vo);
        }
        data.setImages(imageVos);
        return data;
    }

    public void setApplicationService(ApplicationService applicationService) {
        this.applicationService = applicationService;
    }

    public void setImageService(ImageService imageService) {
        this.imageService = imageService;
    }

    public void setMemberCustomFieldService(MemberCustomFieldService memberCustomFieldService) {
        this.memberCustomFieldService = memberCustomFieldService;
    }

    public void setMessageResolver(MessageResolver messageResolver) {
        this.messageResolver = messageResolver;
    }

    public void setSettingsService(SettingsService settingsService) {
        this.settingsService = settingsService;
    }

    public static enum PrincipalTypeVO {
        USER,
        EMAIL,
        CARD,
        CUSTOM_FIELD;

    }

    public static class GeneralData {
        private String cyclosVersion;
        private String applicationName;
        private String welcomeMessage;
        private PrincipalTypeVO principalType;
        private FieldVO principalCustomField;
        private CredentialTypeVO credentialType;
        private List<ImageVO> images;

        public String getApplicationName() {
            return this.applicationName;
        }

        public CredentialTypeVO getCredentialType() {
            return this.credentialType;
        }

        public String getCyclosVersion() {
            return this.cyclosVersion;
        }

        public List<ImageVO> getImages() {
            return this.images;
        }

        public FieldVO getPrincipalCustomField() {
            return this.principalCustomField;
        }

        public PrincipalTypeVO getPrincipalType() {
            return this.principalType;
        }

        public String getWelcomeMessage() {
            return this.welcomeMessage;
        }

        public void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public void setCredentialType(CredentialTypeVO credentialType) {
            this.credentialType = credentialType;
        }

        public void setCyclosVersion(String cyclosVersion) {
            this.cyclosVersion = cyclosVersion;
        }

        public void setImages(List<ImageVO> images) {
            this.images = images;
        }

        public void setPrincipalCustomField(FieldVO principalCustomField) {
            this.principalCustomField = principalCustomField;
        }

        public void setPrincipalType(PrincipalTypeVO principalType) {
            this.principalType = principalType;
        }

        public void setWelcomeMessage(String welcomeMessage) {
            this.welcomeMessage = welcomeMessage;
        }

        public String toString() {
            return "GeneralData [cyclosVersion=" + this.cyclosVersion + ", welcomeMessage=" + this.welcomeMessage + ", applicationName=" + this.applicationName + ", principalType=" + (Object)((Object)this.principalType) + ", principalCustomField=" + this.principalCustomField + ", credentialType=" + (Object)((Object)this.credentialType) + ", images=" + this.images + "]";
        }
    }

    public static enum CredentialTypeVO {
        LOGIN_PASSWORD,
        TRANSACTION_PASSWORD,
        PIN,
        CARD_SECURITY_CODE;

    }
}

