/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.webservices.rest;

import java.util.ArrayList;
import java.util.List;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.customization.MemberCustomFieldService;
import nl.strohalm.cyclos.services.elements.ElementService;
import nl.strohalm.cyclos.services.elements.MemberService;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.webservices.model.FieldVO;
import nl.strohalm.cyclos.webservices.model.PossibleValueVO;
import nl.strohalm.cyclos.webservices.rest.BaseFieldsRestController;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class MemberFieldsRestController
extends BaseFieldsRestController<MemberCustomField> {
    private ElementService elementService;
    private MemberCustomFieldService memberCustomFieldService;
    private MemberService memberService;

    @RequestMapping(value={"memberFields/byMemberId/{userId}"}, method={RequestMethod.GET})
    @ResponseBody
    public List<FieldVO> listByMemberId(@PathVariable Long userId) {
        Member member;
        try {
            member = (Member)this.elementService.load(userId, new Relationship[0]);
        }
        catch (Exception e) {
            throw new EntityNotFoundException(Member.class);
        }
        return this.list(member);
    }

    @RequestMapping(value={"memberFields/byMemberPrincipal/{principal}"}, method={RequestMethod.GET})
    @ResponseBody
    public List<FieldVO> listByMemberPrincipal(@PathVariable String principal) {
        Member member;
        try {
            member = this.memberService.loadByIdOrPrincipal(null, null, principal);
        }
        catch (Exception e) {
            throw new EntityNotFoundException(Member.class);
        }
        return this.list(member);
    }

    @RequestMapping(value={"memberFields/forAdsSearch"}, method={RequestMethod.GET})
    @ResponseBody
    public List<FieldVO> listForAdsSearch() {
        List<MemberCustomField> fields = this.memberCustomFieldService.list();
        fields = this.customFieldHelper.onlyForAdSearch(fields);
        ArrayList<Long> customFieldIds = new ArrayList<Long>(EntityHelper.toIdsAsList(fields));
        return this.memberCustomFieldService.getFieldVOs(customFieldIds);
    }

    @RequestMapping(value={"memberFields/forSearch"}, method={RequestMethod.GET})
    @ResponseBody
    public List<FieldVO> listForUserSearch() {
        List<MemberCustomField> fields = this.memberCustomFieldService.list();
        fields = this.customFieldHelper.onlyForMemberSearch(fields);
        ArrayList<Long> customFieldIds = new ArrayList<Long>(EntityHelper.toIdsAsList(fields));
        return this.memberCustomFieldService.getFieldVOs(customFieldIds);
    }

    @RequestMapping(value={"memberFields/mine"}, method={RequestMethod.GET})
    @ResponseBody
    public List<FieldVO> listMine() {
        List<MemberCustomField> fields = this.memberCustomFieldService.list();
        fields = this.customFieldHelper.onlyOwnedFields(fields, LoggedUser.member().getMemberGroup());
        ArrayList<Long> customFieldIds = new ArrayList<Long>(EntityHelper.toIdsAsList(fields));
        return this.memberCustomFieldService.getFieldVOs(customFieldIds);
    }

    @RequestMapping(value={"memberFields/{id}/possibleValues"}, method={RequestMethod.GET})
    @ResponseBody
    public List<PossibleValueVO> listPossibleValues(@PathVariable Long id) {
        return this.memberCustomFieldService.getPossibleValueVOs(id, null);
    }

    @RequestMapping(value={"memberFields/name/{name}/possibleValues"}, method={RequestMethod.GET})
    @ResponseBody
    public List<PossibleValueVO> listPossibleValuesByInternalName(@PathVariable String name) {
        MemberCustomField field = this.load(name);
        return this.memberCustomFieldService.getPossibleValueVOs(field.getId(), null);
    }

    @RequestMapping(value={"memberFields/name/{name}/possibleValues/{parentValueId}"}, method={RequestMethod.GET})
    @ResponseBody
    public List<PossibleValueVO> listPossibleValuesByInternalNameAndParent(@PathVariable String name, @PathVariable Long parentValueId) {
        MemberCustomField field = this.load(name);
        return this.memberCustomFieldService.getPossibleValueVOs(field.getId(), parentValueId);
    }

    @RequestMapping(value={"memberFields/{fieldId}/possibleValues/{parentValueId}"}, method={RequestMethod.GET})
    @ResponseBody
    public List<PossibleValueVO> listPossibleValuesByParent(@PathVariable Long fieldId, @PathVariable Long parentValueId) {
        return this.memberCustomFieldService.getPossibleValueVOs(fieldId, parentValueId);
    }

    @RequestMapping(value={"memberFields/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public FieldVO loadById(@PathVariable Long id) {
        return this.memberCustomFieldService.getFieldVO(id);
    }

    @RequestMapping(value={"memberFields/name/{name}"}, method={RequestMethod.GET})
    @ResponseBody
    public FieldVO loadByInternalName(@PathVariable String name) {
        MemberCustomField memberField = this.load(name);
        return this.memberCustomFieldService.getFieldVO(memberField.getId());
    }

    public void setElementService(ElementService elementService) {
        this.elementService = elementService;
    }

    public void setMemberCustomFieldService(MemberCustomFieldService memberCustomFieldService) {
        this.memberCustomFieldService = memberCustomFieldService;
    }

    public void setMemberService(MemberService memberService) {
        this.memberService = memberService;
    }

    private List<FieldVO> list(Member member) {
        List<MemberCustomField> fields = this.memberCustomFieldService.list();
        fields = this.customFieldHelper.onlyVisibleFields(fields, member.getMemberGroup());
        ArrayList<Long> customFieldIds = new ArrayList<Long>(EntityHelper.toIdsAsList(fields));
        return this.memberCustomFieldService.getFieldVOs(customFieldIds);
    }

    private MemberCustomField load(String name) {
        try {
            MemberCustomField field = (MemberCustomField)this.customFieldHelper.findByInternalName(this.memberCustomFieldService.list(), name);
            if (field == null) {
                throw new Exception();
            }
            return field;
        }
        catch (Exception e) {
            throw new EntityNotFoundException(MemberCustomField.class);
        }
    }
}

