/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.webservices.rest;

import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.PrincipalType;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomFieldValue;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.members.Contact;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.customization.MemberCustomFieldService;
import nl.strohalm.cyclos.services.elements.ContactService;
import nl.strohalm.cyclos.services.elements.ElementService;
import nl.strohalm.cyclos.services.elements.MemberService;
import nl.strohalm.cyclos.utils.CustomFieldHelper;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import nl.strohalm.cyclos.webservices.WebServiceContext;
import nl.strohalm.cyclos.webservices.members.FullTextMemberSearchParameters;
import nl.strohalm.cyclos.webservices.members.MemberResultPage;
import nl.strohalm.cyclos.webservices.model.MemberDataVO;
import nl.strohalm.cyclos.webservices.model.MemberVO;
import nl.strohalm.cyclos.webservices.model.MyProfileVO;
import nl.strohalm.cyclos.webservices.model.RegistrationFieldValueVO;
import nl.strohalm.cyclos.webservices.rest.BaseRestController;
import nl.strohalm.cyclos.webservices.rest.MemberFieldsRestController;
import org.apache.commons.lang.StringUtils;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
public class MembersRestController
extends BaseRestController {
    private static final String CUSTOM_VALUE_PREFIX = "customValue.";
    private ElementService elementService;
    private MemberCustomFieldService memberCustomFieldService;
    private ContactService contactService;
    private MemberService memberService;
    private MemberFieldsRestController memberFieldsRestController;
    private CustomFieldHelper customFieldHelper;

    @RequestMapping(value={"members/memberData/{id}"})
    @ResponseBody
    public MemberDataVO getMemberData(@PathVariable Long id) {
        Member member = this.memberService.loadByIdOrPrincipal(id, null, null);
        MemberVO memberVO = this.memberService.getMemberVO(member, true, false);
        boolean canAddMemberAsContact = false;
        Contact contact = this.contactService.loadIfExists(LoggedUser.member(), member, new Relationship[0]);
        if (contact == null) {
            canAddMemberAsContact = true;
        }
        return new MemberDataVO(memberVO, canAddMemberAsContact);
    }

    @RequestMapping(value={"members/me"}, method={RequestMethod.GET})
    @ResponseBody
    public MyProfileVO getMyProfile() {
        Member member = (Member)LoggedUser.element();
        return this.memberService.getMyProfileVO(member);
    }

    @RequestMapping(value={"members/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public MemberVO loadById(@PathVariable Long id) {
        Member member;
        try {
            member = (Member)this.elementService.load(id, new Relationship[0]);
        }
        catch (Exception e) {
            throw new EntityNotFoundException(Member.class);
        }
        return this.memberService.getMemberVO(member, true, true);
    }

    @RequestMapping(value={"members/principal/{principal}"}, method={RequestMethod.GET})
    @ResponseBody
    public MemberVO loadByPrincipal(@PathVariable String principal) {
        Member member;
        try {
            PrincipalType principalType = WebServiceContext.getChannel().getDefaultPrincipalType();
            member = this.elementService.loadByPrincipal(principalType, principal, new Relationship[0]);
        }
        catch (Exception e) {
            throw new EntityNotFoundException(Member.class);
        }
        return this.memberService.getMemberVO(member, true, true);
    }

    @RequestMapping(value={"members"}, method={RequestMethod.GET})
    @ResponseBody
    public MemberResultPage search(FullTextMemberSearchParameters params, HttpServletRequest request) {
        params.setFields(this.memberFieldsRestController.requestParametersToFieldValues(request, CUSTOM_VALUE_PREFIX));
        return this.memberService.getMemberResultPage(params);
    }

    public void setContactService(ContactService contactService) {
        this.contactService = contactService;
    }

    public void setCustomFieldHelper(CustomFieldHelper customFieldHelper) {
        this.customFieldHelper = customFieldHelper;
    }

    public void setElementService(ElementService elementService) {
        this.elementService = elementService;
    }

    public void setMemberCustomFieldService(MemberCustomFieldService memberCustomFieldService) {
        this.memberCustomFieldService = memberCustomFieldService;
    }

    public void setMemberFieldsRestController(MemberFieldsRestController memberFieldsRestController) {
        this.memberFieldsRestController = memberFieldsRestController;
    }

    public void setMemberService(MemberService memberService) {
        this.memberService = memberService;
    }

    @RequestMapping(value={"members/me"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.OK)
    public void updateMyProfile(@RequestBody UpdateProfileParameters params) {
        if (params == null) {
            throw new ValidationException();
        }
        Member member = (Member)((Entity)LoggedUser.element()).clone();
        member.setUser((User)((Element)LoggedUser.element()).getUser().clone());
        if (StringUtils.isNotEmpty((String)params.getName())) {
            member.setName(params.getName());
        }
        if (StringUtils.isNotEmpty((String)params.getUsername())) {
            member.getUser().setUsername(params.getUsername());
        }
        if (StringUtils.isNotEmpty((String)params.getEmail())) {
            member.setEmail(params.getEmail());
        }
        List<RegistrationFieldValueVO> fieldValueVOs = params.getCustomValues();
        List<MemberCustomField> allowedFields = this.customFieldHelper.onlyForGroup(this.memberCustomFieldService.list(), member.getMemberGroup());
        Collection<MemberCustomFieldValue> newFieldValues = this.customFieldHelper.mergeFieldValues(member, fieldValueVOs, allowedFields);
        member.setCustomValues(newFieldValues);
        this.elementService.changeProfile(member);
    }

    public static class UpdateProfileParameters {
        private String name;
        private String username;
        private String email;
        private List<RegistrationFieldValueVO> customValues;

        public List<RegistrationFieldValueVO> getCustomValues() {
            return this.customValues;
        }

        public String getEmail() {
            return this.email;
        }

        public String getName() {
            return this.name;
        }

        public String getUsername() {
            return this.username;
        }

        public void setCustomValues(List<RegistrationFieldValueVO> customValues) {
            this.customValues = customValues;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setUsername(String username) {
            this.username = username;
        }
    }
}

