/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.webservices.rest;

import java.util.ArrayList;
import java.util.List;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.accounts.MemberAccount;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomField;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.services.accounts.AccountService;
import nl.strohalm.cyclos.services.customization.PaymentCustomFieldService;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeService;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.webservices.model.FieldVO;
import nl.strohalm.cyclos.webservices.model.PossibleValueVO;
import nl.strohalm.cyclos.webservices.rest.BaseFieldsRestController;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class PaymentFieldsRestController
extends BaseFieldsRestController<PaymentCustomField> {
    private AccountService accountService;
    private TransferTypeService transferTypeService;
    private PaymentCustomFieldService paymentCustomFieldService;

    @RequestMapping(value={"paymentFields/byTransferType/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public List<FieldVO> listByTransferTypeId(@PathVariable Long id) {
        TransferType transferType;
        try {
            transferType = this.transferTypeService.load(id, new Relationship[0]);
        }
        catch (Exception e) {
            throw new EntityNotFoundException(TransferType.class);
        }
        List<PaymentCustomField> fields = this.paymentCustomFieldService.list(transferType, false);
        ArrayList<Long> customFieldIds = new ArrayList<Long>(EntityHelper.toIdsAsList(fields));
        return this.paymentCustomFieldService.getFieldVOs(customFieldIds);
    }

    @RequestMapping(value={"paymentFields/forList/{accountId}"}, method={RequestMethod.GET})
    @ResponseBody
    public List<FieldVO> listForList(@PathVariable Long accountId) {
        MemberAccount account = this.loadAccount(accountId);
        List<PaymentCustomField> fields = this.paymentCustomFieldService.listForList(account, false);
        ArrayList<Long> customFieldIds = new ArrayList<Long>(EntityHelper.toIdsAsList(fields));
        return this.paymentCustomFieldService.getFieldVOs(customFieldIds);
    }

    @RequestMapping(value={"paymentFields/forList/default"}, method={RequestMethod.GET})
    @ResponseBody
    public List<FieldVO> listForListOnDefaultAccount() {
        MemberAccount account = this.accountService.getDefaultAccount();
        List<PaymentCustomField> fields = this.paymentCustomFieldService.listForList(account, false);
        ArrayList<Long> customFieldIds = new ArrayList<Long>(EntityHelper.toIdsAsList(fields));
        return this.paymentCustomFieldService.getFieldVOs(customFieldIds);
    }

    @RequestMapping(value={"paymentFields/forSearch/{accountId}"}, method={RequestMethod.GET})
    @ResponseBody
    public List<FieldVO> listForSearch(@PathVariable Long accountId) {
        MemberAccount account = this.loadAccount(accountId);
        List<PaymentCustomField> fields = this.paymentCustomFieldService.listForSearch(account, false);
        ArrayList<Long> customFieldIds = new ArrayList<Long>(EntityHelper.toIdsAsList(fields));
        return this.paymentCustomFieldService.getFieldVOs(customFieldIds);
    }

    @RequestMapping(value={"paymentFields/forSearch/default"}, method={RequestMethod.GET})
    @ResponseBody
    public List<FieldVO> listForSearchOnDefaultAccount() {
        MemberAccount account = this.accountService.getDefaultAccount();
        List<PaymentCustomField> fields = this.paymentCustomFieldService.listForSearch(account, false);
        ArrayList<Long> customFieldIds = new ArrayList<Long>(EntityHelper.toIdsAsList(fields));
        return this.paymentCustomFieldService.getFieldVOs(customFieldIds);
    }

    @RequestMapping(value={"paymentFields/{id}/possibleValues"}, method={RequestMethod.GET})
    @ResponseBody
    public List<PossibleValueVO> listPossibleValues(@PathVariable Long id) {
        return this.paymentCustomFieldService.getPossibleValueVOs(id, null);
    }

    @RequestMapping(value={"paymentFields/name/{name}/possibleValues"}, method={RequestMethod.GET})
    @ResponseBody
    public List<PossibleValueVO> listPossibleValuesByInternalName(@PathVariable String name) {
        PaymentCustomField field = this.load(name);
        return this.paymentCustomFieldService.getPossibleValueVOs(field.getId(), null);
    }

    @RequestMapping(value={"paymentFields/name/{name}/possibleValues/{parentValueId}"}, method={RequestMethod.GET})
    @ResponseBody
    public List<PossibleValueVO> listPossibleValuesByInternalNameAndParent(@PathVariable String name, @PathVariable Long parentValueId) {
        PaymentCustomField field = this.load(name);
        return this.paymentCustomFieldService.getPossibleValueVOs(field.getId(), parentValueId);
    }

    @RequestMapping(value={"paymentFields/{fieldId}/possibleValues/{parentValueId}"}, method={RequestMethod.GET})
    @ResponseBody
    public List<PossibleValueVO> listPossibleValuesByParent(@PathVariable Long fieldId, @PathVariable Long parentValueId) {
        return this.paymentCustomFieldService.getPossibleValueVOs(fieldId, parentValueId);
    }

    @RequestMapping(value={"paymentFields/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public FieldVO loadById(@PathVariable Long id) {
        return this.paymentCustomFieldService.getFieldVO(id);
    }

    @RequestMapping(value={"paymentFields/name/{name}"}, method={RequestMethod.GET})
    @ResponseBody
    public FieldVO loadByInternalName(@PathVariable String name) {
        PaymentCustomField paymentField = this.load(name);
        return this.paymentCustomFieldService.getFieldVO(paymentField.getId());
    }

    public void setAccountService(AccountService accountService) {
        this.accountService = accountService;
    }

    public void setPaymentCustomFieldService(PaymentCustomFieldService paymentCustomFieldService) {
        this.paymentCustomFieldService = paymentCustomFieldService;
    }

    public void setTransferTypeService(TransferTypeService transferTypeService) {
        this.transferTypeService = transferTypeService;
    }

    private PaymentCustomField load(String name) {
        return this.paymentCustomFieldService.loadByInternalName(name, new Relationship[0]);
    }

    private MemberAccount loadAccount(Long accountId) {
        MemberAccount account;
        try {
            account = (MemberAccount)this.accountService.load(accountId, new Relationship[0]);
        }
        catch (Exception e) {
            throw new EntityNotFoundException(Account.class);
        }
        return account;
    }
}

