/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.webservices.rest;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.accounts.MemberAccountType;
import nl.strohalm.cyclos.entities.accounts.SystemAccountOwner;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferTypeQuery;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomField;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomFieldValue;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.access.AccessService;
import nl.strohalm.cyclos.services.access.exceptions.BlockedCredentialsException;
import nl.strohalm.cyclos.services.access.exceptions.InvalidCredentialsException;
import nl.strohalm.cyclos.services.accounts.AccountDTO;
import nl.strohalm.cyclos.services.accounts.AccountService;
import nl.strohalm.cyclos.services.accounts.AccountTypeService;
import nl.strohalm.cyclos.services.customization.PaymentCustomFieldService;
import nl.strohalm.cyclos.services.elements.ElementService;
import nl.strohalm.cyclos.services.elements.MemberService;
import nl.strohalm.cyclos.services.settings.SettingsService;
import nl.strohalm.cyclos.services.transactions.DoPaymentDTO;
import nl.strohalm.cyclos.services.transactions.PaymentService;
import nl.strohalm.cyclos.services.transactions.TransactionContext;
import nl.strohalm.cyclos.services.transactions.exceptions.MaxAmountPerDayExceededException;
import nl.strohalm.cyclos.services.transactions.exceptions.NotEnoughCreditsException;
import nl.strohalm.cyclos.services.transactions.exceptions.PaymentException;
import nl.strohalm.cyclos.services.transactions.exceptions.TransferMinimumPaymentException;
import nl.strohalm.cyclos.services.transactions.exceptions.UpperCreditLimitReachedException;
import nl.strohalm.cyclos.services.transfertypes.TransactionFeePreviewDTO;
import nl.strohalm.cyclos.services.transfertypes.TransactionFeeService;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeService;
import nl.strohalm.cyclos.utils.CustomFieldHelper;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import nl.strohalm.cyclos.webservices.model.AccountStatusVO;
import nl.strohalm.cyclos.webservices.model.DetailedTransferTypeVO;
import nl.strohalm.cyclos.webservices.model.FieldValueVO;
import nl.strohalm.cyclos.webservices.model.MemberVO;
import nl.strohalm.cyclos.webservices.model.PaymentDataVO;
import nl.strohalm.cyclos.webservices.model.ServerErrorVO;
import nl.strohalm.cyclos.webservices.model.TransactionFeeVO;
import nl.strohalm.cyclos.webservices.model.TransferTypeVO;
import nl.strohalm.cyclos.webservices.rest.AccessRestController;
import nl.strohalm.cyclos.webservices.rest.AccountsRestController;
import nl.strohalm.cyclos.webservices.rest.BaseRestController;
import nl.strohalm.cyclos.webservices.rest.TransferTypesRestController;
import org.apache.commons.lang.StringUtils;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
public class PaymentsRestController
extends BaseRestController {
    private static final String BLOCKED_TRANSACTION_PASSWORD_ERROR = "BLOCKED_TRANSACTION_PASSWORD";
    private static final String INVALID_TRANSACTION_PASSWORD_ERROR = "INVALID_TRANSACTION_PASSWORD";
    private static final String MISSING_TRANSACTION_PASSWORD_ERROR = "MISSING_TRANSACTION_PASSWORD";
    private static final String INACTIVE_TRANSACTION_PASSWORD_ERROR = "INACTIVE_TRANSACTION_PASSWORD";
    private static final String NO_POSSIBLE_TRANSFER_TYPES_ERROR = "NO_POSSIBLE_TRANSFER_TYPES";
    private static final String INVALID_AMOUNT_ERROR = "INVALID_AMOUNT";
    private static final String MAX_AMOUNT_PER_DAY_EXCEEDED = "MAX_AMOUNT_PER_DAY_EXCEEDED";
    private static final String NOT_ENOUGH_CREDITS = "NOT_ENOUGH_FUNDS";
    private static final String UPPER_CREDIT_LIMIT_REACHED = "UPPER_CREDIT_LIMIT_REACHED";
    protected static final String TRANSFER_MINIMUM_PAYMENT = "TRANSFER_MINIMUM_PAYMENT";
    protected static final String UNKNOWN_PAYMENT_ERROR = "UNKNOWN_PAYMENT_ERROR";
    private PaymentService paymentService;
    private TransferTypeService transferTypeService;
    private AccountTypeService accountTypeService;
    private AccountService accountService;
    private AccessService accessService;
    private ElementService elementService;
    private TransactionFeeService transactionFeeService;
    private SettingsService settingsService;
    private MemberService memberService;
    private CustomFieldHelper customFieldHelper;
    private PaymentCustomFieldService paymentCustomFieldService;
    private TransferTypesRestController transferTypesRestController;
    private AccessRestController accessRestController;
    private AccountsRestController accountsRestController;

    @RequestMapping(value={"payments/confirmMemberPayment"}, method={RequestMethod.POST})
    @ResponseBody
    public ConfirmPaymentResult confirmPaymentToMember(@RequestBody DoMemberPaymentParameters params) {
        if (params == null) {
            throw new ValidationException();
        }
        Member toMember = this.memberService.loadByIdOrPrincipal(params.getToMemberId(), null, params.getToMemberPrincipal());
        if (toMember == null) {
            throw new EntityNotFoundException(Member.class);
        }
        return this.confirmPayment(params, toMember);
    }

    @RequestMapping(value={"payments/confirmSystemPayment"}, method={RequestMethod.POST})
    @ResponseBody
    public ConfirmPaymentResult confirmPaymentToSystem(@RequestBody DoPaymentParameters params) {
        return this.confirmPayment(params, SystemAccountOwner.instance());
    }

    @RequestMapping(value={"payments/memberPayment"}, method={RequestMethod.POST})
    @ResponseBody
    public DoPaymentResult doPaymentToMember(@RequestBody DoMemberPaymentParameters params) {
        Member to = this.memberService.loadByIdOrPrincipal(params.getToMemberId(), null, params.getToMemberPrincipal());
        if (to == null) {
            throw new EntityNotFoundException(Member.class);
        }
        return this.doPayment(params, to);
    }

    @RequestMapping(value={"payments/systemPayment"}, method={RequestMethod.POST})
    @ResponseBody
    public DoPaymentResult doPaymentToSystem(@RequestBody DoPaymentParameters params) {
        return this.doPayment(params, SystemAccountOwner.instance());
    }

    @RequestMapping(value={"payments/paymentData"}, method={RequestMethod.GET})
    @ResponseBody
    public PaymentDataVO getPaymentData(TransferTypesRestController.TransferTypeSearchParams params) {
        PaymentDataVO paymentData = new PaymentDataVO();
        TransferTypeQuery query = this.transferTypesRestController.toTransferTypeQuery(params);
        List<TransferType> transferTypes = this.transferTypeService.search(query);
        ArrayList<DetailedTransferTypeVO> transferTypeVOs = new ArrayList<DetailedTransferTypeVO>();
        for (TransferType transferType : transferTypes) {
            transferTypeVOs.add((DetailedTransferTypeVO)this.transferTypeService.getTransferTypeVO(transferType.getId(), true));
        }
        paymentData.setTransferTypes(transferTypeVOs);
        HashMap<Long, AccountStatusVO> statuses = new HashMap<Long, AccountStatusVO>();
        for (TransferType tt : transferTypes) {
            if (statuses.get(tt.getFrom().getId()) != null) continue;
            AccountDTO accountDTO = new AccountDTO(LoggedUser.member(), tt.getFrom());
            statuses.put(tt.getFrom().getId(), this.accountService.getCurrentAccountStatusVO(accountDTO));
        }
        paymentData.setAccountsStatus(statuses);
        if (params.getDestination() == TransferTypesRestController.Destination.MEMBER) {
            Member toMember = null;
            if (params.getToMemberId() != null) {
                toMember = (Member)this.elementService.load(params.getToMemberId(), new Relationship[0]);
            } else if (params.getToMemberPrincipal() != null) {
                toMember = this.elementService.loadByPrincipal(null, params.getToMemberPrincipal(), new Relationship[0]);
            }
            paymentData.setToMember(this.memberService.getMemberVO(toMember, false, false));
        }
        return paymentData;
    }

    @ExceptionHandler(value={PaymentException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.METHOD_FAILURE)
    public ServerErrorVO handlePaymentException(PaymentException ex) {
        String errorCode = UNKNOWN_PAYMENT_ERROR;
        if (ex instanceof MaxAmountPerDayExceededException) {
            errorCode = MAX_AMOUNT_PER_DAY_EXCEEDED;
        } else if (ex instanceof NotEnoughCreditsException) {
            errorCode = NOT_ENOUGH_CREDITS;
        } else if (ex instanceof TransferMinimumPaymentException) {
            errorCode = TRANSFER_MINIMUM_PAYMENT;
        } else if (ex instanceof UpperCreditLimitReachedException) {
            errorCode = UPPER_CREDIT_LIMIT_REACHED;
        }
        return new ServerErrorVO(errorCode, null);
    }

    public void setAccessRestController(AccessRestController accessRestController) {
        this.accessRestController = accessRestController;
    }

    public void setAccessService(AccessService accessService) {
        this.accessService = accessService;
    }

    public void setAccountService(AccountService accountService) {
        this.accountService = accountService;
    }

    public void setAccountsRestController(AccountsRestController accountsRestController) {
        this.accountsRestController = accountsRestController;
    }

    public void setAccountTypeService(AccountTypeService accountTypeService) {
        this.accountTypeService = accountTypeService;
    }

    public void setCustomFieldHelper(CustomFieldHelper customFieldHelper) {
        this.customFieldHelper = customFieldHelper;
    }

    public void setElementService(ElementService elementService) {
        this.elementService = elementService;
    }

    public void setMemberService(MemberService memberService) {
        this.memberService = memberService;
    }

    public void setPaymentCustomFieldService(PaymentCustomFieldService paymentCustomFieldService) {
        this.paymentCustomFieldService = paymentCustomFieldService;
    }

    public void setPaymentService(PaymentService paymentService) {
        this.paymentService = paymentService;
    }

    public void setSettingsService(SettingsService settingsService) {
        this.settingsService = settingsService;
    }

    public void setTransactionFeeService(TransactionFeeService transactionFeeService) {
        this.transactionFeeService = transactionFeeService;
    }

    public void setTransferTypeService(TransferTypeService transferTypeService) {
        this.transferTypeService = transferTypeService;
    }

    public void setTransferTypesRestController(TransferTypesRestController transferTypesRestController) {
        this.transferTypesRestController = transferTypesRestController;
    }

    private DoPaymentDTO buildDoPaymentDTO(DoPaymentParameters params, AccountOwner toOwner, TransferType transferType) {
        DoPaymentDTO dto = new DoPaymentDTO();
        dto.setContext(TransactionContext.PAYMENT);
        dto.setChannel("rest");
        dto.setAmount(params.getAmount());
        dto.setCurrency(null);
        dto.setTo(toOwner);
        dto.setTransferType(transferType);
        dto.setDescription(params.getDescription());
        List<PaymentCustomField> allowedFields = this.paymentCustomFieldService.list(transferType, true);
        Collection<PaymentCustomFieldValue> customValues = this.customFieldHelper.toValueCollection(allowedFields, params.getCustomValues());
        dto.setCustomValues(customValues);
        return dto;
    }

    private ConfirmPaymentResult confirmPayment(DoPaymentParameters params, AccountOwner toOwner) {
        if (params == null) {
            throw new ValidationException();
        }
        Member loggedMember = LoggedUser.member();
        BigDecimal amount = params.getAmount();
        if (amount == null) {
            throw new IllegalArgumentException(INVALID_AMOUNT_ERROR);
        }
        TransferType transferType = this.resolveTransferType(params, toOwner);
        if (this.accessRestController.isRequireTransactionPassword()) {
            String transactionPassword = params.getTransactionPassword();
            User.TransactionPasswordStatus status = loggedMember.getUser().getTransactionPasswordStatus();
            if (status == null || status == User.TransactionPasswordStatus.PENDING || status == User.TransactionPasswordStatus.NEVER_CREATED) {
                throw new IllegalArgumentException(INACTIVE_TRANSACTION_PASSWORD_ERROR);
            }
            if (StringUtils.isEmpty((String)transactionPassword)) {
                throw new IllegalArgumentException(MISSING_TRANSACTION_PASSWORD_ERROR);
            }
            try {
                this.accessService.checkTransactionPassword(transactionPassword);
            }
            catch (InvalidCredentialsException e) {
                throw new IllegalArgumentException(INVALID_TRANSACTION_PASSWORD_ERROR);
            }
            catch (BlockedCredentialsException e) {
                throw new IllegalArgumentException(BLOCKED_TRANSACTION_PASSWORD_ERROR);
            }
        }
        DoPaymentDTO dto = this.buildDoPaymentDTO(params, toOwner, transferType);
        Payment payment = this.paymentService.doPayment(dto);
        ConfirmPaymentResult result = new ConfirmPaymentResult();
        result.setId(payment.getId());
        result.setPending(payment.getProcessDate() == null);
        return result;
    }

    private DoPaymentResult doPayment(DoPaymentParameters params, AccountOwner to) {
        DoPaymentResult result = new DoPaymentResult();
        if (params == null) {
            throw new ValidationException();
        }
        AccountOwner from = LoggedUser.accountOwner();
        TransferType transferType = this.resolveTransferType(params, to);
        transferType = this.transferTypeService.load(transferType.getId(), RelationshipHelper.nested(TransferType.Relationships.FROM, AccountType.Relationships.CURRENCY), TransferType.Relationships.TO);
        DoPaymentDTO doPaymentDTO = this.buildDoPaymentDTO(params, to, transferType);
        this.paymentService.validate(doPaymentDTO);
        result.setTransferType(this.transferTypeService.getTransferTypeVO(transferType.getId(), false));
        boolean wouldRequireAuthorization = this.paymentService.wouldRequireAuthorization(transferType, params.getAmount(), LoggedUser.accountOwner());
        result.setWouldRequireAuthorization(wouldRequireAuthorization);
        result.setFrom(this.memberService.getMemberVO((Member)from, false, false));
        if (to != null && to instanceof Member) {
            result.setTo(this.memberService.getMemberVO((Member)to, false, false));
        }
        TransactionFeePreviewDTO preview = this.transactionFeeService.preview(from, to, transferType, params.getAmount());
        result.setFinalAmount(preview.getFinalAmount());
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        String formattedAmount = localSettings.getUnitsConverter(transferType.getCurrency().getPattern()).toString(preview.getFinalAmount());
        result.setFees(this.transactionFeeService.getTransactionFeeVOs(preview));
        result.setFormattedFinalAmount(formattedAmount);
        if (doPaymentDTO.getCustomValues() != null) {
            LinkedHashMap<String, String> customValues = new LinkedHashMap<String, String>();
            for (PaymentCustomFieldValue cfv : doPaymentDTO.getCustomValues()) {
                customValues.put(cfv.getField().getName(), cfv.getValue());
            }
            result.setCustomValues(customValues);
        }
        return result;
    }

    private TransferType resolveTransferType(DoPaymentParameters params, AccountOwner toOwner) {
        Member loggedMember = LoggedUser.member();
        Currency currency = this.accountsRestController.loadCurrencyByIdOrSymbol(params.getCurrencyId(), params.getCurrencySymbol());
        TransferTypeQuery query = new TransferTypeQuery();
        query.setResultType(QueryParameters.ResultType.LIST);
        query.setContext(loggedMember.equals(toOwner) ? TransactionContext.SELF_PAYMENT : TransactionContext.PAYMENT);
        query.setChannel("rest");
        query.setFromOwner(loggedMember);
        query.setToOwner(toOwner);
        query.setCurrency(currency);
        List<TransferType> possibleTransferTypes = this.transferTypeService.search(query);
        if (possibleTransferTypes.isEmpty()) {
            throw new IllegalArgumentException(NO_POSSIBLE_TRANSFER_TYPES_ERROR);
        }
        Long transferTypeId = params.getTransferTypeId();
        TransferType transferType = null;
        if (transferTypeId != null) {
            for (TransferType tt : possibleTransferTypes) {
                if (!tt.getId().equals(transferTypeId)) continue;
                transferType = tt;
                break;
            }
        } else {
            if (possibleTransferTypes.size() > 1) {
                MemberAccountType defaultType = this.accountTypeService.getDefault(loggedMember.getMemberGroup(), new Relationship[0]);
                for (TransferType current : possibleTransferTypes) {
                    if (!current.getFrom().equals(defaultType)) continue;
                    transferType = current;
                    break;
                }
            }
            if (transferType == null) {
                TransferType transferType2 = transferType = possibleTransferTypes.isEmpty() ? null : possibleTransferTypes.get(0);
            }
        }
        if (transferType == null) {
            throw new EntityNotFoundException(TransferType.class);
        }
        return transferType;
    }

    public static class DoPaymentResult {
        private boolean wouldRequireAuthorization;
        private MemberVO from;
        private MemberVO to;
        private BigDecimal finalAmount;
        private String formattedFinalAmount;
        private List<TransactionFeeVO> fees;
        private TransferTypeVO transferType;
        private Map<String, String> customValues;

        public Map<String, String> getCustomValues() {
            return this.customValues;
        }

        public List<TransactionFeeVO> getFees() {
            return this.fees;
        }

        public BigDecimal getFinalAmount() {
            return this.finalAmount;
        }

        public String getFormattedFinalAmount() {
            return this.formattedFinalAmount;
        }

        public MemberVO getFrom() {
            return this.from;
        }

        public MemberVO getTo() {
            return this.to;
        }

        public TransferTypeVO getTransferType() {
            return this.transferType;
        }

        public boolean isWouldRequireAuthorization() {
            return this.wouldRequireAuthorization;
        }

        public void setCustomValues(Map<String, String> customValues) {
            this.customValues = customValues;
        }

        public void setFees(List<TransactionFeeVO> fees) {
            this.fees = fees;
        }

        public void setFinalAmount(BigDecimal finalAmount) {
            this.finalAmount = finalAmount;
        }

        public void setFormattedFinalAmount(String formattedFinalAmount) {
            this.formattedFinalAmount = formattedFinalAmount;
        }

        public void setFrom(MemberVO from) {
            this.from = from;
        }

        public void setTo(MemberVO to) {
            this.to = to;
        }

        public void setTransferType(TransferTypeVO transferType) {
            this.transferType = transferType;
        }

        public void setWouldRequireAuthorization(boolean wouldRequireAuthorization) {
            this.wouldRequireAuthorization = wouldRequireAuthorization;
        }
    }

    public static class DoPaymentParameters {
        private Long currencyId;
        private String currencySymbol;
        private Long transferTypeId;
        private BigDecimal amount;
        private String description;
        private String transactionPassword;
        private List<FieldValueVO> customValues;

        public BigDecimal getAmount() {
            return this.amount;
        }

        public Long getCurrencyId() {
            return this.currencyId;
        }

        public String getCurrencySymbol() {
            return this.currencySymbol;
        }

        public List<FieldValueVO> getCustomValues() {
            return this.customValues;
        }

        public String getDescription() {
            return this.description;
        }

        public String getTransactionPassword() {
            return this.transactionPassword;
        }

        public Long getTransferTypeId() {
            return this.transferTypeId;
        }

        public void setAmount(BigDecimal amount) {
            this.amount = amount;
        }

        public void setCurrencyId(Long currencyId) {
            this.currencyId = currencyId;
        }

        public void setCurrencySymbol(String currencySymbol) {
            this.currencySymbol = currencySymbol;
        }

        public void setCustomValues(List<FieldValueVO> customValues) {
            this.customValues = customValues;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setTransactionPassword(String transactionPassword) {
            this.transactionPassword = transactionPassword;
        }

        public void setTransferTypeId(Long transferTypeId) {
            this.transferTypeId = transferTypeId;
        }

        public String toString() {
            return "DoPaymentParameters [currencyId=" + this.currencyId + ", currencySymbol=" + this.currencySymbol + ", transferTypeId=" + this.transferTypeId + ", amount=" + this.amount + ", description=" + this.description + ", transactionPassword=" + this.transactionPassword + ", customValues=" + this.customValues + "]";
        }
    }

    public static class DoMemberPaymentParameters
    extends DoPaymentParameters {
        private Long toMemberId;
        private String toMemberPrincipal;
        private Integer installments = 0;
        private Calendar firstInstallmentDate;

        public Calendar getFirstInstallmentDate() {
            return this.firstInstallmentDate;
        }

        public int getInstallments() {
            return this.installments;
        }

        public Long getToMemberId() {
            return this.toMemberId;
        }

        public String getToMemberPrincipal() {
            return this.toMemberPrincipal;
        }

        public void setFirstInstallmentDate(Calendar firstInstallmentDate) {
            this.firstInstallmentDate = firstInstallmentDate;
        }

        public void setInstallments(int installments) {
            this.installments = installments;
        }

        public void setToMemberId(Long toMemberId) {
            this.toMemberId = toMemberId;
        }

        public void setToMemberPrincipal(String toMemberPrincipal) {
            this.toMemberPrincipal = toMemberPrincipal;
        }
    }

    public static class ConfirmPaymentResult {
        private Long id;
        private boolean pending;

        public Long getId() {
            return this.id;
        }

        public boolean isPending() {
            return this.pending;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public void setPending(boolean pending) {
            this.pending = pending;
        }
    }
}

