/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.webservices.rest;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.access.PrincipalType;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.access.AccessServiceLocal;
import nl.strohalm.cyclos.services.access.ChannelServiceLocal;
import nl.strohalm.cyclos.services.access.exceptions.BlockedCredentialsException;
import nl.strohalm.cyclos.services.access.exceptions.CredentialsException;
import nl.strohalm.cyclos.services.access.exceptions.InvalidCredentialsException;
import nl.strohalm.cyclos.services.access.exceptions.UserNotFoundException;
import nl.strohalm.cyclos.services.elements.ElementServiceLocal;
import nl.strohalm.cyclos.services.transactions.exceptions.InvalidChannelException;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.webservices.WebServiceContext;
import nl.strohalm.cyclos.webservices.model.ServerErrorVO;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class RestAuthenticationProvider
implements AuthenticationProvider {
    private ElementServiceLocal elementService;
    private AccessServiceLocal accessService;
    private ChannelServiceLocal channelService;
    private static final String INVALID_CREDENTIALS = "INVALID_CREDENTIALS";
    private static final String CHANNEL_DISABLED = "CHANNEL_DISABLED";
    private static final String BLOCKED_CREDENTIALS = "BLOCKED_CREDENTIALS";
    private static final String UNKNOWN_AUTHENTICATION_ERROR = "UNKNOWN_AUTHENTICATION_ERROR";

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        String principal = authentication.getName();
        String credentials = (String)authentication.getCredentials();
        if (StringUtils.isEmpty((String)principal) || StringUtils.isEmpty((String)credentials)) {
            this.sendError("Empty username / password", INVALID_CREDENTIALS);
            throw new InvalidCredentialsException();
        }
        HttpServletRequest request = WebServiceContext.getRequest();
        if (request == null) {
            this.sendError("Couldn't resolve the current request", UNKNOWN_AUTHENTICATION_ERROR);
            throw new IllegalStateException("Couldn't resolve the current request");
        }
        String remoteAddr = request.getRemoteAddr();
        Channel channel = this.channelService.loadByInternalName("rest");
        PrincipalType principalType = this.channelService.resolvePrincipalType("rest", channel.getDefaultPrincipalType().getPrincipal().name());
        String usernameToVerify = principal;
        Member member = null;
        try {
            member = this.elementService.loadByPrincipal(principalType, principal, Element.Relationships.USER, Element.Relationships.GROUP);
            usernameToVerify = member.getUsername();
        }
        catch (EntityNotFoundException e) {
            usernameToVerify = "";
        }
        try {
            this.accessService.verifyLogin(null, usernameToVerify, remoteAddr);
        }
        catch (UserNotFoundException e) {
            this.sendError("Invalid username / password", INVALID_CREDENTIALS);
            throw new InvalidCredentialsException();
        }
        if (!this.accessService.isChannelEnabledForMember(channel, member)) {
            this.sendError("Channel disabled for the member", CHANNEL_DISABLED);
            throw new InvalidChannelException(member.getUsername(), channel.getInternalName());
        }
        try {
            this.accessService.checkCredentials(channel, member.getMemberUser(), credentials, remoteAddr, null);
        }
        catch (BlockedCredentialsException e) {
            this.sendError("Credentials blocked", BLOCKED_CREDENTIALS);
            throw e;
        }
        catch (CredentialsException e) {
            this.sendError("Invalid username / password", INVALID_CREDENTIALS);
            throw e;
        }
        WebServiceContext.setRestMember(member);
        LoggedUser.init(member.getUser(), remoteAddr);
        Set<SimpleGrantedAuthority> authority = Collections.singleton(new SimpleGrantedAuthority("ROLE_REST"));
        return new UsernamePasswordAuthenticationToken((Object)principal, (Object)credentials, authority);
    }

    public void setAccessServiceLocal(AccessServiceLocal accessService) {
        this.accessService = accessService;
    }

    public void setChannelServiceLocal(ChannelServiceLocal channelService) {
        this.channelService = channelService;
    }

    public void setElementServiceLocal(ElementServiceLocal elementService) {
        this.elementService = elementService;
    }

    public boolean supports(Class<?> authentication) {
        return UsernamePasswordAuthenticationToken.class.isAssignableFrom(authentication);
    }

    private void sendError(String message, String errorCode) {
        HttpServletResponse response = WebServiceContext.getResponse();
        ObjectMapper mapper = new ObjectMapper();
        try {
            response.setContentType("application/json");
            response.setStatus(400);
            mapper.writeValue((Writer)response.getWriter(), (Object)new ServerErrorVO(errorCode, message));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

