/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.webservices.rest;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.cxf.common.util.StringUtils;
import org.springframework.core.convert.converter.Converter;
import org.springframework.format.FormatterRegistrar;
import org.springframework.format.FormatterRegistry;

public class RestFormatterRegistrar
implements FormatterRegistrar {
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final int DATE_FORMAT_LENGTH = "yyyy-MM-dd".length();
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm";
    private static final int DATE_TIME_FORMAT_LENGTH = "yyyy-MM-dd'T'HH:mm".length() - 2;
    private static final String DATE_TIME_SEC_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    private static final int DATE_TIME_SEC_FORMAT_LENGTH = "yyyy-MM-dd'T'HH:mm:ss".length() - 2;
    private static final String FULL_DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";

    public static void main(String[] args) throws ParseException {
        String text = "2001-11-27";
        Date date = RestFormatterRegistrar.parse(text);
        System.out.println(date);
    }

    private static Date parse(String text) {
        try {
            int length = text.length();
            String format = length == DATE_FORMAT_LENGTH ? DATE_FORMAT : (length == DATE_TIME_FORMAT_LENGTH ? DATE_TIME_FORMAT : (length == DATE_TIME_SEC_FORMAT_LENGTH ? DATE_TIME_SEC_FORMAT : FULL_DATE_TIME_FORMAT));
            SimpleDateFormat fmt = new SimpleDateFormat(format);
            Date date = fmt.parse(text);
            return date;
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Cannot convert '" + text + "' to date", e);
        }
    }

    public void registerFormatters(FormatterRegistry registry) {
        registry.addConverter((Converter)new Converter<String, Calendar>(){

            public Calendar convert(String source) {
                if (StringUtils.isEmpty((String)source)) {
                    return null;
                }
                Date date = RestFormatterRegistrar.parse(source);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                return calendar;
            }
        });
        registry.addConverter((Converter)new Converter<String, Date>(){

            public Date convert(String source) {
                if (StringUtils.isEmpty((String)source)) {
                    return null;
                }
                return RestFormatterRegistrar.parse(source);
            }
        });
    }
}

