/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.webservices.rest;

import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.access.MemberUser;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.utils.Pair;
import nl.strohalm.cyclos.utils.StringHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import nl.strohalm.cyclos.webservices.model.ServerErrorVO;
import org.apache.commons.lang.StringUtils;

public class RestHelper {
    public static final String NOT_FOUND_ERROR = "NOT_FOUND";
    public static final String INVALID_ARGUMENT_ERROR = "INVALID_ARGUMENT";
    public static final String PERMISSION_DENIED_ERROR = "PERMISSION_DENIED";
    public static final String INTERNAL_SERVER_ERROR = "INTERNAL_SERVER_ERROR";

    public static Pair<ServerErrorVO, Integer> resolveError(Throwable t) {
        if (t instanceof EntityNotFoundException) {
            return Pair.of(RestHelper.handleEntityNotFound((EntityNotFoundException)t), 404);
        }
        if (t instanceof IllegalArgumentException) {
            return Pair.of(RestHelper.handleIllegalArgumentException((IllegalArgumentException)t), 400);
        }
        if (t instanceof ValidationException) {
            return Pair.of(RestHelper.handleValidationException((ValidationException)t), 400);
        }
        if (t instanceof PermissionDeniedException) {
            return Pair.of(RestHelper.handlePermissionDenied(), 403);
        }
        return Pair.of(RestHelper.handleUnknownException(), 500);
    }

    private static ServerErrorVO handleEntityNotFound(EntityNotFoundException ex) {
        Class<? extends Entity> entityType = ex.getEntityType();
        String entityName = entityType == null ? "Entity" : (entityType.equals(Member.class) || entityType.equals(Element.class) || entityType.equals(User.class) || entityType.equals(MemberUser.class) ? "Member" : entityType.getSimpleName());
        return new ServerErrorVO(NOT_FOUND_ERROR, StringHelper.upcase(entityName));
    }

    private static ServerErrorVO handleIllegalArgumentException(IllegalArgumentException ex) {
        return new ServerErrorVO(INVALID_ARGUMENT_ERROR, StringUtils.trimToNull((String)ex.getMessage()));
    }

    private static ServerErrorVO handlePermissionDenied() {
        return new ServerErrorVO(PERMISSION_DENIED_ERROR, null);
    }

    private static ServerErrorVO handleUnknownException() {
        return new ServerErrorVO(INTERNAL_SERVER_ERROR, null);
    }

    private static ServerErrorVO handleValidationException(ValidationException ex) {
        return new ServerErrorVO(INVALID_ARGUMENT_ERROR, null);
    }
}

