/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.webservices.rest;

import java.util.ArrayList;
import java.util.List;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.SystemAccountOwner;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferTypeQuery;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.accounts.AccountService;
import nl.strohalm.cyclos.services.elements.MemberService;
import nl.strohalm.cyclos.services.transactions.TransactionContext;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeService;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.webservices.model.TransferTypeVO;
import nl.strohalm.cyclos.webservices.rest.AccountsRestController;
import nl.strohalm.cyclos.webservices.rest.BaseRestController;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class TransferTypesRestController
extends BaseRestController {
    private TransferTypeService transferTypeService;
    private AccountService accountService;
    private MemberService memberService;
    private AccountsRestController accountsRestController;

    @RequestMapping(value={"transferTypes"}, method={RequestMethod.GET})
    @ResponseBody
    public List<TransferTypeVO> listTransferTypes(TransferTypeSearchParams params) {
        TransferTypeQuery query = this.toTransferTypeQuery(params);
        List<TransferType> transferTypes = this.transferTypeService.search(query);
        ArrayList<TransferTypeVO> transferTypeVOs = new ArrayList<TransferTypeVO>(transferTypes.size());
        for (TransferType transferType : transferTypes) {
            transferTypeVOs.add(this.transferTypeService.getTransferTypeVO(transferType.getId(), false));
        }
        return transferTypeVOs;
    }

    @RequestMapping(value={"transferTypes/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public TransferTypeVO loadTransferType(@PathVariable Long id) {
        return this.transferTypeService.getTransferTypeVO(id, false);
    }

    public void setAccountService(AccountService accountService) {
        this.accountService = accountService;
    }

    public void setAccountsRestController(AccountsRestController accountsRestController) {
        this.accountsRestController = accountsRestController;
    }

    public void setMemberService(MemberService memberService) {
        this.memberService = memberService;
    }

    public void setTransferTypeService(TransferTypeService transferTypeService) {
        this.transferTypeService = transferTypeService;
    }

    public TransferTypeQuery toTransferTypeQuery(TransferTypeSearchParams params) {
        Destination destination = params.getDestination();
        if (destination == null) {
            destination = Destination.MEMBER;
        }
        Member loggedMember = LoggedUser.member();
        TransferTypeQuery query = new TransferTypeQuery();
        query.setChannel("rest");
        query.setContext(TransactionContext.PAYMENT);
        query.setFromOwner(loggedMember);
        query.setCurrency(this.accountsRestController.loadCurrencyByIdOrSymbol(params.getCurrencyId(), params.getCurrencySymbol()));
        switch (destination) {
            case MEMBER: {
                query.setToOwner(this.memberService.loadByIdOrPrincipal(params.getToMemberId(), null, params.getToMemberPrincipal()));
                query.setToNature(AccountType.Nature.MEMBER);
                break;
            }
            case SYSTEM: {
                query.setToOwner(SystemAccountOwner.instance());
                query.setToNature(AccountType.Nature.SYSTEM);
            }
        }
        if (params.getFromAccountId() != null && params.getFromAccountId() > 0L) {
            Object account = this.accountService.load(params.getFromAccountId(), new Relationship[0]);
            query.setToAccountType(((Account)account).getType());
        }
        return query;
    }

    public static class TransferTypeSearchParams {
        private Destination destination;
        private Long fromAccountId;
        private Long toMemberId;
        private String toMemberPrincipal;
        private Long currencyId;
        private String currencySymbol;

        public Long getCurrencyId() {
            return this.currencyId;
        }

        public String getCurrencySymbol() {
            return this.currencySymbol;
        }

        public Destination getDestination() {
            return this.destination;
        }

        public Long getFromAccountId() {
            return this.fromAccountId;
        }

        public Long getToMemberId() {
            return this.toMemberId;
        }

        public String getToMemberPrincipal() {
            return this.toMemberPrincipal;
        }

        public void setCurrencyId(Long currencyId) {
            this.currencyId = currencyId;
        }

        public void setCurrencySymbol(String currencySymbol) {
            this.currencySymbol = currencySymbol;
        }

        public void setDestination(Destination destination) {
            this.destination = destination;
        }

        public void setFromAccountId(Long fromAccountId) {
            this.fromAccountId = fromAccountId;
        }

        public void setToMemberId(Long toMemberId) {
            this.toMemberId = toMemberId;
        }

        public void setToMemberPrincipal(String toMemberPrincipal) {
            this.toMemberPrincipal = toMemberPrincipal;
        }
    }

    public static enum Destination {
        MEMBER,
        SYSTEM;

    }
}

