/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.webservices.sms;

import javax.jws.WebService;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.sms.SmsLog;
import nl.strohalm.cyclos.entities.sms.SmsType;
import nl.strohalm.cyclos.services.elements.MessageServiceLocal;
import nl.strohalm.cyclos.services.elements.SendSmsDTO;
import nl.strohalm.cyclos.services.infotexts.InfoTextServiceLocal;
import nl.strohalm.cyclos.services.sms.SmsLogServiceLocal;
import nl.strohalm.cyclos.webservices.WebServiceContext;
import nl.strohalm.cyclos.webservices.sms.SendSmsParameters;
import nl.strohalm.cyclos.webservices.sms.SendSmsResult;
import nl.strohalm.cyclos.webservices.sms.SendSmsStatus;
import nl.strohalm.cyclos.webservices.sms.SmsWebService;
import nl.strohalm.cyclos.webservices.utils.MemberHelper;
import nl.strohalm.cyclos.webservices.utils.WebServiceHelper;
import org.apache.commons.lang.StringUtils;

@WebService(name="sms", serviceName="sms")
public class SmsWebServiceImpl
implements SmsWebService {
    private MessageServiceLocal messageServiceLocal;
    private MemberHelper memberHelper;
    private WebServiceHelper webServiceHelper;
    private InfoTextServiceLocal infoTextServiceLocal;
    private SmsLogServiceLocal smsLogServiceLocal;

    @Override
    public SendSmsResult sendSms(SendSmsParameters params) {
        if (params == null || StringUtils.isEmpty((String)params.getText()) && !params.getInfoText()) {
            throw new IllegalArgumentException();
        }
        Member restrictedMember = WebServiceContext.getMember();
        SendSmsStatus status = null;
        Member target = null;
        try {
            target = this.memberHelper.loadByPrincipal(params.getTargetPrincipalType(), params.getTargetPrincipal(), new Relationship[0]);
            if (target == null || target.equals(restrictedMember)) {
                throw new Exception();
            }
            if (!this.memberHelper.isChannelEnabledForMember(target)) {
                status = SendSmsStatus.CHANNEL_DISABLED_FOR_TARGET;
            }
        }
        catch (Exception e) {
            this.webServiceHelper.error(e);
            status = SendSmsStatus.TARGET_NOT_FOUND;
        }
        Member charged = null;
        if (status == null) {
            if (restrictedMember != null) {
                charged = restrictedMember;
            } else {
                try {
                    charged = this.memberHelper.loadByPrincipal(params.getToChargePrincipalType(), params.getToChargePrincipal(), new Relationship[0]);
                    if (charged == null) {
                        charged = target;
                    } else if (!this.memberHelper.isChannelEnabledForMember(charged)) {
                        status = SendSmsStatus.CHANNEL_DISABLED_FOR_CHARGED;
                    }
                }
                catch (Exception e) {
                    this.webServiceHelper.error(e);
                    status = SendSmsStatus.CHARGED_NOT_FOUND;
                }
            }
        }
        String textToSend = params.getText();
        if (status == null && params.getInfoText() && (textToSend = this.infoTextServiceLocal.getInfoTextSubject(params.getText())) == null) {
            this.webServiceHelper.trace("Info text's subject null for alias '" + params.getText() + "'");
            status = SendSmsStatus.INFO_TEXT_NOT_FOUND;
        }
        SendSmsResult result = new SendSmsResult();
        if (status == null) {
            SendSmsDTO send = new SendSmsDTO();
            send.setTargetMember(target);
            send.setChargedMember(charged);
            send.setText(textToSend);
            send.setTraceData(params.getTraceData());
            send.setSmsTypeArgs(params.getSmsTypeArgs());
            try {
                send.setSmsType(this.smsLogServiceLocal.loadSmsTypeByCode(params.getSmsTypeCode()));
                SmsLog log = this.messageServiceLocal.sendSms(send);
                if (log == null) {
                    throw new IllegalStateException("No SMS log returned from MessageServiceLocal.sendSms()");
                }
                SmsLog.ErrorType errorType = log.getErrorType();
                result.setSmsId(log.getId());
                status = errorType != null ? (errorType == SmsLog.ErrorType.SEND_ERROR ? SendSmsStatus.SEND_ERROR : SendSmsStatus.CHARGE_COULD_NOT_BE_DONE) : SendSmsStatus.SUCCESS;
            }
            catch (EntityNotFoundException e) {
                this.webServiceHelper.error(e);
                status = e.getEntityType().equals(SmsType.class) ? SendSmsStatus.INVALID_SMS_TYPE_CODE : SendSmsStatus.INTERNAL_ERROR;
            }
            catch (Exception e) {
                this.webServiceHelper.error(e);
                status = SendSmsStatus.INTERNAL_ERROR;
            }
        }
        result.setStatus(status);
        return result;
    }

    public void setInfoTextServiceLocal(InfoTextServiceLocal infoTextService) {
        this.infoTextServiceLocal = infoTextService;
    }

    public void setMemberHelper(MemberHelper memberHelper) {
        this.memberHelper = memberHelper;
    }

    public void setMessageServiceLocal(MessageServiceLocal messageService) {
        this.messageServiceLocal = messageService;
    }

    public void setSmsLogServiceLocal(SmsLogServiceLocal smsLogService) {
        this.smsLogServiceLocal = smsLogService;
    }

    public void setWebServiceHelper(WebServiceHelper webServiceHelper) {
        this.webServiceHelper = webServiceHelper;
    }
}

