/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.webservices.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.AccountStatus;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.accounts.MemberAccount;
import nl.strohalm.cyclos.entities.accounts.MemberAccountType;
import nl.strohalm.cyclos.entities.accounts.MemberGroupAccountSettings;
import nl.strohalm.cyclos.entities.accounts.SystemAccountOwner;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentFilter;
import nl.strohalm.cyclos.entities.accounts.transactions.ScheduledPayment;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferQuery;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferTypeQuery;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomField;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomFieldValue;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.accounts.AccountDTO;
import nl.strohalm.cyclos.services.accounts.AccountServiceLocal;
import nl.strohalm.cyclos.services.accounts.AccountTypeServiceLocal;
import nl.strohalm.cyclos.services.customization.PaymentCustomFieldServiceLocal;
import nl.strohalm.cyclos.services.settings.SettingsServiceLocal;
import nl.strohalm.cyclos.services.transactions.TransactionContext;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeServiceLocal;
import nl.strohalm.cyclos.utils.CustomFieldHelper;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.conversion.CoercionHelper;
import nl.strohalm.cyclos.utils.conversion.Transformer;
import nl.strohalm.cyclos.utils.conversion.UnitsConverter;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import nl.strohalm.cyclos.webservices.WebServiceContext;
import nl.strohalm.cyclos.webservices.WebServiceFault;
import nl.strohalm.cyclos.webservices.WebServiceFaultsEnum;
import nl.strohalm.cyclos.webservices.accounts.AccountHistoryResultPage;
import nl.strohalm.cyclos.webservices.accounts.AccountHistorySearchParameters;
import nl.strohalm.cyclos.webservices.accounts.ScheduledPaymentsResultPage;
import nl.strohalm.cyclos.webservices.accounts.TransferTypeSearchParameters;
import nl.strohalm.cyclos.webservices.model.AccountHistoryTransferVO;
import nl.strohalm.cyclos.webservices.model.AccountStatusVO;
import nl.strohalm.cyclos.webservices.model.AccountTypeVO;
import nl.strohalm.cyclos.webservices.model.BasePaymentDataVO;
import nl.strohalm.cyclos.webservices.model.BasePaymentVO;
import nl.strohalm.cyclos.webservices.model.CurrencyVO;
import nl.strohalm.cyclos.webservices.model.DetailedAccountTypeVO;
import nl.strohalm.cyclos.webservices.model.DetailedTransferTypeVO;
import nl.strohalm.cyclos.webservices.model.FieldValueVO;
import nl.strohalm.cyclos.webservices.model.MemberAccountVO;
import nl.strohalm.cyclos.webservices.model.PaymentFilterVO;
import nl.strohalm.cyclos.webservices.model.PaymentStatusVO;
import nl.strohalm.cyclos.webservices.model.ScheduledPaymentInstallmentVO;
import nl.strohalm.cyclos.webservices.model.ScheduledPaymentVO;
import nl.strohalm.cyclos.webservices.model.TransferTypeVO;
import nl.strohalm.cyclos.webservices.utils.ChannelHelper;
import nl.strohalm.cyclos.webservices.utils.CurrencyHelper;
import nl.strohalm.cyclos.webservices.utils.FieldHelper;
import nl.strohalm.cyclos.webservices.utils.MemberHelper;
import nl.strohalm.cyclos.webservices.utils.QueryHelper;
import nl.strohalm.cyclos.webservices.utils.WebServiceHelper;

public class AccountHelper {
    private PaymentCustomFieldServiceLocal paymentCustomFieldService;
    private SettingsServiceLocal settingsService;
    private AccountServiceLocal accountService;
    private TransferTypeServiceLocal transferTypeService;
    private AccountTypeServiceLocal accountTypeService;
    private QueryHelper queryHelper;
    private MemberHelper memberHelper;
    private FieldHelper fieldHelper;
    private ChannelHelper channelHelper;
    private CurrencyHelper currencyHelper;
    private CustomFieldHelper customFieldHelper;

    public MemberAccount getDefaultAccount() {
        MemberGroup group;
        MemberAccountType defaultType;
        MemberAccount account = null;
        if (LoggedUser.hasUser() && (defaultType = this.accountTypeService.getDefault(group = (MemberGroup)LoggedUser.group(), new Relationship[0])) != null) {
            account = (MemberAccount)this.accountService.getAccount(new AccountDTO(LoggedUser.accountOwner(), defaultType), new Relationship[0]);
        }
        if (account == null) {
            throw new EntityNotFoundException(Account.class);
        }
        return account;
    }

    public void setAccountServiceLocal(AccountServiceLocal accountService) {
        this.accountService = accountService;
    }

    public void setAccountTypeServiceLocal(AccountTypeServiceLocal accountTypeService) {
        this.accountTypeService = accountTypeService;
    }

    public void setChannelHelper(ChannelHelper channelHelper) {
        this.channelHelper = channelHelper;
    }

    public void setCurrencyHelper(CurrencyHelper currencyHelper) {
        this.currencyHelper = currencyHelper;
    }

    public void setCustomFieldHelper(CustomFieldHelper customFieldHelper) {
        this.customFieldHelper = customFieldHelper;
    }

    public void setFieldHelper(FieldHelper fieldHelper) {
        this.fieldHelper = fieldHelper;
    }

    public void setMemberHelper(MemberHelper memberHelper) {
        this.memberHelper = memberHelper;
    }

    public void setPaymentCustomFieldServiceLocal(PaymentCustomFieldServiceLocal paymentCustomFieldService) {
        this.paymentCustomFieldService = paymentCustomFieldService;
    }

    public void setQueryHelper(QueryHelper queryHelper) {
        this.queryHelper = queryHelper;
    }

    public void setSettingsServiceLocal(SettingsServiceLocal settingsService) {
        this.settingsService = settingsService;
    }

    public void setTransferTypeServiceLocal(TransferTypeServiceLocal transferTypeService) {
        this.transferTypeService = transferTypeService;
    }

    public AccountHistoryResultPage toAccountHistoryResultPage(final AccountOwner owner, List<Transfer> transfers) {
        final HashMap customFieldsByTransferType = new HashMap();
        return this.queryHelper.toResultPage(AccountHistoryResultPage.class, transfers, new Transformer<Transfer, AccountHistoryTransferVO>(){

            @Override
            public AccountHistoryTransferVO transform(Transfer transfer) {
                TransferType transferType = transfer.getType();
                List<PaymentCustomField> customFields = (List<PaymentCustomField>)customFieldsByTransferType.get(transferType);
                if (customFields == null) {
                    customFields = AccountHelper.this.paymentCustomFieldService.list(transferType, true);
                    customFieldsByTransferType.put(transferType, customFields);
                }
                return AccountHelper.this.toVO(owner, transfer, customFields);
            }
        });
    }

    public List<DetailedTransferTypeVO> toDetailedTransferTypeVOs(List<TransferType> transferTypes) {
        ArrayList<DetailedTransferTypeVO> vos = new ArrayList<DetailedTransferTypeVO>(transferTypes.size());
        for (TransferType transferType : transferTypes) {
            vos.add(this.toDetailedVO(transferType));
        }
        return vos;
    }

    public DetailedAccountTypeVO toDetailedTypeVO(String channel, MemberAccount memberAccount) {
        if (memberAccount == null) {
            return null;
        }
        memberAccount = (MemberAccount)this.accountService.load(memberAccount.getId(), Account.Relationships.TYPE, RelationshipHelper.nested(MemberAccount.Relationships.MEMBER, Element.Relationships.GROUP, MemberGroup.Relationships.ACCOUNT_SETTINGS));
        AccountType type = memberAccount.getType();
        Member member = memberAccount.getOwner();
        MemberGroup memberGroup = member.getMemberGroup();
        boolean isDefault = this.isDefault(type, memberGroup);
        DetailedAccountTypeVO vo = new DetailedAccountTypeVO();
        vo.setId(type.getId());
        vo.setName(type.getName());
        vo.setDefault(isDefault);
        vo.setCurrency(this.toVO(type.getCurrency()));
        TransferTypeQuery query = new TransferTypeQuery();
        query.setChannel(channel);
        query.setContext(TransactionContext.PAYMENT);
        query.setFromOwner(member);
        query.setFromAccountType(type);
        ArrayList<TransferTypeVO> transferTypes = new ArrayList<TransferTypeVO>();
        for (TransferType tt : this.transferTypeService.search(query)) {
            transferTypes.add(this.toVO(tt));
        }
        vo.setTransferTypes(transferTypes);
        return vo;
    }

    public DetailedTransferTypeVO toDetailedVO(TransferType tt) {
        DetailedTransferTypeVO vo = new DetailedTransferTypeVO();
        if (tt == null) {
            return null;
        }
        this.assignFieldsToTranserTypeVO(tt, vo);
        TransferType t = new TransferType();
        t.setId(tt.getId());
        List<PaymentCustomField> fields = this.paymentCustomFieldService.list(t, false);
        vo.setCustomFields(this.fieldHelper.toFieldVOs(fields));
        return vo;
    }

    public List<PaymentFilterVO> toPaymentFilterVOs(Collection<PaymentFilter> paymentFilters) {
        ArrayList<PaymentFilterVO> result = new ArrayList<PaymentFilterVO>();
        if (paymentFilters != null) {
            for (PaymentFilter paymentFilter : paymentFilters) {
                result.add(this.toVO(paymentFilter));
            }
        }
        return result;
    }

    public TransferQuery toQuery(AccountHistorySearchParameters params, Member member) {
        Member ownerMember;
        if (params == null) {
            return null;
        }
        TransferQuery query = new TransferQuery();
        this.queryHelper.fill(params, query);
        query.setReverseOrder(params.getReverseOrder());
        AccountType accountType = CoercionHelper.coerce(AccountType.class, params.getAccountTypeId());
        if (accountType == null) {
            accountType = this.resolveAccountType(params, member);
        }
        query.setOwner((AccountOwner)((Object)((ownerMember = this.memberHelper.resolveMember(params.getPrincipalType(), params.getPrincipal())) == null ? SystemAccountOwner.instance() : ownerMember)));
        query.setMember(this.memberHelper.loadByPrincipal(params.getRelatedMemberPrincipalType(), params.getRelatedMember(), new Relationship[0]));
        Account account = this.accountService.getAccount(new AccountDTO(ownerMember, accountType), Account.Relationships.TYPE);
        query.setType(account.getType());
        List<FieldValueVO> fields = params.getFields();
        if (fields != null && fields.size() > 0) {
            List<PaymentCustomField> fieldsForSearch = this.paymentCustomFieldService.listForSearch(account, false);
            Collection<PaymentCustomFieldValue> customFields = this.customFieldHelper.toValueCollection(fieldsForSearch, fields);
            query.setCustomValues(customFields);
        }
        if (params.getBeginDate() != null || params.getEndDate() != null) {
            Period period = new Period(params.getBeginDate(), params.getEndDate());
            query.setPeriod(period);
        }
        return query;
    }

    public TransferTypeQuery toQuery(TransferTypeSearchParameters params) {
        if (params == null) {
            return null;
        }
        TransferTypeQuery query = new TransferTypeQuery();
        query.setResultType(QueryParameters.ResultType.LIST);
        query.setCurrency(this.currencyHelper.resolve(params.getCurrency()));
        query.setFromAccountType(CoercionHelper.coerce(AccountType.class, params.getFromAccountTypeId()));
        query.setToAccountType(CoercionHelper.coerce(AccountType.class, params.getToAccountTypeId()));
        query.setChannel(this.channelHelper.restricted());
        Member restrictedMember = WebServiceContext.getMember();
        if (restrictedMember != null) {
            if (params.getToMember() != null) {
                query.setToOwner(this.memberHelper.loadByPrincipal(params.getToMemberPrincipalType(), params.getToMember(), new Relationship[0]));
            } else if (params.getToSystem()) {
                query.setToOwner(SystemAccountOwner.instance());
            } else {
                query.setToOwner(restrictedMember);
            }
            if (params.getFromMember() != null) {
                Member member = this.memberHelper.loadByPrincipal(params.getFromMemberPrincipalType(), params.getFromMember(), new Relationship[0]);
                query.setFromOwner(member);
                query.setGroup(member == null ? null : member.getGroup());
            } else if (params.getFromSystem()) {
                query.setFromOwner(SystemAccountOwner.instance());
            }
            if (!restrictedMember.equals(query.getFromOwner()) && !restrictedMember.equals(query.getToOwner())) {
                throw WebServiceHelper.fault(WebServiceFaultsEnum.UNAUTHORIZED_ACCESS);
            }
        } else {
            if (params.getFromSystem()) {
                query.setFromNature(AccountType.Nature.SYSTEM);
            } else {
                Member member = this.memberHelper.loadByPrincipal(params.getFromMemberPrincipalType(), params.getFromMember(), new Relationship[0]);
                query.setFromOwner(member);
                query.setGroup(member == null ? null : member.getGroup());
            }
            if (params.getToSystem()) {
                query.setToNature(AccountType.Nature.SYSTEM);
            } else {
                query.setToOwner(this.memberHelper.loadByPrincipal(params.getToMemberPrincipalType(), params.getToMember(), new Relationship[0]));
            }
        }
        return query;
    }

    public ScheduledPaymentsResultPage toScheduledResultPage(final Member owner, List<ScheduledPayment> payments) {
        final HashMap customFieldsByTransferType = new HashMap();
        return this.queryHelper.toResultPage(ScheduledPaymentsResultPage.class, payments, new Transformer<ScheduledPayment, ScheduledPaymentVO>(){

            @Override
            public ScheduledPaymentVO transform(ScheduledPayment scheduledPayment) {
                TransferType transferType = scheduledPayment.getType();
                List<PaymentCustomField> customFields = (List<PaymentCustomField>)customFieldsByTransferType.get(transferType);
                if (customFields == null) {
                    customFields = AccountHelper.this.paymentCustomFieldService.list(transferType, true);
                    customFieldsByTransferType.put(transferType, customFields);
                }
                return AccountHelper.this.toVO((AccountOwner)owner, scheduledPayment, customFields);
            }
        });
    }

    public List<TransferTypeVO> toTransferTypeVOs(List<TransferType> transferTypes) {
        ArrayList<TransferTypeVO> vos = new ArrayList<TransferTypeVO>(transferTypes.size());
        for (TransferType transferType : transferTypes) {
            vos.add(this.toVO(transferType));
        }
        return vos;
    }

    public ScheduledPaymentVO toVO(AccountOwner viewingOwner, ScheduledPayment scheduledPayment, Collection<PaymentCustomField> customFields) {
        if (scheduledPayment == null) {
            return null;
        }
        ScheduledPaymentVO vo = new ScheduledPaymentVO();
        this.fill(vo, viewingOwner, scheduledPayment, customFields, null, null);
        vo.setOpen(scheduledPayment.getFirstOpenTransfer() != null);
        ArrayList<ScheduledPaymentInstallmentVO> installments = new ArrayList<ScheduledPaymentInstallmentVO>();
        for (Transfer installment : scheduledPayment.getTransfers()) {
            ScheduledPaymentInstallmentVO ivo = new ScheduledPaymentInstallmentVO();
            this.fill(ivo, viewingOwner, installment);
            installments.add(ivo);
        }
        vo.setInstallments(installments);
        return vo;
    }

    public AccountHistoryTransferVO toVO(AccountOwner viewingOwner, Transfer transfer, Collection<PaymentCustomField> customFields) {
        return this.toVO(viewingOwner, transfer, customFields, null, null);
    }

    public AccountHistoryTransferVO toVO(AccountOwner viewingOwner, Transfer transfer, Collection<PaymentCustomField> customFields, Collection<MemberCustomField> fromCustomFields, Collection<MemberCustomField> toCustomFields) {
        if (transfer == null) {
            return null;
        }
        AccountHistoryTransferVO vo = new AccountHistoryTransferVO();
        this.fill(vo, viewingOwner, transfer, customFields, fromCustomFields, toCustomFields);
        vo.setTransactionNumber(transfer.getTransactionNumber());
        if (WebServiceHelper.isCurrentClient(transfer.getClientId())) {
            vo.setTraceNumber(transfer.getTraceNumber());
        }
        return vo;
    }

    public AccountStatusVO toVO(AccountStatus status) {
        if (status == null) {
            return null;
        }
        UnitsConverter unitsConverter = this.settingsService.getLocalSettings().getUnitsConverter(status.getAccount().getType().getCurrency().getPattern());
        AccountStatusVO vo = new AccountStatusVO();
        vo.setBalance(status.getBalance());
        vo.setFormattedBalance(unitsConverter.toString(vo.getBalance()));
        vo.setAvailableBalance(status.getAvailableBalance());
        vo.setFormattedAvailableBalance(unitsConverter.toString(vo.getAvailableBalance()));
        vo.setReservedAmount(status.getReservedAmount());
        vo.setFormattedReservedAmount(unitsConverter.toString(vo.getReservedAmount()));
        vo.setCreditLimit(status.getCreditLimit());
        vo.setFormattedCreditLimit(unitsConverter.toString(vo.getCreditLimit()));
        vo.setUpperCreditLimit(status.getUpperCreditLimit());
        vo.setFormattedUpperCreditLimit(unitsConverter.toString(vo.getUpperCreditLimit()));
        return vo;
    }

    public AccountTypeVO toVO(AccountType type) {
        if (type == null) {
            return null;
        }
        AccountTypeVO vo = new AccountTypeVO();
        vo.setId(type.getId());
        vo.setCurrency(this.toVO(type.getCurrency()));
        vo.setName(type.getName());
        return vo;
    }

    public CurrencyVO toVO(Currency currency) {
        if (currency == null) {
            return null;
        }
        CurrencyVO vo = new CurrencyVO();
        vo.setId(currency.getId());
        vo.setName(currency.getName());
        vo.setSymbol(currency.getSymbol());
        vo.setPattern(currency.getPattern());
        return vo;
    }

    public MemberAccountVO toVO(MemberAccount memberAccount) {
        if (memberAccount == null) {
            return null;
        }
        memberAccount = (MemberAccount)this.accountService.load(memberAccount.getId(), Account.Relationships.TYPE, RelationshipHelper.nested(MemberAccount.Relationships.MEMBER, Element.Relationships.GROUP, MemberGroup.Relationships.ACCOUNT_SETTINGS));
        AccountType type = memberAccount.getType();
        MemberGroup memberGroup = memberAccount.getOwner().getMemberGroup();
        boolean isDefault = this.isDefault(type, memberGroup);
        MemberAccountVO vo = new MemberAccountVO();
        vo.setId(memberAccount.getId());
        vo.setDefault(isDefault);
        vo.setType(this.toVO(type));
        return vo;
    }

    public PaymentFilterVO toVO(PaymentFilter paymentFilter) {
        if (paymentFilter == null) {
            return null;
        }
        PaymentFilterVO vo = new PaymentFilterVO();
        vo.setId(paymentFilter.getId());
        vo.setName(paymentFilter.getName());
        return vo;
    }

    public TransferTypeVO toVO(TransferType tt) {
        if (tt == null) {
            return null;
        }
        TransferTypeVO vo = new TransferTypeVO();
        this.assignFieldsToTranserTypeVO(tt, vo);
        return vo;
    }

    public List<MemberAccountVO> toVOs(List<MemberAccount> accounts) {
        ArrayList<MemberAccountVO> vos = new ArrayList<MemberAccountVO>(accounts.size());
        for (MemberAccount account : accounts) {
            vos.add(this.toVO(account));
        }
        return vos;
    }

    private void assignFieldsToTranserTypeVO(TransferType tt, TransferTypeVO vo) {
        tt = this.transferTypeService.load(tt.getId(), TransferType.Relationships.FROM, TransferType.Relationships.TO);
        vo.setId(tt.getId());
        vo.setName(tt.getName());
        vo.setFrom(this.toVO(tt.getFrom()));
        vo.setTo(this.toVO(tt.getTo()));
    }

    private void fill(BasePaymentDataVO vo, AccountOwner viewingOwner, Payment payment) {
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        BigDecimal amount = payment.getActualAmount();
        vo.setId(payment.getId());
        vo.setDate(payment.getDate());
        vo.setFormattedDate(localSettings.getDateConverter().toString(vo.getDate()));
        vo.setProcessDate(payment.getProcessDate());
        vo.setFormattedProcessDate(localSettings.getDateConverter().toString(vo.getProcessDate()));
        vo.setStatus(PaymentStatusVO.valueOf(payment.getStatus().name()));
        Member restrictedMember = WebServiceContext.getMember();
        if (restrictedMember == null && viewingOwner == null) {
            vo.setAmount(amount);
        } else {
            boolean isDebit = viewingOwner.equals(payment.getActualFrom().getOwner());
            vo.setAmount(isDebit ? amount.negate() : amount);
        }
        TransferType tt = this.transferTypeService.load(payment.getType().getId(), RelationshipHelper.nested(TransferType.Relationships.FROM, AccountType.Relationships.CURRENCY));
        vo.setFormattedAmount(localSettings.getUnitsConverter(tt.getFrom().getCurrency().getPattern()).toString(vo.getAmount()));
    }

    private void fill(BasePaymentVO vo, AccountOwner viewingOwner, Payment payment, Collection<PaymentCustomField> customFields, Collection<MemberCustomField> fromCustomFields, Collection<MemberCustomField> toCustomFields) {
        this.fill(vo, viewingOwner, payment);
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        BigDecimal amount = payment.getActualAmount();
        vo.setId(payment.getId());
        vo.setDate(payment.getDate());
        vo.setFormattedDate(localSettings.getDateConverter().toString(vo.getDate()));
        vo.setProcessDate(payment.getProcessDate());
        vo.setFormattedProcessDate(localSettings.getDateConverter().toString(vo.getProcessDate()));
        vo.setTransferType(this.toVO(payment.getType()));
        vo.setDescription(payment.getDescription());
        Member restrictedMember = WebServiceContext.getMember();
        if (restrictedMember == null && viewingOwner == null) {
            vo.setAmount(amount);
            this.setRelatedAccount(vo, (Account)this.accountService.load(payment.getActualFrom().getId(), new Relationship[0]), false, fromCustomFields);
            this.setRelatedAccount(vo, (Account)this.accountService.load(payment.getActualTo().getId(), new Relationship[0]), true, toCustomFields);
        } else {
            boolean isDebit = viewingOwner.equals(payment.getActualFrom().getOwner());
            Object relatedAccount = this.accountService.load(isDebit ? payment.getActualTo().getId() : payment.getActualFrom().getId(), new Relationship[0]);
            vo.setAmount(isDebit ? amount.negate() : amount);
            this.setRelatedAccount(vo, (Account)relatedAccount, true, null);
        }
        if (customFields == null) {
            customFields = this.paymentCustomFieldService.list(payment.getType(), true);
        }
        vo.setFields(this.fieldHelper.toList(customFields, null, payment.getCustomValues()));
    }

    private boolean isDefault(AccountType accountType, MemberGroup memberGroup) {
        boolean isDefault = false;
        for (MemberGroupAccountSettings accountSettings : memberGroup.getAccountSettings()) {
            if (!accountSettings.getAccountType().equals(accountType) || !accountSettings.isDefault()) continue;
            isDefault = true;
            break;
        }
        return isDefault;
    }

    private AccountType resolveAccountType(AccountHistorySearchParameters params, Member member) {
        AccountType type = null;
        if (params.getAccountTypeId() == null) {
            Currency currency = this.currencyHelper.resolve(params.getCurrency());
            if (currency == null) {
                type = this.resolveDefaultAccountType(member);
            } else {
                for (Account account : this.accountService.getAccounts(member, new Relationship[0])) {
                    if (!currency.equals(account.getType().getCurrency())) continue;
                    type = account.getType();
                    break;
                }
                if (type == null) {
                    throw WebServiceHelper.fault((WebServiceFault)WebServiceFaultsEnum.INVALID_PARAMETERS, "No account of the given currency: " + currency);
                }
            }
        }
        return type;
    }

    private AccountType resolveDefaultAccountType(Member member) {
        List<Account> allAccounts = this.accountService.getAccounts(member, Account.Relationships.TYPE);
        Account defaultAccount = this.accountService.getDefaultAccountFromList(member, allAccounts);
        return defaultAccount == null ? null : defaultAccount.getType();
    }

    private void setRelatedAccount(BasePaymentVO vo, Account account, boolean isRelated, Collection<MemberCustomField> requiredFields) {
        if (account instanceof MemberAccount) {
            if (isRelated) {
                vo.setMember(this.memberHelper.toVO((Member)account.getOwner(), requiredFields, requiredFields, false));
            } else {
                vo.setFromMember(this.memberHelper.toVO((Member)account.getOwner(), requiredFields, requiredFields, false));
            }
        } else if (isRelated) {
            vo.setSystemAccountName(account.getOwnerName());
        } else {
            vo.setFromSystemAccountName(account.getOwnerName());
        }
    }
}

