/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.webservices.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.ads.AbstractAdQuery;
import nl.strohalm.cyclos.entities.ads.Ad;
import nl.strohalm.cyclos.entities.ads.AdCategory;
import nl.strohalm.cyclos.entities.ads.AdQuery;
import nl.strohalm.cyclos.entities.ads.FullTextAdQuery;
import nl.strohalm.cyclos.entities.customization.fields.AdCustomField;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.groups.GroupFilter;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.ads.AdServiceLocal;
import nl.strohalm.cyclos.services.customization.AdCustomFieldServiceLocal;
import nl.strohalm.cyclos.services.customization.MemberCustomFieldServiceLocal;
import nl.strohalm.cyclos.services.settings.SettingsServiceLocal;
import nl.strohalm.cyclos.utils.CustomFieldHelper;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.TimePeriod;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.conversion.CoercionHelper;
import nl.strohalm.cyclos.utils.conversion.Transformer;
import nl.strohalm.cyclos.webservices.ads.AbstractAdSearchParameters;
import nl.strohalm.cyclos.webservices.ads.AdResultPage;
import nl.strohalm.cyclos.webservices.ads.AdSearchParameters;
import nl.strohalm.cyclos.webservices.ads.FullTextAdSearchParameters;
import nl.strohalm.cyclos.webservices.model.AdCategoryHierarchicalVO;
import nl.strohalm.cyclos.webservices.model.AdCategoryVO;
import nl.strohalm.cyclos.webservices.model.AdVO;
import nl.strohalm.cyclos.webservices.model.DetailedAdCategoryVO;
import nl.strohalm.cyclos.webservices.model.FieldValueVO;
import nl.strohalm.cyclos.webservices.model.MyAdVO;
import nl.strohalm.cyclos.webservices.model.TimePeriodVO;
import nl.strohalm.cyclos.webservices.utils.CurrencyHelper;
import nl.strohalm.cyclos.webservices.utils.FieldHelper;
import nl.strohalm.cyclos.webservices.utils.ImageHelper;
import nl.strohalm.cyclos.webservices.utils.MemberHelper;
import nl.strohalm.cyclos.webservices.utils.QueryHelper;

public class AdHelper {
    private CurrencyHelper currencyHelper;
    private FieldHelper fieldHelper;
    private ImageHelper imageHelper;
    private MemberHelper memberHelper;
    private SettingsServiceLocal settingsService;
    private QueryHelper queryHelper;
    private AdCustomFieldServiceLocal adCustomFieldService;
    private MemberCustomFieldServiceLocal memberCustomFieldService;
    private AdServiceLocal adServiceLocal;
    private CustomFieldHelper customFieldHelper;

    public void setAdCustomFieldServiceLocal(AdCustomFieldServiceLocal adCustomFieldService) {
        this.adCustomFieldService = adCustomFieldService;
    }

    public void setAdServiceLocal(AdServiceLocal adService) {
        this.adServiceLocal = adService;
    }

    public void setCurrencyHelper(CurrencyHelper currencyHelper) {
        this.currencyHelper = currencyHelper;
    }

    public void setCustomFieldHelper(CustomFieldHelper customFieldHelper) {
        this.customFieldHelper = customFieldHelper;
    }

    public void setFieldHelper(FieldHelper fieldHelper) {
        this.fieldHelper = fieldHelper;
    }

    public void setImageHelper(ImageHelper imageHelper) {
        this.imageHelper = imageHelper;
    }

    public void setMemberCustomFieldServiceLocal(MemberCustomFieldServiceLocal memberCustomFieldService) {
        this.memberCustomFieldService = memberCustomFieldService;
    }

    public void setMemberHelper(MemberHelper memberHelper) {
        this.memberHelper = memberHelper;
    }

    public void setQueryHelper(QueryHelper queryHelper) {
        this.queryHelper = queryHelper;
    }

    public void setSettingsServiceLocal(SettingsServiceLocal settingsService) {
        this.settingsService = settingsService;
    }

    public DetailedAdCategoryVO toDetailedVO(AdCategory category) {
        if (category == null) {
            return null;
        }
        DetailedAdCategoryVO vo = new DetailedAdCategoryVO();
        vo.setId(category.getId());
        vo.setName(category.getName());
        vo.setFullName(category.getFullName());
        vo.setLevel(category.getLevel());
        vo.setCountOffer(this.adServiceLocal.countExternalAds(category.getId(), Ad.TradeType.OFFER));
        vo.setCountSearch(this.adServiceLocal.countExternalAds(category.getId(), Ad.TradeType.SEARCH));
        Collection<AdCategory> childrenList = category.getChildren();
        ArrayList<DetailedAdCategoryVO> children = new ArrayList<DetailedAdCategoryVO>();
        for (AdCategory child : childrenList) {
            children.add(this.toDetailedVO(child));
        }
        vo.setChildren(children);
        return vo;
    }

    public FullTextAdQuery toFullTextQuery(FullTextAdSearchParameters params) {
        if (params == null) {
            return null;
        }
        FullTextAdQuery query = new FullTextAdQuery();
        this.fill(params, query);
        return query;
    }

    public AdVO toFullVO(Ad ad) {
        List<AdCustomField> adFields = this.adCustomFieldService.list();
        List<MemberCustomField> memberFields = this.memberCustomFieldService.list();
        if (!LoggedUser.isUnrestrictedClient()) {
            MemberGroup group = LoggedUser.member().getMemberGroup();
            memberFields = this.customFieldHelper.onlyVisibleFields(memberFields, group);
        }
        return this.toVO(ad, adFields, memberFields);
    }

    public AdCategoryHierarchicalVO toHierarchicalVO(AdCategory category) {
        if (category == null || !category.isActive()) {
            return null;
        }
        AdCategoryHierarchicalVO vo = new AdCategoryHierarchicalVO();
        vo.setId(category.getId());
        vo.setName(category.getName());
        ArrayList<AdCategoryHierarchicalVO> children = new ArrayList<AdCategoryHierarchicalVO>();
        for (AdCategory child : category.getChildren()) {
            AdCategoryHierarchicalVO childVO = this.toHierarchicalVO(child);
            if (childVO == null) continue;
            children.add(childVO);
        }
        vo.setChildren(children);
        return vo;
    }

    public MyAdVO toMyVO(Ad ad) {
        List<AdCustomField> adFields = this.adCustomFieldService.list();
        MyAdVO vo = this.toVO(MyAdVO.class, ad, adFields, null);
        vo.setStatus(AbstractAdSearchParameters.AdVOStatus.valueOf(ad.getStatus().name()));
        return vo;
    }

    public AdQuery toQuery(AdSearchParameters params) {
        if (params == null) {
            return null;
        }
        AdQuery query = new AdQuery();
        this.fill(params, query);
        query.setRandomOrder(params.getRandomOrder());
        return query;
    }

    public AdResultPage toResultPage(AbstractAdSearchParameters params, List<Ad> ads) {
        final List adFields = params.getShowAdFields() ? this.adCustomFieldService.list() : null;
        final List allMemberFields = params.getShowMemberFields() ? this.memberCustomFieldService.list() : null;
        return this.queryHelper.toResultPage(AdResultPage.class, ads, new Transformer<Ad, AdVO>(){

            @Override
            public AdVO transform(Ad ad) {
                List<MemberCustomField> memberFields = null;
                if (allMemberFields != null) {
                    MemberGroup group = EntityHelper.reference(MemberGroup.class, ad.getOwner().getGroup().getId());
                    memberFields = AdHelper.this.customFieldHelper.onlyForGroup(allMemberFields, group);
                }
                return AdHelper.this.toVO(ad, adFields, memberFields);
            }
        });
    }

    public AdVO toVO(Ad ad) {
        return this.toVO(ad, null);
    }

    public AdVO toVO(Ad ad, List<AdCustomField> fields) {
        return this.toVO(ad, fields, null);
    }

    public AdVO toVO(Ad ad, List<AdCustomField> adFields, List<MemberCustomField> memberFields) {
        return this.toVO(AdVO.class, ad, adFields, memberFields);
    }

    public AdCategoryVO toVO(AdCategory category) {
        if (category == null) {
            return null;
        }
        AdCategoryVO vo = new AdCategoryVO();
        vo.setId(category.getId());
        vo.setName(category.getFullName());
        return vo;
    }

    public <VO extends AdVO> VO toVO(Class<VO> voType, Ad ad, List<AdCustomField> adFields, List<MemberCustomField> memberFields) {
        AdVO vo;
        if (ad == null) {
            return null;
        }
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        try {
            vo = (AdVO)voType.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        vo.setId(ad.getId());
        vo.setCategory(this.toVO(ad.getCategory()));
        vo.setTitle(ad.getTitle());
        vo.setDescription(ad.getDescription());
        Currency currency = ad.getCurrency();
        vo.setCurrency(this.currencyHelper.toVO(currency));
        vo.setPrice(ad.getPrice());
        if (currency == null) {
            vo.setFormattedPrice(localSettings.getNumberConverter().toString(ad.getPrice()));
        } else {
            vo.setFormattedPrice(localSettings.getUnitsConverter(currency.getPattern()).toString(ad.getPrice()));
        }
        vo.setPermanent(ad.isPermanent());
        vo.setSearching(ad.getTradeType() == Ad.TradeType.SEARCH);
        vo.setHtml(ad.isHtml());
        Period publicationPeriod = ad.getPublicationPeriod();
        if (publicationPeriod != null) {
            Calendar begin = publicationPeriod.getBegin();
            Calendar end = publicationPeriod.getEnd();
            vo.setPublicationStart(begin);
            vo.setFormattedPublicationStart(localSettings.getRawDateConverter().toString(begin));
            vo.setPublicationEnd(end);
            vo.setFormattedPublicationEnd(localSettings.getRawDateConverter().toString(end));
        }
        vo.setOwner(this.memberHelper.toVO(ad.getOwner(), memberFields, false));
        vo.setImages(this.imageHelper.toVOs(ad.getImages()));
        if (adFields != null) {
            ArrayList<AdCustomField> visibleAdFields = new ArrayList<AdCustomField>();
            List<AdCustomField.Visibility> allowedVisibilities = Arrays.asList(AdCustomField.Visibility.WEB_SERVICE, AdCustomField.Visibility.MEMBER);
            for (AdCustomField adCustomField : adFields) {
                if (!allowedVisibilities.contains(adCustomField.getVisibility())) continue;
                visibleAdFields.add(adCustomField);
            }
            vo.setFields(this.fieldHelper.toList(visibleAdFields, null, ad.getCustomValues()));
        }
        return (VO)vo;
    }

    private void fill(AbstractAdSearchParameters params, AbstractAdQuery query) {
        List<FieldValueVO> memberFields;
        List<FieldValueVO> adFields;
        GroupFilter[] groupFilters;
        AbstractAdSearchParameters.AdVOTradeType tradeType;
        query.fetch(Ad.Relationships.OWNER, Ad.Relationships.CUSTOM_VALUES, Ad.Relationships.IMAGES, Ad.Relationships.CATEGORY);
        this.queryHelper.fill(params, query);
        query.setExternalPublication(true);
        if (LoggedUser.isUnrestrictedClient()) {
            AbstractAdSearchParameters.AdVOStatus status = params.getStatus();
            if (status == null) {
                status = AbstractAdSearchParameters.AdVOStatus.ACTIVE;
            }
            switch (status) {
                case PERMANENT: {
                    query.setStatus(Ad.Status.PERMANENT);
                    break;
                }
                case SCHEDULED: {
                    query.setStatus(Ad.Status.SCHEDULED);
                    break;
                }
                case EXPIRED: {
                    query.setStatus(Ad.Status.EXPIRED);
                    break;
                }
                default: {
                    query.setStatus(Ad.Status.ACTIVE);
                    break;
                }
            }
        } else {
            query.setStatus(Ad.Status.ACTIVE);
        }
        query.setCategory(params.getCategoryId() == null ? null : EntityHelper.reference(AdCategory.class, params.getCategoryId()));
        query.setKeywords(params.getKeywords());
        query.setInitialPrice(params.getInitialPrice());
        query.setFinalPrice(params.getFinalPrice());
        TimePeriodVO since = params.getSince();
        if (since != null && since.getNumber() != null && since.getField() != null) {
            TimePeriod timePeriod = new TimePeriod(since.getNumber(), TimePeriod.Field.valueOf(since.getField().name()));
            query.setSince(timePeriod);
        }
        if (params.getBeginDate() != null || params.getEndDate() != null) {
            query.setPeriod(Period.between(params.getBeginDate(), params.getEndDate()));
        }
        if ((tradeType = params.getTradeType()) != null) {
            switch (tradeType) {
                case OFFER: {
                    query.setTradeType(Ad.TradeType.OFFER);
                    break;
                }
                case SEARCH: {
                    query.setTradeType(Ad.TradeType.SEARCH);
                }
            }
        }
        query.setOwner(CoercionHelper.coerce(Member.class, params.getMemberId()));
        MemberGroup[] groups = (MemberGroup[])EntityHelper.references(MemberGroup.class, params.getMemberGroupIds());
        if (groups == null || groups.length > 0) {
            query.setGroups(Arrays.asList(groups));
        }
        if ((groupFilters = (GroupFilter[])EntityHelper.references(GroupFilter.class, params.getMemberGroupFilterIds())) == null || groupFilters.length > 0) {
            query.setGroupFilters(Arrays.asList(groupFilters));
        }
        if ((adFields = params.getAdFields()) != null && adFields.size() > 0) {
            List<AdCustomField> adCustomFields = this.adCustomFieldService.list();
            adCustomFields = this.customFieldHelper.onlyForAdsSearch(adCustomFields);
            query.setAdValues(this.customFieldHelper.toValueCollection(adCustomFields, adFields));
        }
        if ((memberFields = params.getMemberFields()) != null && memberFields.size() > 0) {
            List<MemberCustomField> memberCustomFields = this.memberCustomFieldService.list();
            memberCustomFields = this.customFieldHelper.onlyForAdSearch(memberCustomFields);
            query.setMemberValues(this.customFieldHelper.toValueCollection(memberCustomFields, memberFields));
        }
        query.setWithImagesOnly(params.getWithImagesOnly());
    }
}

