/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.webservices.utils;

import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.access.PrincipalType;
import nl.strohalm.cyclos.services.access.ChannelServiceLocal;
import nl.strohalm.cyclos.webservices.WebServiceContext;
import org.apache.commons.lang.StringUtils;

public class ChannelHelper {
    private ChannelServiceLocal channelServiceLocal;

    public Channel get(String channel) {
        if (StringUtils.isEmpty((String)channel)) {
            return null;
        }
        return this.channelServiceLocal.loadByInternalName(channel);
    }

    public Channel getResolved(String internalName) {
        String channel = this.resolveChannel(internalName);
        return channel == null ? null : this.get(channel);
    }

    public String resolveChannel(String channel) {
        Channel restricted = WebServiceContext.getChannel();
        if (restricted != null) {
            return restricted.getInternalName();
        }
        return channel;
    }

    public PrincipalType resolvePrincipalType(String principalType) {
        Channel channel = WebServiceContext.getChannel();
        PrincipalType type = channel == null ? this.channelServiceLocal.resolvePrincipalType(principalType) : this.channelServiceLocal.resolvePrincipalType(channel.getInternalName(), principalType);
        return type;
    }

    public String restricted() {
        Channel restricted = WebServiceContext.getChannel();
        if (restricted != null) {
            return restricted.getInternalName();
        }
        return null;
    }

    public void setChannelServiceLocal(ChannelServiceLocal channelService) {
        this.channelServiceLocal = channelService;
    }
}

