/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.webservices.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Contact;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.customization.MemberCustomFieldServiceLocal;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.utils.CustomFieldHelper;
import nl.strohalm.cyclos.webservices.model.ContactVO;
import nl.strohalm.cyclos.webservices.model.MemberVO;
import nl.strohalm.cyclos.webservices.utils.MemberHelper;
import org.apache.commons.collections.CollectionUtils;

public class ContactHelper {
    private MemberCustomFieldServiceLocal memberCustomFieldService;
    private MemberHelper memberHelper;
    private FetchServiceLocal fetchService;
    private CustomFieldHelper customFieldHelper;

    public void setCustomFieldHelper(CustomFieldHelper customFieldHelper) {
        this.customFieldHelper = customFieldHelper;
    }

    public void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }

    public void setMemberCustomFieldServiceLocal(MemberCustomFieldServiceLocal memberCustomFieldService) {
        this.memberCustomFieldService = memberCustomFieldService;
    }

    public void setMemberHelper(MemberHelper memberHelper) {
        this.memberHelper = memberHelper;
    }

    public List<ContactVO> toList(List<Contact> contacts, boolean useFields, boolean useImages) {
        if (CollectionUtils.isEmpty(contacts)) {
            return Collections.emptyList();
        }
        ArrayList<ContactVO> contactVOs = new ArrayList<ContactVO>(contacts.size());
        List<MemberCustomField> customFields = null;
        if (useFields) {
            customFields = this.memberCustomFieldService.list();
        }
        HashMap<Group, List<MemberCustomField>> fieldsPerGroup = new HashMap<Group, List<MemberCustomField>>();
        for (Contact contact : contacts) {
            Group group;
            List<MemberCustomField> fields = null;
            if (useFields && (fields = (List<MemberCustomField>)fieldsPerGroup.get(group = contact.getContact().getGroup())) == null) {
                fields = this.customFieldHelper.onlyVisibleFields(customFields, (MemberGroup)this.fetchService.fetch(contact.getContact().getGroup(), new Relationship[0]));
                fieldsPerGroup.put(group, fields);
            }
            ContactVO contactVO = this.toVO(contact, fields, useImages);
            contactVOs.add(contactVO);
        }
        return contactVOs;
    }

    public ContactVO toVO(Contact contact, boolean useFields, boolean useImages) {
        Member member = contact.getContact();
        List<MemberCustomField> fields = null;
        if (useFields) {
            fields = this.customFieldHelper.onlyVisibleFields(this.memberCustomFieldService.list(), member.getMemberGroup());
        }
        return this.toVO(contact, fields, useImages);
    }

    private ContactVO toVO(Contact contact, List<MemberCustomField> customFields, boolean useImages) {
        if (contact == null) {
            return null;
        }
        MemberVO memberVO = this.memberHelper.toVO(contact.getContact(), customFields, useImages);
        ContactVO contactVO = new ContactVO();
        contactVO.setId(contact.getId());
        contactVO.setMember(memberVO);
        contactVO.setNotes(contact.getNotes());
        return contactVO;
    }
}

