/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.webservices.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import nl.strohalm.cyclos.entities.customization.fields.CustomField;
import nl.strohalm.cyclos.entities.customization.fields.CustomFieldPossibleValue;
import nl.strohalm.cyclos.entities.customization.fields.CustomFieldValue;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomFieldValue;
import nl.strohalm.cyclos.utils.CustomFieldHelper;
import nl.strohalm.cyclos.utils.StringHelper;
import nl.strohalm.cyclos.webservices.model.FieldVO;
import nl.strohalm.cyclos.webservices.model.FieldValueVO;
import nl.strohalm.cyclos.webservices.model.PossibleValueVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;

public class FieldHelper {
    private CustomFieldHelper customFieldHelper;

    public void setCustomFieldHelper(CustomFieldHelper customFieldHelper) {
        this.customFieldHelper = customFieldHelper;
    }

    public <CFV extends CustomFieldValue> void toCustomFieldValues(Class<CFV> valueClass, List<? extends CustomField> allowedFields, Map<String, String> customValues, Collection<CFV> fieldValues) {
        if (MapUtils.isNotEmpty(customValues)) {
            for (String internalName : customValues.keySet()) {
                CustomFieldValue fieldValue;
                String value = customValues.get(internalName);
                if (!StringUtils.isNotEmpty((String)value)) continue;
                CustomField field = this.customFieldHelper.findByInternalName(allowedFields, internalName);
                if (field == null) {
                    throw new IllegalArgumentException("Couldn't find custom field with internal name: '" + internalName + "' or the field is not searchable");
                }
                try {
                    fieldValue = (CustomFieldValue)valueClass.newInstance();
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
                fieldValue.setField(field);
                fieldValue.setValue(value);
                fieldValues.add(fieldValue);
            }
        }
    }

    public List<FieldVO> toFieldVOs(Collection<? extends CustomField> customFields) {
        if (customFields == null) {
            return null;
        }
        ArrayList<FieldVO> vos = new ArrayList<FieldVO>(customFields.size());
        for (CustomField customField : customFields) {
            vos.add(this.toVO(customField));
        }
        return vos;
    }

    public List<FieldValueVO> toList(Collection<? extends CustomField> fields, Collection<? extends CustomField> requiredFields, Collection<? extends CustomFieldValue> customValues) {
        if (CollectionUtils.isEmpty(fields) || CollectionUtils.isEmpty(customValues)) {
            return Collections.emptyList();
        }
        ArrayList<FieldValueVO> values = new ArrayList<FieldValueVO>();
        for (CustomField customField : fields) {
            String valueAsString = this.getFieldValue(customField, requiredFields, customValues);
            if (valueAsString == null) continue;
            if (StringUtils.isNotEmpty((String)customField.getPattern())) {
                valueAsString = StringHelper.removeMask(customField.getPattern(), valueAsString);
            }
            FieldValueVO fieldValueVO = new FieldValueVO(customField.getInternalName(), valueAsString);
            CustomFieldValue value = this.customFieldHelper.findByField(customField, customValues);
            if (value.getPossibleValue() != null) {
                fieldValueVO.setPossibleValueId(value.getPossibleValue().getId());
            }
            fieldValueVO.setFieldId(customField.getId());
            fieldValueVO.setDisplayName(customField.getName());
            values.add(fieldValueVO);
        }
        return values;
    }

    public Map<String, String> toMap(Collection<? extends CustomField> fields, Collection<? extends CustomField> requiredFields, Collection<? extends CustomFieldValue> customValues) {
        if (CollectionUtils.isEmpty(fields) || CollectionUtils.isEmpty(customValues)) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        for (CustomField customField : fields) {
            String valueAsString = this.getFieldValue(customField, requiredFields, customValues);
            if (valueAsString == null) continue;
            values.put(customField.getInternalName(), valueAsString);
        }
        return values;
    }

    public List<PossibleValueVO> toPossibleValueVOs(Collection<CustomFieldPossibleValue> possibleValues) {
        ArrayList<PossibleValueVO> vos = new ArrayList<PossibleValueVO>(possibleValues.size());
        for (CustomFieldPossibleValue possibleValue : possibleValues) {
            vos.add(this.toVO(possibleValue));
        }
        return vos;
    }

    public FieldVO toVO(CustomField field) {
        if (field == null) {
            return null;
        }
        FieldVO vo = new FieldVO();
        vo.setId(field.getId());
        vo.setDisplayName(field.getName());
        vo.setInternalName(field.getInternalName());
        vo.setType(FieldVO.FieldVOType.valueOf(field.getType().name()));
        vo.setMask(field.getPattern());
        vo.setControl(FieldVO.FieldVOControl.valueOf(field.getControl().name()));
        vo.setRequired(field.getValidation() != null && field.getValidation().isRequired());
        vo.setPossibleValues(this.toPossibleValueVOs(field.getPossibleValues(true)));
        vo.setMinLength(field.getValidation().getLengthConstraint().getMin());
        vo.setMaxLength(field.getValidation().getLengthConstraint().getMax());
        if (field.getParent() != null) {
            vo.setParentId(field.getParent().getId());
        }
        return vo;
    }

    public PossibleValueVO toVO(CustomFieldPossibleValue possibleValue) {
        if (possibleValue == null) {
            return null;
        }
        PossibleValueVO vo = new PossibleValueVO();
        vo.setId(possibleValue.getId());
        vo.setValue(possibleValue.getValue());
        if (possibleValue.getParent() != null) {
            vo.setParentId(possibleValue.getParent().getId());
        }
        vo.setDefaultValue(possibleValue.isDefaultValue());
        return vo;
    }

    protected String getFieldValue(CustomField field, Collection<? extends CustomField> requiredFields, Collection<? extends CustomFieldValue> customValues) {
        MemberCustomFieldValue memberValue;
        CustomFieldValue value = this.customFieldHelper.findByField(field, customValues);
        if ((requiredFields == null || !requiredFields.contains(field)) && value instanceof MemberCustomFieldValue && (memberValue = (MemberCustomFieldValue)value).isHidden()) {
            return null;
        }
        if (value != null) {
            String valueAsString = value.getValue();
            if (StringUtils.isNotEmpty((String)field.getPattern())) {
                valueAsString = StringHelper.applyMask(field.getPattern(), valueAsString);
            }
            return valueAsString;
        }
        return null;
    }
}

