/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.webservices.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.entities.customization.images.Image;
import nl.strohalm.cyclos.entities.customization.images.OwneredImage;
import nl.strohalm.cyclos.entities.customization.images.SystemImage;
import nl.strohalm.cyclos.webservices.WebServiceContext;
import nl.strohalm.cyclos.webservices.model.ImageVO;

public class ImageHelper {
    public ImageVO toVO(Image image, String basePath) {
        ImageVO vo = new ImageVO();
        Long id = image.getId();
        vo.setId(id);
        vo.setLastModified(image.getLastModified());
        if (basePath != null) {
            vo.setThumbnailUrl(basePath + "/thumbnail?id=" + id);
            vo.setFullUrl(basePath + "/image?id=" + id);
        }
        return vo;
    }

    public ImageVO toVO(OwneredImage image) {
        return this.toVO(image, null);
    }

    public ImageVO toVO(OwneredImage image, String basePath) {
        if (image == null) {
            return null;
        }
        ImageVO vo = this.toVO((Image)image, basePath);
        vo.setCaption(image.getCaption());
        return vo;
    }

    public ImageVO toVO(SystemImage image) {
        if (image == null) {
            return null;
        }
        String basePath = this.getBasePath();
        return this.toVO(image, basePath);
    }

    public List<ImageVO> toVOs(Collection<? extends OwneredImage> images) {
        String basePath = this.getBasePath();
        ArrayList<ImageVO> vos = new ArrayList<ImageVO>();
        for (OwneredImage owneredImage : images) {
            vos.add(this.toVO(owneredImage, basePath));
        }
        return vos;
    }

    private String getBasePath() {
        HttpServletRequest request = WebServiceContext.getRequest();
        String basePath = null;
        if (request != null) {
            basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
        }
        return basePath;
    }
}

