/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.webservices.utils;

import java.util.List;
import nl.strohalm.cyclos.entities.infotexts.InfoText;
import nl.strohalm.cyclos.entities.infotexts.InfoTextQuery;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.conversion.Transformer;
import nl.strohalm.cyclos.webservices.infotexts.InfoTextResultPage;
import nl.strohalm.cyclos.webservices.infotexts.InfoTextSearchParameters;
import nl.strohalm.cyclos.webservices.model.InfoTextVO;
import nl.strohalm.cyclos.webservices.utils.QueryHelper;

public class InfoTextHelper {
    private QueryHelper queryHelper;

    public void setQueryHelper(QueryHelper queryHelper) {
        this.queryHelper = queryHelper;
    }

    public InfoTextQuery toQuery(InfoTextSearchParameters params) {
        if (params == null) {
            return null;
        }
        InfoTextQuery query = new InfoTextQuery();
        this.queryHelper.fill(params, query);
        query.setAlias(params.getAlias());
        query.setKeywords(params.getKeywords());
        return query;
    }

    public InfoTextResultPage toResultPage(List<InfoText> list) {
        return this.queryHelper.toResultPage(InfoTextResultPage.class, list, new Transformer<InfoText, InfoTextVO>(){

            @Override
            public InfoTextVO transform(InfoText infoText) {
                return InfoTextHelper.this.toVO(infoText);
            }
        });
    }

    public InfoTextVO toVO(InfoText infoText) {
        InfoTextVO vo = new InfoTextVO();
        vo.setId(infoText.getId());
        vo.setSubject(infoText.getSubject());
        vo.setBody(infoText.getBody());
        Period validity = infoText.getValidity();
        vo.setValidFrom(validity == null ? null : validity.getBegin());
        vo.setValidTo(validity == null ? null : validity.getEnd());
        return vo;
    }
}

