/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.webservices.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.access.ChannelPrincipal;
import nl.strohalm.cyclos.entities.access.MemberUser;
import nl.strohalm.cyclos.entities.access.PrincipalType;
import nl.strohalm.cyclos.entities.customization.fields.CustomField;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomFieldValue;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.GroupFilter;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.FullTextMemberQuery;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.MemberQuery;
import nl.strohalm.cyclos.entities.services.ServiceClient;
import nl.strohalm.cyclos.services.access.AccessServiceLocal;
import nl.strohalm.cyclos.services.customization.MemberCustomFieldServiceLocal;
import nl.strohalm.cyclos.services.elements.ElementServiceLocal;
import nl.strohalm.cyclos.services.groups.GroupServiceLocal;
import nl.strohalm.cyclos.services.permissions.PermissionServiceLocal;
import nl.strohalm.cyclos.services.services.ServiceClientServiceLocal;
import nl.strohalm.cyclos.utils.CustomFieldHelper;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.conversion.Transformer;
import nl.strohalm.cyclos.webservices.PrincipalParameters;
import nl.strohalm.cyclos.webservices.WebServiceContext;
import nl.strohalm.cyclos.webservices.WebServiceFaultsEnum;
import nl.strohalm.cyclos.webservices.members.FullTextMemberSearchParameters;
import nl.strohalm.cyclos.webservices.members.MemberResultPage;
import nl.strohalm.cyclos.webservices.members.MemberSearchParameters;
import nl.strohalm.cyclos.webservices.members.RegisterMemberParameters;
import nl.strohalm.cyclos.webservices.model.FieldValueVO;
import nl.strohalm.cyclos.webservices.model.MemberVO;
import nl.strohalm.cyclos.webservices.model.MyProfileVO;
import nl.strohalm.cyclos.webservices.utils.ChannelHelper;
import nl.strohalm.cyclos.webservices.utils.FieldHelper;
import nl.strohalm.cyclos.webservices.utils.ImageHelper;
import nl.strohalm.cyclos.webservices.utils.QueryHelper;
import nl.strohalm.cyclos.webservices.utils.WebServiceHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class MemberHelper {
    private QueryHelper queryHelper;
    private ImageHelper imageHelper;
    private FieldHelper fieldHelper;
    private ElementServiceLocal elementServiceLocal;
    private ServiceClientServiceLocal serviceClientServiceLocal;
    private MemberCustomFieldServiceLocal memberCustomFieldServiceLocal;
    private PermissionServiceLocal permissionService;
    private GroupServiceLocal groupServiceLocal;
    private ChannelHelper channelHelper;
    private AccessServiceLocal accessServiceLocal;
    private CustomFieldHelper customFieldHelper;

    public void checkChannelEnabledForMember(Member member) {
        if (!this.isChannelEnabledForMember(member)) {
            throw WebServiceHelper.fault(WebServiceFaultsEnum.INVALID_CHANNEL);
        }
    }

    public boolean isChannelEnabledForMember(Member member) {
        Channel channel = WebServiceContext.getChannel();
        if (channel == null) {
            return true;
        }
        Member restrictedMember = WebServiceContext.getMember();
        if (restrictedMember != null && restrictedMember.equals(member)) {
            return true;
        }
        return this.accessServiceLocal.isChannelEnabledForMember(channel.getInternalName(), member);
    }

    public Member loadByPrincipal(PrincipalType principalType, String principal, Relationship ... relationships) {
        if (StringUtils.isNotEmpty((String)principal)) {
            Member member;
            Channel channel = WebServiceContext.getChannel();
            if (channel != null) {
                if (principalType == null) {
                    principalType = channel.getDefaultPrincipalType();
                } else if (!channel.getPrincipalTypes().contains(principalType)) {
                    return null;
                }
            }
            if (ArrayUtils.isNotEmpty((Object[])relationships)) {
                Relationship[] tmp = new Relationship[relationships.length + 2];
                tmp[0] = Element.Relationships.USER;
                tmp[1] = Element.Relationships.GROUP;
                System.arraycopy(relationships, 0, tmp, 2, relationships.length);
                member = this.elementServiceLocal.loadByPrincipal(principalType, principal, tmp);
            } else {
                member = this.elementServiceLocal.loadByPrincipal(principalType, principal, Element.Relationships.USER, Element.Relationships.GROUP);
            }
            if (!this.permissionService.relatesTo(member)) {
                throw new EntityNotFoundException(Member.class);
            }
            return member;
        }
        return null;
    }

    public Member loadByPrincipal(String principalType, String principal, Relationship ... relationships) {
        PrincipalType type = this.channelHelper.resolvePrincipalType(principalType);
        return this.loadByPrincipal(type, principal, relationships);
    }

    public Member resolveMember(PrincipalParameters params) {
        if (params == null) {
            return null;
        }
        return this.resolveMember(params.getPrincipalType(), params.getPrincipal());
    }

    public Member resolveMember(PrincipalType principalType, String principal) {
        Member member = WebServiceContext.getMember();
        if (member == null) {
            if (StringUtils.isEmpty((String)principal)) {
                return null;
            }
            return this.loadByPrincipal(principalType, principal, new Relationship[0]);
        }
        return member;
    }

    public Member resolveMember(String principalType, String principal) {
        PrincipalType type = this.channelHelper.resolvePrincipalType(principalType);
        return this.resolveMember(type, principal);
    }

    public MemberUser resolveUser(PrincipalType principalType, String principal) {
        Member member = this.resolveMember(principalType, principal);
        return member == null ? null : member.getMemberUser();
    }

    public void setAccessServiceLocal(AccessServiceLocal accessService) {
        this.accessServiceLocal = accessService;
    }

    public void setChannelHelper(ChannelHelper channelHelper) {
        this.channelHelper = channelHelper;
    }

    public void setCustomFieldHelper(CustomFieldHelper customFieldHelper) {
        this.customFieldHelper = customFieldHelper;
    }

    public void setElementServiceLocal(ElementServiceLocal elementService) {
        this.elementServiceLocal = elementService;
    }

    public void setFieldHelper(FieldHelper fieldHelper) {
        this.fieldHelper = fieldHelper;
    }

    public void setGroupServiceLocal(GroupServiceLocal groupService) {
        this.groupServiceLocal = groupService;
    }

    public void setImageHelper(ImageHelper imageHelper) {
        this.imageHelper = imageHelper;
    }

    public void setMemberCustomFieldServiceLocal(MemberCustomFieldServiceLocal memberCustomFieldService) {
        this.memberCustomFieldServiceLocal = memberCustomFieldService;
    }

    public void setPermissionServiceLocal(PermissionServiceLocal permissionService) {
        this.permissionService = permissionService;
    }

    public void setQueryHelper(QueryHelper queryHelper) {
        this.queryHelper = queryHelper;
    }

    public void setServiceClientServiceLocal(ServiceClientServiceLocal serviceClientService) {
        this.serviceClientServiceLocal = serviceClientService;
    }

    public FullTextMemberQuery toFullTextQuery(FullTextMemberSearchParameters params) {
        MemberGroup[] groups;
        if (params == null) {
            return null;
        }
        FullTextMemberQuery query = new FullTextMemberQuery();
        query.setEnabled(true);
        query.fetch(Element.Relationships.GROUP, Element.Relationships.USER);
        if (params.getShowCustomFields()) {
            query.fetch(Member.Relationships.CUSTOM_VALUES);
        }
        if (params.getShowImages()) {
            query.fetch(Member.Relationships.IMAGES);
        }
        query.setKeywords(params.getKeywords());
        GroupFilter[] groupFilters = (GroupFilter[])EntityHelper.references(GroupFilter.class, params.getGroupFilterIds());
        if (groupFilters == null || groupFilters.length > 0) {
            query.setGroupFilters(Arrays.asList(groupFilters));
        }
        if ((groups = (MemberGroup[])EntityHelper.references(MemberGroup.class, params.getGroupIds())) == null || groups.length > 0) {
            query.setGroups(Arrays.asList(groups));
        }
        this.queryHelper.fill(params, query);
        if (params.getExcludeLoggedIn()) {
            Member member = LoggedUser.member();
            query.setExcludeElements(Collections.singleton(member));
        }
        query.setWithImagesOnly(params.getWithImagesOnly());
        List<MemberCustomField> memberFields = this.customFieldHelper.onlyForMemberSearch(this.memberCustomFieldServiceLocal.list());
        query.setCustomValues(this.customFieldHelper.toValueCollection(memberFields, params.getFields()));
        return query;
    }

    public MemberVO toFullVO(Member member) {
        if (!member.isActive() || member.getGroup().getStatus() == Group.Status.REMOVED) {
            throw new EntityNotFoundException();
        }
        List<MemberCustomField> fields = this.memberCustomFieldServiceLocal.list();
        if (!LoggedUser.isUnrestrictedClient()) {
            MemberGroup group = LoggedUser.member().getMemberGroup();
            fields = this.customFieldHelper.onlyVisibleFields(fields, group);
        }
        return this.toVO(member, fields, true);
    }

    public Member toMember(RegisterMemberParameters params) {
        MemberGroup group;
        try {
            ServiceClient client = this.serviceClientServiceLocal.load(WebServiceContext.getClient().getId(), ServiceClient.Relationships.MANAGE_GROUPS);
            Set<MemberGroup> manageGroups = client.getManageGroups();
            Long groupId = params.getGroupId();
            if (groupId == null || groupId.intValue() <= 0) {
                group = manageGroups.iterator().next();
            } else {
                group = (MemberGroup)this.groupServiceLocal.load(groupId, new Relationship[0]);
                if (!manageGroups.contains(group)) {
                    throw new Exception();
                }
            }
        }
        catch (Exception e) {
            throw new EntityNotFoundException();
        }
        MemberUser user = new MemberUser();
        user.setUsername(params.getUsername());
        Member member = new Member();
        member.setGroup(group);
        member.setUser(user);
        member.setName(params.getName());
        member.setEmail(params.getEmail());
        List<MemberCustomField> fields = this.memberCustomFieldServiceLocal.list();
        fields = this.customFieldHelper.onlyForGroup(fields, group);
        Collection<MemberCustomFieldValue> fieldValues = this.customFieldHelper.toValueCollection(fields, params.getFields());
        member.setCustomValues(fieldValues);
        return member;
    }

    public MyProfileVO toMyProfileVO(Member member) {
        if (!member.isActive() || member.getGroup().getStatus() == Group.Status.REMOVED) {
            throw new EntityNotFoundException();
        }
        List<MemberCustomField> fields = this.customFieldHelper.onlyOwnedFields(this.memberCustomFieldServiceLocal.list(), member.getMemberGroup());
        MyProfileVO vo = this.toVO(MyProfileVO.class, member, fields, fields, true);
        HashSet<String> hiddenFields = new HashSet<String>();
        for (MemberCustomFieldValue fieldValue : member.getCustomValues()) {
            CustomField field = fieldValue.getField();
            if (!fields.contains(field) || !fieldValue.isHidden()) continue;
            hiddenFields.add(field.getInternalName());
        }
        vo.setHiddenFields(hiddenFields);
        return vo;
    }

    public MemberQuery toQuery(MemberSearchParameters params) {
        MemberGroup[] groups;
        GroupFilter[] groupFilters;
        if (params == null) {
            return null;
        }
        MemberQuery query = new MemberQuery();
        query.setEnabled(true);
        query.fetch(Element.Relationships.GROUP, Element.Relationships.USER);
        if (params.getShowCustomFields()) {
            query.fetch(Member.Relationships.CUSTOM_VALUES);
        }
        if (params.getShowImages()) {
            query.fetch(Member.Relationships.IMAGES);
        }
        if ((groupFilters = (GroupFilter[])EntityHelper.references(GroupFilter.class, params.getGroupFilterIds())) == null || groupFilters.length > 0) {
            query.setGroupFilters(Arrays.asList(groupFilters));
        }
        if ((groups = (MemberGroup[])EntityHelper.references(MemberGroup.class, params.getGroupIds())) == null || groups.length > 0) {
            query.setGroups(Arrays.asList(groups));
        }
        query.setUsername(params.getUsername());
        query.setName(params.getName());
        query.setEmail(params.getEmail());
        query.setWithImagesOnly(params.getWithImagesOnly());
        query.setRandomOrder(params.getRandomOrder());
        if (params.getExcludeLoggedIn() && LoggedUser.isMember()) {
            query.setExcludeElements(Collections.singleton(LoggedUser.element()));
        }
        this.queryHelper.fill(params, query);
        List<FieldValueVO> fields = params.getFields();
        if (fields != null && fields.size() > 0) {
            query.setCustomValues(this.customFieldHelper.toValueCollection(this.memberCustomFieldServiceLocal.list(), fields));
        }
        return query;
    }

    public MemberResultPage toResultPage(List<Member> members, final boolean useCustomFields, final boolean useImages) {
        final List allFields = this.memberCustomFieldServiceLocal.list();
        final HashMap fieldsByGroup = new HashMap();
        return this.queryHelper.toResultPage(MemberResultPage.class, members, new Transformer<Member, MemberVO>(){

            @Override
            public MemberVO transform(Member member) {
                MemberGroup memberGroup = member.getMemberGroup();
                List<MemberCustomField> fields = null;
                if (useCustomFields && (fields = (List<MemberCustomField>)fieldsByGroup.get(memberGroup)) == null) {
                    fields = MemberHelper.this.customFieldHelper.onlyForGroup(allFields, memberGroup);
                    fieldsByGroup.put(memberGroup, fields);
                }
                return MemberHelper.this.toVO(member, fields, useImages);
            }
        });
    }

    public MemberVO toVO(Member member) {
        return this.toVO(member, null, false);
    }

    public MemberVO toVO(Member member, Collection<MemberCustomField> fields, Collection<MemberCustomField> requiredFields, boolean useImages) {
        return this.toVO(MemberVO.class, member, fields, requiredFields, useImages);
    }

    public MemberVO toVO(Member member, List<MemberCustomField> fields, boolean useImages) {
        HashSet<MemberCustomField> requiredFields = null;
        Channel channel = WebServiceContext.getChannel();
        if (channel != null && !CollectionUtils.isEmpty(fields)) {
            Collection<ChannelPrincipal> principals = channel.getPrincipals();
            for (ChannelPrincipal principal : principals) {
                MemberCustomField customField = principal.getCustomField();
                if (customField == null || !fields.contains(customField)) continue;
                if (requiredFields == null) {
                    requiredFields = new HashSet<MemberCustomField>();
                }
                requiredFields.add(customField);
            }
        }
        return this.toVO(member, fields, requiredFields, useImages);
    }

    private <VO extends MemberVO> VO toVO(Class<VO> voType, Member member, Collection<MemberCustomField> fields, Collection<MemberCustomField> requiredFields, boolean useImages) {
        MemberVO vo;
        if (member == null) {
            return null;
        }
        try {
            vo = (MemberVO)voType.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        vo.setId(member.getId());
        vo.setName(member.getName());
        vo.setUsername(member.getUsername());
        vo.setEmail(member.getEmail());
        vo.setGroupId(member.getGroup().getId());
        if (fields != null) {
            Collection<MemberCustomFieldValue> customValues = ((Member)this.elementServiceLocal.load(member.getId(), Member.Relationships.CUSTOM_VALUES)).getCustomValues();
            vo.setFields(this.fieldHelper.toList(fields, requiredFields, customValues));
        } else {
            List<FieldValueVO> empty = Collections.emptyList();
            vo.setFields(empty);
        }
        if (useImages) {
            vo.setImages(this.imageHelper.toVOs(member.getImages()));
        }
        return (VO)vo;
    }
}

