/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.webservices.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.MemberAccount;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.TransactionFee;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentRequestTicket;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferQuery;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferTypeQuery;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomField;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomFieldValue;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.exceptions.UnexpectedEntityException;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.services.ServiceClient;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.access.exceptions.BlockedCredentialsException;
import nl.strohalm.cyclos.services.access.exceptions.InvalidCredentialsException;
import nl.strohalm.cyclos.services.access.exceptions.InvalidUserForChannelException;
import nl.strohalm.cyclos.services.access.exceptions.UserNotFoundException;
import nl.strohalm.cyclos.services.accounts.AccountServiceLocal;
import nl.strohalm.cyclos.services.customization.PaymentCustomFieldServiceLocal;
import nl.strohalm.cyclos.services.elements.MemberServiceLocal;
import nl.strohalm.cyclos.services.services.ServiceClientServiceLocal;
import nl.strohalm.cyclos.services.settings.SettingsServiceLocal;
import nl.strohalm.cyclos.services.transactions.DoPaymentDTO;
import nl.strohalm.cyclos.services.transactions.TransactionContext;
import nl.strohalm.cyclos.services.transactions.exceptions.MaxAmountPerDayExceededException;
import nl.strohalm.cyclos.services.transactions.exceptions.NotEnoughCreditsException;
import nl.strohalm.cyclos.services.transactions.exceptions.UpperCreditLimitReachedException;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeServiceLocal;
import nl.strohalm.cyclos.utils.CustomFieldHelper;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import nl.strohalm.cyclos.webservices.WebServiceContext;
import nl.strohalm.cyclos.webservices.model.FieldValueVO;
import nl.strohalm.cyclos.webservices.model.TransactionFeeVO;
import nl.strohalm.cyclos.webservices.payments.AbstractPaymentParameters;
import nl.strohalm.cyclos.webservices.payments.AccountHistoryParams;
import nl.strohalm.cyclos.webservices.payments.PaymentParameters;
import nl.strohalm.cyclos.webservices.payments.PaymentStatus;
import nl.strohalm.cyclos.webservices.payments.RequestPaymentParameters;
import nl.strohalm.cyclos.webservices.utils.ChannelHelper;
import nl.strohalm.cyclos.webservices.utils.CurrencyHelper;
import nl.strohalm.cyclos.webservices.utils.MemberHelper;
import nl.strohalm.cyclos.webservices.utils.QueryHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.springframework.dao.DataIntegrityViolationException;

public class PaymentHelper {
    private ChannelHelper channelHelper;
    private PaymentCustomFieldServiceLocal paymentCustomFieldServiceLocal;
    private CurrencyHelper currencyHelper;
    private TransferTypeServiceLocal transferTypeServiceLocal;
    private ServiceClientServiceLocal serviceClientServiceLocal;
    private MemberHelper memberHelper;
    private MemberServiceLocal memberServiceLocal;
    private AccountServiceLocal accountServiceLocal;
    private QueryHelper queryHelper;
    private CustomFieldHelper customFieldHelper;
    private SettingsServiceLocal settingsServiceLocal;

    public Collection<TransferType> listPossibleTypes(DoPaymentDTO dto) {
        String channel = this.channelHelper.restricted();
        if (StringUtils.isEmpty((String)channel)) {
            return Collections.emptyList();
        }
        Member member = WebServiceContext.getMember();
        ServiceClient client = WebServiceContext.getClient();
        TransferTypeQuery query = new TransferTypeQuery();
        query.setResultType(QueryParameters.ResultType.LIST);
        query.setContext(TransactionContext.PAYMENT);
        query.setChannel(channel);
        query.setFromOwner(dto.getFrom());
        query.setToOwner(dto.getTo());
        query.setCurrency(dto.getCurrency());
        List<TransferType> transferTypes = this.transferTypeServiceLocal.search(query);
        boolean doPayment = true;
        if (member != null) {
            doPayment = member.equals(dto.getFrom());
        }
        Set<TransferType> possibleTypes = doPayment ? this.serviceClientServiceLocal.load(client.getId(), ServiceClient.Relationships.DO_PAYMENT_TYPES).getDoPaymentTypes() : this.serviceClientServiceLocal.load(client.getId(), ServiceClient.Relationships.RECEIVE_PAYMENT_TYPES).getReceivePaymentTypes();
        transferTypes.retainAll(possibleTypes);
        return transferTypes;
    }

    public Member resolveFromMember(AbstractPaymentParameters paymentParameters) throws EntityNotFoundException {
        String principalType = paymentParameters.getFromMemberPrincipalType();
        String principal = paymentParameters.getFromMember();
        return this.resolveMember(principalType, principal, paymentParameters instanceof PaymentParameters && CollectionUtils.isNotEmpty(((PaymentParameters)paymentParameters).getFromMemberFieldsToReturn()));
    }

    public Member resolveToMember(AbstractPaymentParameters paymentParameters) throws EntityNotFoundException {
        String principalType = paymentParameters.getToMemberPrincipalType();
        String principal = paymentParameters.getToMember();
        return this.resolveMember(principalType, principal, paymentParameters instanceof PaymentParameters && CollectionUtils.isNotEmpty(((PaymentParameters)paymentParameters).getToMemberFieldsToReturn()));
    }

    public void setAccountServiceLocal(AccountServiceLocal accountServiceLocal) {
        this.accountServiceLocal = accountServiceLocal;
    }

    public void setChannelHelper(ChannelHelper channelHelper) {
        this.channelHelper = channelHelper;
    }

    public void setCurrencyHelper(CurrencyHelper currencyHelper) {
        this.currencyHelper = currencyHelper;
    }

    public void setCustomFieldHelper(CustomFieldHelper customFieldHelper) {
        this.customFieldHelper = customFieldHelper;
    }

    public void setMemberHelper(MemberHelper memberHelper) {
        this.memberHelper = memberHelper;
    }

    public void setMemberServiceLocal(MemberServiceLocal memberServiceLocal) {
        this.memberServiceLocal = memberServiceLocal;
    }

    public void setPaymentCustomFieldServiceLocal(PaymentCustomFieldServiceLocal paymentCustomFieldService) {
        this.paymentCustomFieldServiceLocal = paymentCustomFieldService;
    }

    public void setQueryHelper(QueryHelper queryHelper) {
        this.queryHelper = queryHelper;
    }

    public void setServiceClientServiceLocal(ServiceClientServiceLocal serviceClientService) {
        this.serviceClientServiceLocal = serviceClientService;
    }

    public void setSettingsServiceLocal(SettingsServiceLocal settingsService) {
        this.settingsServiceLocal = settingsService;
    }

    public void setTransferTypeServiceLocal(TransferTypeServiceLocal transferTypeService) {
        this.transferTypeServiceLocal = transferTypeService;
    }

    public DoPaymentDTO toExternalPaymentDTO(AbstractPaymentParameters params, AccountOwner from, AccountOwner to) {
        if (params == null) {
            return null;
        }
        DoPaymentDTO dto = new DoPaymentDTO();
        dto.setAmount(params.getAmount());
        dto.setCurrency(this.currencyHelper.resolve(params.getCurrency()));
        dto.setDescription(params.getDescription());
        dto.setFrom(from == null ? this.resolveFromMember(params) : from);
        dto.setTo(to == null ? this.resolveToMember(params) : to);
        if (params.getTraceNumber() != null && params.getTraceNumber().trim().equals("")) {
            throw new ValidationException();
        }
        dto.setTraceNumber(params.getTraceNumber());
        dto.setTraceData(params.getTraceData());
        if (params instanceof RequestPaymentParameters) {
            RequestPaymentParameters request = (RequestPaymentParameters)params;
            String destinationChannel = request.getDestinationChannel();
            dto.setChannel(destinationChannel);
            if (destinationChannel == null) {
                dto.setChannel(this.channelHelper.restricted());
            }
        } else if (params instanceof PaymentParameters) {
            PaymentParameters payment = (PaymentParameters)params;
            dto.setChannel(this.channelHelper.restricted());
            Long transferTypeId = payment.getTransferTypeId();
            if (transferTypeId != null && transferTypeId <= 0L) {
                throw new ValidationException();
            }
            TransferType transferType = null;
            if (transferTypeId != null) {
                transferType = this.transferTypeServiceLocal.load(transferTypeId, new Relationship[0]);
            }
            if (transferType == null) {
                Collection<TransferType> possibleTypes = this.listPossibleTypes(dto);
                if (possibleTypes.isEmpty()) {
                    throw new UnexpectedEntityException();
                }
                transferType = possibleTypes.iterator().next();
            }
            dto.setTransferType(transferType);
            List<FieldValueVO> fieldValueVOs = payment.getCustomValues();
            List<PaymentCustomField> allowedFields = this.paymentCustomFieldServiceLocal.list(transferType, true);
            Collection<PaymentCustomFieldValue> customValues = this.customFieldHelper.toValueCollection(allowedFields, fieldValueVOs);
            dto.setCustomValues(customValues);
            if (StringUtils.isEmpty((String)payment.getDescription())) {
                dto.setDescription(transferType.getDescription());
            }
        }
        if (dto.getFrom().equals(dto.getTo())) {
            dto.setContext(TransactionContext.SELF_PAYMENT);
        } else {
            dto.setContext(TransactionContext.AUTOMATIC);
        }
        return dto;
    }

    public PaymentStatus toStatus(Throwable error) {
        if (error instanceof InvalidCredentialsException) {
            return PaymentStatus.INVALID_CREDENTIALS;
        }
        if (error instanceof BlockedCredentialsException) {
            return PaymentStatus.BLOCKED_CREDENTIALS;
        }
        if (error instanceof InvalidUserForChannelException) {
            return PaymentStatus.INVALID_CHANNEL;
        }
        if (error instanceof NotEnoughCreditsException) {
            return PaymentStatus.NOT_ENOUGH_CREDITS;
        }
        if (error instanceof UpperCreditLimitReachedException) {
            return PaymentStatus.RECEIVER_UPPER_CREDIT_LIMIT_REACHED;
        }
        if (error instanceof MaxAmountPerDayExceededException) {
            return PaymentStatus.MAX_DAILY_AMOUNT_EXCEEDED;
        }
        if (error instanceof IllegalArgumentException || error instanceof ValidationException || error instanceof UnexpectedEntityException || error instanceof EntityNotFoundException || error instanceof UserNotFoundException) {
            return PaymentStatus.INVALID_PARAMETERS;
        }
        if (ExceptionUtils.indexOfThrowable((Throwable)error, DataIntegrityViolationException.class) != -1) {
            return PaymentStatus.INVALID_PARAMETERS;
        }
        return PaymentStatus.UNKNOWN_ERROR;
    }

    public PaymentStatus toStatus(Transfer transfer) {
        if (transfer.getProcessDate() == null) {
            return PaymentStatus.PENDING_AUTHORIZATION;
        }
        return PaymentStatus.PROCESSED;
    }

    public PaymentRequestTicket toTicket(RequestPaymentParameters params, TransferType transferType) {
        if (params == null) {
            return null;
        }
        String description = params.getDescription();
        if (StringUtils.isEmpty((String)description) && transferType != null) {
            description = transferType.getDescription();
        }
        PaymentRequestTicket ticket = new PaymentRequestTicket();
        ticket.setTraceData(params.getTraceData());
        ticket.setFromChannel(WebServiceContext.getChannel());
        Channel toChannel = this.channelHelper.get(params.getDestinationChannel());
        if (toChannel == null) {
            toChannel = ticket.getFromChannel();
        }
        ticket.setToChannel(toChannel);
        ticket.setAmount(params.getAmount());
        ticket.setTransferType(transferType);
        ticket.setDescription(description);
        ticket.setCurrency(this.currencyHelper.resolve(params.getCurrency()));
        return ticket;
    }

    public List<TransactionFeeVO> toTransactionFeeVOs(Map<TransactionFee, BigDecimal> fees) {
        if (fees == null) {
            return null;
        }
        ArrayList<TransactionFeeVO> result = new ArrayList<TransactionFeeVO>(fees.size());
        LocalSettings localSettings = this.settingsServiceLocal.getLocalSettings();
        for (Map.Entry<TransactionFee, BigDecimal> entry : fees.entrySet()) {
            TransactionFee key = entry.getKey();
            BigDecimal value = entry.getValue();
            String formattedAmount = localSettings.getUnitsConverter(key.getGeneratedTransferType().getCurrency().getPattern()).toString(value);
            TransactionFeeVO transactionFeeVO = new TransactionFeeVO(key.getName(), value, formattedAmount);
            result.add(transactionFeeVO);
        }
        return result;
    }

    public TransferQuery toTransferQuery(AccountHistoryParams params) {
        Member member = this.memberServiceLocal.loadByIdOrPrincipal(params.getMemberId(), null, params.getMemberPrincipal());
        TransferQuery query = new TransferQuery();
        this.queryHelper.fill(params, query);
        MemberAccount account = null;
        account = EntityHelper.isValidId(params.getMemberAccountId()) ? (MemberAccount)this.accountServiceLocal.load(params.getMemberAccountId(), new Relationship[0]) : this.accountServiceLocal.getDefaultAccount();
        query.setOwner(account.getOwner());
        query.setType(account.getType());
        query.setPeriod(Period.between(params.getBeginDate(), params.getEndDate()));
        query.setMember(member);
        query.setReverseOrder(true);
        List<PaymentCustomField> fieldsForSearch = this.paymentCustomFieldServiceLocal.listForSearch(account, false);
        query.setCustomValues(this.customFieldHelper.toValueCollection(fieldsForSearch, params.getCustomValues()));
        return query;
    }

    private Member resolveMember(String principalType, String principal, boolean requiredFields) throws EntityNotFoundException {
        if (requiredFields) {
            return this.memberHelper.loadByPrincipal(principalType, principal, Member.Relationships.CUSTOM_VALUES);
        }
        return this.memberHelper.loadByPrincipal(principalType, principal, new Relationship[0]);
    }
}

