/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.webservices.utils;

import java.util.ArrayList;
import java.util.List;
import nl.strohalm.cyclos.utils.conversion.Transformer;
import nl.strohalm.cyclos.utils.query.Page;
import nl.strohalm.cyclos.utils.query.PageParameters;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import nl.strohalm.cyclos.webservices.model.ResultPage;
import nl.strohalm.cyclos.webservices.model.SearchParameters;

public class QueryHelper {
    private static final int MAX_PAGE_SIZE = 100;

    public void fill(SearchParameters searchParameters, QueryParameters query) {
        if (query != null) {
            query.setResultType(QueryParameters.ResultType.PAGE);
            int pageSize = searchParameters.getPageSize();
            if (pageSize > 100) {
                pageSize = 100;
            }
            query.setPageParameters(new PageParameters(pageSize, searchParameters.getCurrentPage()));
        }
    }

    public <In, Out, P extends ResultPage<Out>> P toResultPage(Class<P> resultType, List<In> input, Transformer<In, Out> transformer) {
        ResultPage result;
        try {
            result = (ResultPage)resultType.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        if (input instanceof Page) {
            Page page = (Page)input;
            result.setCurrentPage(page.getCurrentPage());
            result.setTotalCount(page.getTotalCount());
            result.setPageSize(page.getPageSize());
        }
        ArrayList<Out> list = new ArrayList<Out>(input == null ? 0 : input.size());
        if (input != null) {
            for (In in : input) {
                Out out = transformer.transform(in);
                if (out == null) continue;
                list.add(out);
            }
        }
        result.setElements(list);
        return (P)result;
    }
}

