/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.webservices.utils;

import java.util.Collection;
import java.util.List;
import nl.strohalm.cyclos.entities.access.MemberUser;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentRequestTicket;
import nl.strohalm.cyclos.entities.accounts.transactions.Ticket;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.accounts.transactions.WebShopTicket;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.customization.MemberCustomFieldServiceLocal;
import nl.strohalm.cyclos.services.elements.ElementServiceLocal;
import nl.strohalm.cyclos.services.settings.SettingsServiceLocal;
import nl.strohalm.cyclos.utils.CustomFieldHelper;
import nl.strohalm.cyclos.webservices.WebServiceContext;
import nl.strohalm.cyclos.webservices.model.PaymentRequestTicketVO;
import nl.strohalm.cyclos.webservices.model.TicketVO;
import nl.strohalm.cyclos.webservices.model.WebShopTicketVO;
import nl.strohalm.cyclos.webservices.utils.CurrencyHelper;
import nl.strohalm.cyclos.webservices.utils.MemberHelper;
import nl.strohalm.cyclos.webservices.webshop.GenerateWebShopTicketParams;

public class TicketHelper {
    private MemberCustomFieldServiceLocal memberCustomFieldServiceLocal;
    private SettingsServiceLocal settingsServiceLocal;
    private ElementServiceLocal elementServiceLocal;
    private CurrencyHelper currencyHelper;
    private MemberHelper memberHelper;
    private CustomFieldHelper customFieldHelper;

    public void setCurrencyHelper(CurrencyHelper currencyHelper) {
        this.currencyHelper = currencyHelper;
    }

    public void setCustomFieldHelper(CustomFieldHelper customFieldHelper) {
        this.customFieldHelper = customFieldHelper;
    }

    public void setElementServiceLocal(ElementServiceLocal elementService) {
        this.elementServiceLocal = elementService;
    }

    public void setMemberCustomFieldServiceLocal(MemberCustomFieldServiceLocal memberCustomFieldService) {
        this.memberCustomFieldServiceLocal = memberCustomFieldService;
    }

    public void setMemberHelper(MemberHelper memberHelper) {
        this.memberHelper = memberHelper;
    }

    public void setSettingsServiceLocal(SettingsServiceLocal settingsService) {
        this.settingsServiceLocal = settingsService;
    }

    public WebShopTicket toTicket(GenerateWebShopTicketParams params) {
        if (params == null) {
            return null;
        }
        WebShopTicket ticket = new WebShopTicket();
        ticket.setAmount(params.getAmount());
        ticket.setCurrency(this.currencyHelper.resolve(params.getCurrency()));
        ticket.setClientAddress(params.getClientAddress());
        ticket.setDescription(params.getDescription());
        ticket.setReturnUrl(params.getReturnUrl());
        Member restricted = WebServiceContext.getMember();
        if (restricted != null) {
            ticket.setTo(restricted);
        } else {
            try {
                Object user = this.elementServiceLocal.loadUser(params.getToUsername(), User.Relationships.ELEMENT);
                if (!(user instanceof MemberUser)) {
                    throw new IllegalArgumentException("Invalid username: " + params.getToUsername() + ". It isn't an instance of MemberUser");
                }
                ticket.setTo(((MemberUser)user).getMember());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid member: " + params.getToUsername());
            }
        }
        return ticket;
    }

    public PaymentRequestTicketVO toVO(PaymentRequestTicket ticket, Collection<MemberCustomField> requiredCustomFields) {
        if (ticket == null) {
            return null;
        }
        PaymentRequestTicketVO vo = new PaymentRequestTicketVO();
        this.fill(ticket, vo, true, requiredCustomFields);
        vo.setFromChannel(ticket.getFromChannel().getInternalName());
        vo.setToChannel(ticket.getToChannel().getInternalName());
        vo.setTraceData(ticket.getTraceData());
        return vo;
    }

    public WebShopTicketVO toVO(WebShopTicket ticket, Collection<MemberCustomField> requiredCustomFields) {
        if (ticket == null) {
            return null;
        }
        WebShopTicketVO vo = new WebShopTicketVO();
        this.fill(ticket, vo, false, requiredCustomFields);
        vo.setMemberAddress(ticket.getMemberAddress());
        vo.setClientAddress(ticket.getClientAddress());
        vo.setReturnUrl(ticket.getReturnUrl());
        return vo;
    }

    private void fill(Ticket ticket, TicketVO vo, boolean onlyBasicCustomFields, Collection<MemberCustomField> requiredCustomFields) {
        List<MemberCustomField> fields;
        Transfer transfer = ticket.getTransfer();
        Currency currency = ticket.getCurrency();
        if (currency == null && ticket.getTransferType() != null) {
            currency = ticket.getTransferType().getFrom().getCurrency();
        }
        LocalSettings localSettings = this.settingsServiceLocal.getLocalSettings();
        vo.setId(ticket.getId());
        vo.setTicket(ticket.getTicket());
        vo.setAwaitingAuthorization(transfer != null && transfer.getStatus() == Payment.Status.PENDING);
        boolean isAwaitingAuthorization = vo.getAwaitingAuthorization();
        vo.setOk(!isAwaitingAuthorization && ticket.getStatus() == Ticket.Status.OK);
        vo.setCancelled(ticket.getStatus() == Ticket.Status.CANCELLED);
        vo.setExpired(ticket.getStatus() == Ticket.Status.EXPIRED);
        vo.setPending(ticket.getStatus() == Ticket.Status.PENDING);
        List<MemberCustomField> customFields = this.memberCustomFieldServiceLocal.list();
        if (ticket.getFrom() != null) {
            Member from = (Member)this.elementServiceLocal.load(ticket.getFrom().getId(), Element.Relationships.GROUP);
            fields = this.customFieldHelper.onlyForGroup(customFields, from.getMemberGroup());
            if (onlyBasicCustomFields) {
                fields = this.customFieldHelper.onlyBasic(fields);
            }
            vo.setFromMember(this.memberHelper.toVO(from, fields, requiredCustomFields, false));
        }
        if (ticket.getTo() != null) {
            Member to = (Member)this.elementServiceLocal.load(ticket.getTo().getId(), Element.Relationships.GROUP);
            fields = this.customFieldHelper.onlyForGroup(customFields, to.getMemberGroup());
            if (onlyBasicCustomFields) {
                fields = this.customFieldHelper.onlyBasic(fields);
            }
            vo.setToMember(this.memberHelper.toVO(to, fields, requiredCustomFields, false));
        }
        vo.setAmount(ticket.getAmount());
        if (currency == null) {
            vo.setFormattedAmount(localSettings.getNumberConverter().toString(ticket.getAmount()));
        } else {
            vo.setFormattedAmount(localSettings.getUnitsConverter(currency.getPattern()).toString(ticket.getAmount()));
        }
        vo.setDescription(ticket.getDescription());
        vo.setCreationDate(ticket.getCreationDate());
        vo.setFormattedCreationDate(localSettings.getDateTimeConverter().toString(ticket.getCreationDate()));
    }
}

