/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.webservices.utils;

import java.util.Collection;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.accounts.pos.Pos;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.exceptions.QueryParseException;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.services.ServiceClient;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.access.exceptions.BlockedCredentialsException;
import nl.strohalm.cyclos.services.access.exceptions.InvalidCredentialsException;
import nl.strohalm.cyclos.utils.logging.LoggingHandler;
import nl.strohalm.cyclos.utils.logging.WebServiceLogDTO;
import nl.strohalm.cyclos.utils.transaction.CurrentTransactionData;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import nl.strohalm.cyclos.webservices.WebServiceContext;
import nl.strohalm.cyclos.webservices.WebServiceFault;
import nl.strohalm.cyclos.webservices.WebServiceFaultsEnum;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.security.AccessDeniedException;

public class WebServiceHelper {
    private static final String CODE_PREFIX = "cyclos";
    private LoggingHandler loggingHandler;

    public static SoapFault fault(Throwable exception) {
        Class<? extends Entity> entityType;
        WebServiceFaultsEnum fault = exception instanceof ValidationException || exception instanceof IllegalArgumentException ? WebServiceFaultsEnum.INVALID_PARAMETERS : (exception instanceof EntityNotFoundException ? ((entityType = ((EntityNotFoundException)exception).getEntityType()) != null && (Element.class.isAssignableFrom(entityType) || User.class.isAssignableFrom(entityType)) ? WebServiceFaultsEnum.MEMBER_NOT_FOUND : WebServiceFaultsEnum.INVALID_PARAMETERS) : (exception instanceof QueryParseException ? WebServiceFaultsEnum.QUERY_PARSE_ERROR : (exception instanceof InvalidCredentialsException ? WebServiceFaultsEnum.INVALID_CREDENTIALS : (exception instanceof BlockedCredentialsException ? WebServiceFaultsEnum.BLOCKED_CREDENTIALS : (exception instanceof AccessDeniedException || exception instanceof PermissionDeniedException ? WebServiceFaultsEnum.UNAUTHORIZED_ACCESS : WebServiceFaultsEnum.UNEXPECTED_ERROR)))));
        return WebServiceHelper.fault((WebServiceFault)fault, exception);
    }

    public static SoapFault fault(WebServiceFault fault) {
        return WebServiceHelper.fault(fault.code(), null);
    }

    public static SoapFault fault(WebServiceFault fault, String serverDetailsMessage) {
        return WebServiceHelper.fault(fault, (Throwable)new Exception(serverDetailsMessage));
    }

    public static SoapFault fault(WebServiceFault fault, Throwable cause) {
        return WebServiceHelper.fault(fault.code(), cause);
    }

    public static String[] getCredentials(HttpServletRequest request) {
        String header = request.getHeader("Authorization");
        if (StringUtils.isEmpty((String)header)) {
            return null;
        }
        String[] parts = header.split("\\s");
        if (parts.length != 2) {
            return null;
        }
        String method = parts[0];
        String credentials = parts[1];
        if (method.equalsIgnoreCase("basic")) {
            credentials = new String(Base64.decodeBase64((byte[])credentials.getBytes()));
        } else if (!method.equalsIgnoreCase("user")) {
            return null;
        }
        return credentials.split(":", 2);
    }

    public static <T> T getParameter(SoapMessage message) {
        List parameterValues = (List)message.getContent(List.class);
        if (CollectionUtils.isNotEmpty((Collection)parameterValues)) {
            return (T)parameterValues.iterator().next();
        }
        return (T)message.getContent(Object.class);
    }

    public static void initializeContext(Pos pos, SoapMessage message) {
        WebServiceContext.set(pos, WebServiceHelper.servletContextOf(message), WebServiceHelper.requestOf(message), message);
    }

    public static void initializeContext(ServiceClient client, SoapMessage message) {
        WebServiceContext.set(client, WebServiceHelper.servletContextOf(message), WebServiceHelper.requestOf(message), message);
    }

    public static void initializeContext(SoapMessage message) {
        WebServiceContext.set(WebServiceHelper.servletContextOf(message), WebServiceHelper.requestOf(message), message);
    }

    public static boolean isCurrentClient(Long clientId) {
        if (WebServiceContext.getContextType() != WebServiceContext.ContextType.SERVICE_CLIENT) {
            return false;
        }
        return ObjectUtils.equals((Object)WebServiceContext.getClient().getId(), (Object)clientId);
    }

    public static boolean isFromCyclos(Fault fault) {
        return CODE_PREFIX.equals(fault.getFaultCode().getNamespaceURI());
    }

    public static HttpServletRequest requestOf(SoapMessage message) {
        return (HttpServletRequest)message.get((Object)"HTTP.REQUEST");
    }

    public static ServletContext servletContextOf(SoapMessage message) {
        return (ServletContext)message.get((Object)"HTTP.CONTEXT");
    }

    private static SoapFault fault(String code, Throwable th) throws SoapFault {
        return new SoapFault("Server error: " + code, th, WebServiceHelper.faultCode(code));
    }

    private static QName faultCode(String code) {
        return new QName(CODE_PREFIX, code);
    }

    public void error(String error) {
        this.error(new Exception(error), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(Throwable th) {
        ValidationException valExc = null;
        try {
            if (th instanceof ValidationException) {
                valExc = (ValidationException)th;
                valExc.setShowDetailMessage(true);
            }
            this.error(th, true);
        }
        finally {
            if (valExc != null) {
                valExc.setShowDetailMessage(false);
            }
        }
    }

    public void setLoggingHandler(LoggingHandler loggingHandler) {
        this.loggingHandler = loggingHandler;
    }

    public void trace(String message) {
        WebServiceLogDTO log = WebServiceContext.newLog();
        log.setMessage(message);
        this.loggingHandler.traceWebService(log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void error(Throwable th, boolean logStackTrace) {
        try {
            WebServiceLogDTO log = WebServiceContext.newLog();
            if (logStackTrace) {
                log.setError(th);
            } else {
                log.setErrorMessage(th.getMessage());
            }
            this.loggingHandler.traceWebService(log);
        }
        finally {
            if (th instanceof Fault && th.getCause() != null) {
                CurrentTransactionData.setError(th.getCause());
            } else {
                CurrentTransactionData.setError(th);
            }
        }
    }
}

