/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.webservices.webshop;

import javax.jws.WebService;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.transactions.WebShopTicket;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.transactions.TicketServiceLocal;
import nl.strohalm.cyclos.webservices.WebServiceContext;
import nl.strohalm.cyclos.webservices.model.WebShopTicketVO;
import nl.strohalm.cyclos.webservices.utils.TicketHelper;
import nl.strohalm.cyclos.webservices.utils.WebServiceHelper;
import nl.strohalm.cyclos.webservices.webshop.GenerateWebShopTicketParams;
import nl.strohalm.cyclos.webservices.webshop.WebShopWebService;

@WebService(name="webshop", serviceName="webshop")
public class WebShopWebServiceImpl
implements WebShopWebService {
    private TicketServiceLocal ticketServiceLocal;
    private TicketHelper ticketHelper;
    private WebServiceHelper webServiceHelper;

    @Override
    public String generate(GenerateWebShopTicketParams params) {
        try {
            HttpServletRequest request = WebServiceContext.getRequest();
            WebShopTicket ticket = this.ticketHelper.toTicket(params);
            ticket.setMemberAddress(request.getRemoteAddr());
            WebShopTicket object = this.ticketServiceLocal.generate(ticket);
            return object.getTicket();
        }
        catch (Exception e) {
            this.webServiceHelper.error(e);
            return null;
        }
    }

    @Override
    public WebShopTicketVO get(String ticket) {
        try {
            WebShopTicket object = (WebShopTicket)this.ticketServiceLocal.load(ticket, new Relationship[0]);
            Member restricted = WebServiceContext.getMember();
            if (restricted != null && !restricted.equals(object.getTo())) {
                throw new IllegalArgumentException("Error getting webshop ticket: the target member ('to') of the webshop ticket is not the restricted one");
            }
            return this.ticketHelper.toVO(object, WebServiceContext.getChannel().getPrincipalCustomFields());
        }
        catch (Exception e) {
            this.webServiceHelper.error(e);
            return null;
        }
    }

    public void setTicketHelper(TicketHelper ticketHelper) {
        this.ticketHelper = ticketHelper;
    }

    public void setTicketServiceLocal(TicketServiceLocal ticketService) {
        this.ticketServiceLocal = ticketService;
    }

    public void setWebServiceHelper(WebServiceHelper webServiceHelper) {
        this.webServiceHelper = webServiceHelper;
    }
}

