/*
 * Decompiled with CFR 0.152.
 */
package com.mullassery.imaging;

import com.mullassery.imaging.ImageTransformer;
import com.mullassery.imaging.util.TransformerUtil;
import com.mullassery.imaging.util.Util;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

public abstract class AbstractTransformer
implements ImageTransformer {
    public BufferedImage resize(BufferedImage bufferedImage, int n, int n2) {
        return this.resize(bufferedImage, n, n2, false);
    }

    public BufferedImage resize(BufferedImage bufferedImage, int n, int n2, boolean bl) {
        float f = (float)n / (float)bufferedImage.getWidth();
        float f2 = (float)n2 / (float)bufferedImage.getHeight();
        if (bl) {
            if (f <= f2) {
                return this.scale(bufferedImage, f, f);
            }
            return this.scale(bufferedImage, f2, f2);
        }
        return this.scale(bufferedImage, f, f2);
    }

    public BufferedImage scale(BufferedImage bufferedImage, float f) {
        return this.scale(bufferedImage, f, f);
    }

    public BufferedImage textOverlay(BufferedImage bufferedImage, String string, int n, int n2, Font font, Color color) {
        return this.textOverlay(bufferedImage, string, n, n2, bufferedImage.getWidth() - n, font, color, true);
    }

    public BufferedImage textOverlay(BufferedImage bufferedImage, String string, int n, int n2, int n3, Font font, Color color, boolean bl) {
        BufferedImage bufferedImage2 = Util.duplicate(bufferedImage);
        TransformerUtil.textOverlay(bufferedImage2, string, n, n2, n3, font, color, null, bl);
        return bufferedImage2;
    }

    public BufferedImage textOverlay(BufferedImage bufferedImage, String string, int n, int n2, int n3, Font font, BufferedImage bufferedImage2, boolean bl) {
        BufferedImage bufferedImage3 = Util.duplicate(bufferedImage);
        TransformerUtil.textOverlay(bufferedImage3, string, n, n2, n3, font, null, bufferedImage2, bl);
        return bufferedImage3;
    }

    public BufferedImage textButton(BufferedImage bufferedImage, String string, int n, int n2, int n3, int n4, int n5, Font font, BufferedImage bufferedImage2, boolean bl) {
        BufferedImage bufferedImage3 = Util.duplicate(bufferedImage);
        int n6 = n + n3;
        int n7 = n2 + n4;
        n5 = n5 + n6 > bufferedImage3.getWidth() ? bufferedImage3.getWidth() - n6 : n5;
        Rectangle rectangle = TransformerUtil.textOverlay(bufferedImage3, string, n, n2, n5, font, null, bufferedImage2, bl);
        return this.crop(bufferedImage3, 0.0f, 0.0f, rectangle.width + n6, rectangle.height + n7);
    }

    public BufferedImage textButton(BufferedImage bufferedImage, String string, int n, int n2, int n3, int n4, int n5, Font font, Color color, boolean bl) {
        BufferedImage bufferedImage2 = Util.duplicate(bufferedImage);
        int n6 = n + n3;
        int n7 = n2 + n4;
        n5 = n5 + n6 > bufferedImage2.getWidth() ? bufferedImage2.getWidth() - n6 : n5;
        Rectangle rectangle = TransformerUtil.textOverlay(bufferedImage2, string, n, n2, n5, font, color, null, bl);
        return this.crop(bufferedImage2, 0.0f, 0.0f, rectangle.width + n6, rectangle.height + n7);
    }

    public BufferedImage htmlOverlay(BufferedImage bufferedImage, String string, int n, int n2, int n3, int n4, boolean bl) {
        BufferedImage bufferedImage2 = Util.duplicate(bufferedImage);
        TransformerUtil.htmlOverlay(bufferedImage2, string, n, n2, n3, n4, true);
        return bufferedImage2;
    }

    public BufferedImage addTransparency(BufferedImage bufferedImage, int n) {
        return TransformerUtil.addTransparency(bufferedImage, n);
    }

    public BufferedImage overlay(BufferedImage bufferedImage, BufferedImage bufferedImage2, int n, int n2) {
        return this.overlay(bufferedImage, bufferedImage2, n, n2, null, 5);
    }

    public BufferedImage flip(BufferedImage bufferedImage, int n) {
        BufferedImage bufferedImage2 = Util.createSimilar(bufferedImage, bufferedImage.getWidth(), bufferedImage.getHeight());
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        if (n == 0) {
            graphics2D.drawImage(bufferedImage, bufferedImage.getWidth(), 0, -bufferedImage.getWidth(), bufferedImage.getHeight(), null);
        } else {
            graphics2D.drawImage(bufferedImage, 0, bufferedImage.getHeight(), bufferedImage.getWidth(), -bufferedImage.getHeight(), null);
        }
        return bufferedImage2;
    }

    public abstract /* synthetic */ BufferedImage convolve(BufferedImage var1, float[] var2);

    public abstract /* synthetic */ BufferedImage grayscale(BufferedImage var1, double var2);

    public abstract /* synthetic */ BufferedImage border(BufferedImage var1, int var2, int var3, Color var4);

    public abstract /* synthetic */ BufferedImage overlay(BufferedImage var1, BufferedImage var2, int var3, int var4, Color var5, int var6);

    public abstract /* synthetic */ BufferedImage rotate(BufferedImage var1, float var2);

    public abstract /* synthetic */ BufferedImage scale(BufferedImage var1, float var2, float var3);

    public abstract /* synthetic */ BufferedImage crop(BufferedImage var1, float var2, float var3, float var4, float var5);

    public abstract /* synthetic */ void setImagingQuality(int var1);
}

