/*
 * Decompiled with CFR 0.152.
 */
package com.mullassery.imaging;

import com.mullassery.imaging.AbstractTransformer;
import com.mullassery.imaging.ImageLoader;
import com.mullassery.imaging.Imaging;
import com.mullassery.imaging.ImagingImpl;
import com.mullassery.imaging.jai.JAILoader;
import com.mullassery.imaging.jai.JAITransformer;
import com.mullassery.imaging.java2d.AWTLoader;
import com.mullassery.imaging.java2d.ImageIOLoader;
import com.mullassery.imaging.java2d.Java2DTransformer;

public class ImagingFactory {
    public static final int JAI = 0;
    public static final int JAVA2D = 1;
    public static final int JAI_TRANSFORMER = 2;
    public static final int JAVA2D_TRANSFORMER = 3;
    public static final int AWT_LOADER = 4;
    public static final int IMAGEIO_LOADER = 5;
    public static final int JAI_LOADER = 6;

    public static Imaging createImagingInstance(int n, int n2) {
        AbstractTransformer abstractTransformer = null;
        ImageLoader imageLoader = null;
        switch (n2) {
            case 2: {
                abstractTransformer = new JAITransformer();
                break;
            }
            case 3: {
                abstractTransformer = new Java2DTransformer();
                break;
            }
            default: {
                throw new IllegalArgumentException(n2 + " Imaging type is unknown.");
            }
        }
        switch (n) {
            case 4: {
                imageLoader = new AWTLoader();
                break;
            }
            case 5: {
                imageLoader = new ImageIOLoader();
                break;
            }
            case 6: {
                imageLoader = new JAILoader();
                break;
            }
            default: {
                throw new IllegalArgumentException(n + " Loader type is unknown.");
            }
        }
        return new ImagingImpl(imageLoader, abstractTransformer);
    }

    public static Imaging createImagingInstance(int n) {
        switch (n) {
            case 0: {
                return ImagingFactory.createImagingInstance(6, 2);
            }
            case 1: {
                try {
                    Class.forName("javax.imageio.ImageIO");
                    return ImagingFactory.createImagingInstance(5, 3);
                }
                catch (Exception exception) {
                    return ImagingFactory.createImagingInstance(4, 3);
                }
            }
        }
        throw new IllegalArgumentException(n + " Imaging type is unknown.");
    }

    public static Imaging createImagingInstance() {
        try {
            Class.forName("javax.media.jai.JAI");
            return ImagingFactory.createImagingInstance(0);
        }
        catch (Exception exception) {
            return ImagingFactory.createImagingInstance(1);
        }
    }
}

