/*
 * Decompiled with CFR 0.152.
 */
package com.mullassery.imaging.jai;

import com.mullassery.imaging.Imaging;
import com.mullassery.imaging.ImagingFactory;
import com.mullassery.imaging.VisualTestCase;
import com.mullassery.imaging.jai.JAITransformer;
import com.mullassery.imaging.util.Util;
import java.awt.Color;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import junit.framework.Assert;

public class JAIImagingTest
extends VisualTestCase {
    private Imaging jai;
    private URL url1;
    private URL url2;
    private URL url_gif;

    protected void setUp() throws Exception {
        this.jai = ImagingFactory.createImagingInstance(0);
        this.url1 = Util.getFileURL(new File("images/colors.png"));
        this.url2 = Util.getFileURL(new File("images/splash.jpg"));
        this.url_gif = Util.getFileURL(new File("images/colors.png"));
    }

    protected void tearDown() throws Exception {
        this.jai = null;
    }

    public final void testLoading() {
        try {
            BufferedImage bufferedImage = this.jai.read(new FileInputStream(new File("images/splash.jpg")));
            BufferedImage bufferedImage2 = this.jai.read(new File("images/new.png"));
            BufferedImage bufferedImage3 = this.jai.read(new File("images/new.gif"));
            this.checkImage(new BufferedImage[]{bufferedImage, bufferedImage2, bufferedImage3}, "Has it loaded the Images?");
        }
        catch (FileNotFoundException fileNotFoundException) {
            Assert.fail((String)fileNotFoundException.getMessage());
        }
    }

    public final void testResize() {
        BufferedImage bufferedImage = this.jai.read(this.url2);
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        float f = 0.8f;
        BufferedImage bufferedImage2 = this.jai.scale(bufferedImage, f);
        int n3 = bufferedImage2.getWidth();
        int n4 = bufferedImage2.getHeight();
        int n5 = (int)((float)n * f) - n3;
        int n6 = (int)((float)n2 * f) - n4;
        Assert.assertTrue((n5 < 2 && n5 > -2 ? 1 : 0) != 0);
        Assert.assertTrue((n6 < 2 && n6 > -2 ? 1 : 0) != 0);
        this.checkImage(new BufferedImage[]{bufferedImage, bufferedImage2}, "Has it resized (" + f + ")?");
        bufferedImage2 = this.jai.resize(bufferedImage, 800, n2 / 2, true);
        this.checkImage(new BufferedImage[]{bufferedImage, bufferedImage2}, "Has it resized to 50%?");
    }

    public final void testCrop() {
        BufferedImage bufferedImage = this.jai.read(this.url2);
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        BufferedImage bufferedImage2 = this.jai.crop(bufferedImage, 20.0f, 20.0f, n - 40, n2 - 40);
        int n3 = bufferedImage2.getWidth();
        int n4 = bufferedImage2.getHeight();
        int n5 = n - n3;
        int n6 = n2 - n4;
        Assert.assertTrue((n5 == 40 ? 1 : 0) != 0);
        Assert.assertTrue((n6 == 40 ? 1 : 0) != 0);
        this.checkImage(new BufferedImage[]{bufferedImage, bufferedImage2}, "Has it cropped?");
    }

    public final void testRotate() {
        BufferedImage bufferedImage = this.jai.read(this.url_gif);
        BufferedImage bufferedImage2 = this.jai.rotate(bufferedImage, Util.degrees2Radians(45.0f));
        this.checkImage(new BufferedImage[]{bufferedImage, bufferedImage2}, "Has it rotated by 45 Deg about its center?");
        bufferedImage2 = this.jai.rotate(bufferedImage, Util.degrees2Radians(-45.0f));
        this.checkImage(new BufferedImage[]{bufferedImage, bufferedImage2}, "Has it rotated by -45 Deg about its top-left?");
    }

    public final void testBorder() {
        BufferedImage bufferedImage = this.jai.read(this.url_gif);
        BufferedImage bufferedImage2 = this.jai.border(bufferedImage, 10, 5, Color.red);
        this.checkImage(new BufferedImage[]{bufferedImage, bufferedImage2}, "Has a border been added?");
    }

    public final void testOverlay() {
        BufferedImage bufferedImage = this.jai.read(this.url_gif);
        BufferedImage bufferedImage2 = this.jai.read(this.url2);
        Color color = Color.red;
        BufferedImage bufferedImage3 = this.jai.overlay(bufferedImage2, bufferedImage, 20, 20);
        this.checkImage(new BufferedImage[]{bufferedImage3}, "Has it overlaid the image?");
        bufferedImage3 = this.jai.overlay(bufferedImage2, bufferedImage, 20, 20, color, 30);
        this.checkImage(new BufferedImage[]{bufferedImage3}, "Has it overlaid the image without the red parts?");
    }

    public final void testGrayscale() {
        BufferedImage bufferedImage = this.jai.read(this.url2);
        BufferedImage bufferedImage2 = this.jai.grayscale(bufferedImage, 0.5);
        this.checkImage(new BufferedImage[]{bufferedImage2}, "Was the image converted to grayscale?");
    }

    public final void testTextOverlay() {
        BufferedImage bufferedImage = this.jai.read(this.url2);
        BufferedImage bufferedImage2 = this.jai.textOverlay(bufferedImage, "A sample text overlaid!", 5, 20, Font.getFont("Arial"), Color.BLUE);
        this.checkImage(new BufferedImage[]{bufferedImage2}, "Was the text overlaid?");
    }

    public final void testLoad() {
        BufferedImage bufferedImage = this.jai.read(this.url1);
        Assert.assertNotNull((Object)bufferedImage);
    }

    public final void testGetFileURL() throws MalformedURLException {
        URL uRL = new URL("file:" + new File("JAITestFile.txt").getAbsolutePath());
        Assert.assertEquals((Object)uRL, (Object)Util.getFileURL(new File("JAITestFile.txt")));
    }

    public final void testTransform() {
        BufferedImage bufferedImage = this.jai.read(this.url2);
        String string = null;
        BufferedImage bufferedImage2 = null;
        string = "MedianFilter";
        bufferedImage2 = JAITransformer.transform(string, bufferedImage, null);
        this.checkImage(new BufferedImage[]{bufferedImage, bufferedImage2}, "Has it " + string + "ed the image?");
    }

    public final void testTransformMultiple() {
        BufferedImage bufferedImage = this.jai.read(this.url1);
        BufferedImage bufferedImage2 = this.jai.read(this.url2);
        BufferedImage bufferedImage3 = null;
        String string = null;
        string = "AddCollection";
        bufferedImage3 = JAITransformer.transform(string, new BufferedImage[]{bufferedImage2, bufferedImage}, null);
        this.checkImage(new BufferedImage[]{bufferedImage, bufferedImage2, bufferedImage3}, "Has it " + string + "ed the images?");
    }

    public final void testConvolveBlur() {
        BufferedImage bufferedImage = this.jai.read(this.url2);
        BufferedImage bufferedImage2 = this.jai.convolve(bufferedImage, new float[]{0.0625f, 0.125f, 0.0625f, 0.125f, 0.25f, 0.125f, 0.0625f, 0.125f, 0.0625f});
        Assert.assertTrue((bufferedImage2 != null ? 1 : 0) != 0);
        this.checkImage(new BufferedImage[]{bufferedImage, bufferedImage2}, "Was the image blurred?");
    }

    public final void testConvolveSharpen() throws FileNotFoundException {
        BufferedImage bufferedImage = this.jai.read(new FileInputStream("images/splash.jpg"));
        BufferedImage bufferedImage2 = this.jai.convolve(bufferedImage, new float[]{-1.0f, -1.0f, -1.0f, -1.0f, 9.0f, -1.0f, -1.0f, -1.0f, -1.0f});
        Assert.assertTrue((bufferedImage2 != null ? 1 : 0) != 0);
        this.checkImage(new BufferedImage[]{bufferedImage, bufferedImage2}, "Was the image sharpened?");
    }

    public final void testConvolveSharpenMore() {
        BufferedImage bufferedImage = this.jai.read(this.url2);
        BufferedImage bufferedImage2 = this.jai.convolve(bufferedImage, new float[]{-2.0f, -2.0f, -2.0f, -2.0f, 17.0f, -2.0f, -2.0f, -2.0f, -2.0f});
        Assert.assertTrue((bufferedImage2 != null ? 1 : 0) != 0);
        this.checkImage(new BufferedImage[]{bufferedImage, bufferedImage2}, "Was the image sharpened more?");
    }
}

