/*
 * Decompiled with CFR 0.152.
 */
package com.mullassery.imaging.jai;

import com.mullassery.imaging.AbstractTransformer;
import com.mullassery.imaging.util.TransformerUtil;
import com.mullassery.imaging.util.Util;
import java.awt.Color;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.Vector;
import javax.media.jai.BorderExtender;
import javax.media.jai.BorderExtenderConstant;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.KernelJAI;
import javax.media.jai.PlanarImage;

public class JAITransformer
extends AbstractTransformer {
    private static final RenderingHints borderCopyRH = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1));
    private Interpolation interpolation = Interpolation.getInstance((int)0);

    private static final void addParameters(ParameterBlock parameterBlock, Object[] objectArray) {
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                parameterBlock.add(objectArray[i]);
            }
        }
    }

    public static final BufferedImage transform(String string, BufferedImage bufferedImage, Object[] objectArray) {
        Util.checkTransformation(string, null);
        Util.checkImage(bufferedImage, null);
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(PlanarImage.wrapRenderedImage((RenderedImage)bufferedImage));
        JAITransformer.addParameters(parameterBlock, objectArray);
        return JAI.create((String)string, (ParameterBlock)parameterBlock, (RenderingHints)borderCopyRH).getAsBufferedImage();
    }

    public static final BufferedImage transform(String string, RenderedImage renderedImage, RenderedImage renderedImage2, Object[] objectArray) {
        Util.checkTransformation(string, null);
        Util.checkImage(renderedImage, null);
        Util.checkImage(renderedImage2, null);
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(PlanarImage.wrapRenderedImage((RenderedImage)renderedImage));
        parameterBlock.addSource(PlanarImage.wrapRenderedImage((RenderedImage)renderedImage2));
        JAITransformer.addParameters(parameterBlock, objectArray);
        return JAI.create((String)string, (ParameterBlock)parameterBlock, (RenderingHints)borderCopyRH).getAsBufferedImage();
    }

    public static final BufferedImage transform(String string, RenderedImage[] renderedImageArray, Object[] objectArray) {
        if (renderedImageArray == null || renderedImageArray.length == 0) {
            throw new IllegalArgumentException("Cannot apply transformation without any Images!");
        }
        Util.checkTransformation(string, null);
        Util.checkImage(renderedImageArray[0], null);
        ParameterBlock parameterBlock = new ParameterBlock();
        Vector<PlanarImage> vector = new Vector<PlanarImage>();
        for (int i = 0; i < renderedImageArray.length; ++i) {
            vector.add(PlanarImage.wrapRenderedImage((RenderedImage)renderedImageArray[i]));
        }
        parameterBlock.addSource(vector);
        JAITransformer.addParameters(parameterBlock, objectArray);
        return JAI.create((String)string, (ParameterBlock)parameterBlock, (RenderingHints)borderCopyRH).getAsBufferedImage();
    }

    public BufferedImage border(BufferedImage bufferedImage, int n, int n2, Color color) {
        if (color == null) {
            color = Color.BLACK;
        }
        int n3 = color.getAlpha();
        int n4 = color.getRed();
        int n5 = color.getGreen();
        int n6 = color.getBlue();
        double[] dArray = new double[]{n4, n5, n6, n3};
        return JAITransformer.transform("Border", bufferedImage, new Object[]{new Integer(n), new Integer(n), new Integer(n2), new Integer(n2), new BorderExtenderConstant(dArray)});
    }

    public BufferedImage crop(BufferedImage bufferedImage, float f, float f2, float f3, float f4) {
        return JAITransformer.transform("crop", bufferedImage, new Object[]{new Float(f), new Float(f2), new Float(f3), new Float(f4), this.interpolation});
    }

    public BufferedImage grayscale(BufferedImage bufferedImage, double d) {
        d = d < 0.0 || d > 1.0 ? 0.5 : d;
        Object object = null;
        if (bufferedImage.getSampleModel().getNumBands() == 1) {
            double[][] dArrayArray = new double[][]{{0.114, d}};
            object = dArrayArray;
        } else if (bufferedImage.getSampleModel().getNumBands() == 2) {
            double[][] dArrayArray = new double[][]{{0.114, 0.299, d}, {0.114, 0.299, d}};
            object = dArrayArray;
        } else if (bufferedImage.getSampleModel().getNumBands() == 3) {
            double[][] dArrayArray = new double[][]{{0.114, 0.587, 0.299, d}, {0.114, 0.587, 0.299, d}, {0.114, 0.587, 0.299, d}};
            object = dArrayArray;
        } else if (bufferedImage.getSampleModel().getNumBands() == 4) {
            double[][] dArrayArray = new double[][]{{0.114, 0.587, 0.299, 0.0, d}, {0.114, 0.587, 0.299, 0.0, d}, {0.114, 0.587, 0.299, 0.0, d}, {0.114, 0.587, 0.299, 0.0, d}};
            object = dArrayArray;
        } else {
            new IllegalArgumentException("Only images with >5 bands are supported.");
        }
        return JAITransformer.transform("BandCombine", bufferedImage, new Object[]{object});
    }

    public BufferedImage overlay(BufferedImage bufferedImage, BufferedImage bufferedImage2, int n, int n2, Color color, int n3) {
        if (color == null) {
            if (bufferedImage.getType() != 2) {
                bufferedImage = Util.createBufferedImage(bufferedImage, "PNG");
            }
            if (bufferedImage2.getType() != 2) {
                bufferedImage2 = Util.createBufferedImage(bufferedImage2, "PNG");
            }
            ParameterBlock parameterBlock = new ParameterBlock();
            parameterBlock.addSource(bufferedImage2);
            parameterBlock.add(new Float(n));
            parameterBlock.add(new Float(n2));
            return JAITransformer.transform("Overlay", bufferedImage, (RenderedImage)JAI.create((String)"Translate", (ParameterBlock)parameterBlock, (RenderingHints)borderCopyRH), new Object[0]);
        }
        return TransformerUtil.overlay(bufferedImage, bufferedImage2, n, n2, color, n3);
    }

    public BufferedImage rotate(BufferedImage bufferedImage, float f) {
        return JAITransformer.transform("rotate", bufferedImage, new Object[]{new Float(0.0f), new Float(0.0f), new Float(f), this.interpolation});
    }

    public BufferedImage scale(BufferedImage bufferedImage, float f, float f2) {
        if (f == 0.0f || f2 == 0.0f) {
            throw new IllegalArgumentException("Cannot scale Image to zero scale [" + f + ", " + f2 + "] !");
        }
        return JAITransformer.transform("scale", bufferedImage, new Object[]{new Float(f), new Float(f2), new Float(0.0f), new Float(0.0f), this.interpolation});
    }

    public void setImagingQuality(int n) {
        switch (n) {
            case 0: {
                this.interpolation = Interpolation.getInstance((int)1);
                break;
            }
            case 1: {
                this.interpolation = Interpolation.getInstance((int)2);
                break;
            }
            case 2: {
                this.interpolation = Interpolation.getInstance((int)0);
                break;
            }
            default: {
                this.interpolation = Interpolation.getInstance((int)1);
            }
        }
    }

    public BufferedImage convolve(BufferedImage bufferedImage, float[] fArray) {
        int n = (int)Math.sqrt(fArray.length);
        KernelJAI kernelJAI = new KernelJAI(n, n, fArray);
        return JAITransformer.transform("Convolve", bufferedImage, new Object[]{kernelJAI});
    }
}

