/*
 * Decompiled with CFR 0.152.
 */
package com.mullassery.imaging.java2d;

import com.mullassery.imaging.ImageLoader;
import com.mullassery.imaging.util.Util;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImagingOpException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ImageIcon;
import sun.awt.image.codec.JPEGImageEncoderImpl;

public class AWTLoader
implements ImageLoader {
    public BufferedImage read(File file) {
        return this.read(file.getAbsolutePath());
    }

    public BufferedImage read(String string) {
        URL uRL;
        try {
            uRL = Util.getFileURL(new File(string));
        }
        catch (MalformedURLException malformedURLException) {
            throw new ImagingOpException(malformedURLException.getMessage());
        }
        return this.read(uRL);
    }

    public BufferedImage read(URL uRL) {
        Image image = new ImageIcon(uRL).getImage();
        return Util.createBufferedImage(image, Util.getExtentionType(uRL.toString()));
    }

    public BufferedImage read(InputStream inputStream) {
        BufferedInputStream bufferedInputStream = null;
        byte[] byArray = null;
        try {
            bufferedInputStream = new BufferedInputStream(inputStream);
            byArray = new byte[bufferedInputStream.available()];
            bufferedInputStream.read(byArray);
            Image image = new ImageIcon(byArray).getImage();
            BufferedImage bufferedImage = Util.createBufferedImage(image, "GIF");
            return bufferedImage;
        }
        catch (Exception exception) {
            throw new ImagingOpException(exception.getMessage());
        }
        finally {
            try {
                bufferedInputStream.close();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(BufferedImage bufferedImage, OutputStream outputStream, String string, float f) {
        if (!string.equalsIgnoreCase("JPEG")) {
            if (!string.equalsIgnoreCase("JPG")) throw new IllegalArgumentException("AWT supports only writing of JPEG files. Need additonal libraries such as JAI, ImageIO, etc to write more types");
        }
        JPEGImageEncoderImpl jPEGImageEncoderImpl = new JPEGImageEncoderImpl(outputStream);
        JPEGEncodeParam jPEGEncodeParam = jPEGImageEncoderImpl.getDefaultJPEGEncodeParam(bufferedImage);
        jPEGEncodeParam.setQuality(f, true);
        try {
            try {
                jPEGImageEncoderImpl.encode(bufferedImage);
            }
            catch (Exception exception) {
                throw new ImagingOpException("Error while writing Image. " + exception.getMessage());
            }
            Object var9_7 = null;
            if (outputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            if (outputStream == null) throw throwable;
            try {
                outputStream.flush();
                outputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        outputStream.flush();
        outputStream.close();
        return;
    }

    public void write(BufferedImage bufferedImage, String string, String string2, float f) {
        try {
            this.write(bufferedImage, new FileOutputStream(string), string2, f);
        }
        catch (Exception exception) {
            throw new ImagingOpException(exception.getMessage());
        }
    }
}

